/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.export;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Trip;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIModel;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.export.ExportModel;
import fr.ird.observe.ui.admin.export.ExportUI;
import fr.ird.observe.ui.admin.export.TripEntry;
import fr.ird.observe.ui.admin.export.TripToExportTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.editor.MyDefaultCellEditor;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class ExportUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ExportUIHandler.class);

    public ExportUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, ExportUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getPrepareAction().setText(I18n.t((String)"observe.action.synchro.prepare.operation", (Object[])new Object[]{I18n.t((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        tabUI.getStartAction().setText(I18n.t((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n.t((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        final SelectDataUI selectTabUI = (SelectDataUI)ui.getStepUI(AdminStep.SELECT_DATA);
        tabUI.getModel().addPropertyChangeListener("selectionModelChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AdminUIModel model = (AdminUIModel)((Object)evt.getSource());
                DataSelectionModel value = (DataSelectionModel)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("selection model changed to " + value));
                }
                selectTabUI.getSelectionModel().clearSelection();
                selectTabUI.getSelectionRenderer().setExistingTripIds(model.getExportModel().getExistingTripIds());
                ExportUIHandler.this.updateSelectionModel(selectTabUI);
            }
        });
        final JTable table4 = tabUI.getTrips();
        table4.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table4, (int)0, (int)20);
        UIHelper.fixTableColumnWidth((JTable)table4, (int)3, (int)20);
        DefaultTableCellRenderer renderer5 = new DefaultTableCellRenderer();
        UIHelper.setI18nTableHeaderRenderer((JTable)table4, (String[])new String[]{I18n.n((String)"observe.synchro.table.exportData.selected", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.exportData.selected.tip", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.exportData.program.label", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.exportData.program.label.tip", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.exportData.trip.label", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.exportData.trip.label.tip", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.exportData.exist.label", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.exportData.exist.label.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table4, (int)0, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer5));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer5, Program.class));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer5, TripSeine.class));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)3, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer5));
        UIHelper.setTableColumnEditor((JTable)table4, (int)0, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor((boolean)false));
        table4.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colIndex = table4.getTableHeader().columnAtPoint(e.getPoint());
                if ((colIndex = table4.convertColumnIndexToModel(colIndex)) == 0) {
                    TripToExportTableModel model;
                    boolean oldValue = (model = (TripToExportTableModel)table4.getModel()).isSelectAll();
                    model.setSelectAll(!oldValue);
                }
            }
        });
    }

    public void updateState(ExportUI tabUI, WizardState newState) {
        super.updateState(tabUI, newState);
        if (newState == WizardState.NEED_FIX) {
            tabUI.tripsModel.init(tabUI.getStepModel().getData());
            return;
        }
        if (newState == WizardState.RUNNING) {
            // empty if block
        }
    }

    public void doPrepareAction() {
        this.addAdminWorker(((ExportUI)this.ui).getPrepareAction().getToolTipText(), new Callable<WizardState>(){

            @Override
            public WizardState call() throws Exception {
                return ExportUIHandler.this.prepareAction();
            }
        });
    }

    public void doStartAction() {
        ExportUI tabUI = (ExportUI)this.ui;
        int[] rows = tabUI.getTripsModel().getSelected();
        tabUI.getModel().getExportModel().setExportDataSelectedIndex(rows);
        this.addAdminWorker(tabUI.getStartAction().getToolTipText(), new Callable<WizardState>(){

            @Override
            public WizardState call() throws Exception {
                return ExportUIHandler.this.doAction();
            }
        });
    }

    public WizardState prepareAction() throws Exception {
        DecoratorService decoratorProvider = this.getDecoratorService();
        ExportModel stepModel = this.model.getExportModel();
        Decorator pDecorator = decoratorProvider.getDecoratorByType(Program.class);
        Decorator tripLonglineDecorator = decoratorProvider.getDecoratorByType(TripLongline.class);
        Decorator tripSeineDecorator = decoratorProvider.getDecoratorByType(TripSeine.class);
        stepModel.setProgramDecorator((Decorator<Program>)pDecorator);
        stepModel.setTripSeineDecorator((Decorator<TripSeine>)tripSeineDecorator);
        stepModel.setTripLonglineDecorator((Decorator<TripLongline>)tripLonglineDecorator);
        DataSource centralSource = this.model.getSafeCentralSource(false);
        stepModel.setCentralSource(centralSource);
        if (!centralSource.canWriteData()) {
            this.sendMessage(I18n.t((String)"observe.message.can.not.write.data", (Object[])new Object[0]));
            return WizardState.FAILED;
        }
        DataSource source = this.getSource();
        stepModel.setSource(source);
        this.openSource(centralSource);
        this.openSource(source);
        this.sendMessage(I18n.t((String)"observe.message.exportData.prepare.data", (Object[])new Object[0]));
        DataSelectionModel selectionModel = this.model.getSelectionDataModel();
        stepModel.setData(selectionModel);
        List<TripEntry> entries = stepModel.getData();
        if (entries.isEmpty()) {
            this.sendMessage(I18n.t((String)"observe.message.exportData.not.possible", (Object[])new Object[0]));
            this.sendMessage(I18n.t((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
            return WizardState.CANCELED;
        }
        this.sendMessage(I18n.t((String)"observe.message.exportData.operation.needFix", (Object[])new Object[]{new Date()}));
        return WizardState.NEED_FIX;
    }

    public WizardState doAction() throws Exception {
        ExportModel stepModel = this.model.getExportModel();
        List<TripEntry> tripEntries = stepModel.getSelectedTrips();
        for (TripEntry tripEntry : tripEntries) {
            this.processTrip(stepModel, tripEntry);
        }
        this.sendMessage(I18n.t((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    protected void processTrip(ExportModel stepModel, TripEntry tripEntry) throws Exception {
        DataSource centralSource = stepModel.getCentralSource();
        DataSource source = stepModel.getSource();
        Trip trip = tripEntry.getTrip();
        String tripId = trip.getTopiaId();
        String tripDecorated = stepModel.decorate(trip);
        String programDecorated = stepModel.decorate(trip.getProgram());
        if (tripEntry.isExist()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(tripId + " -- " + I18n.t((String)"observe.message.exportData.delete.remote.maree", (Object[])new Object[]{tripDecorated, programDecorated})));
            }
            this.sendMessage(I18n.t((String)"observe.message.exportData.delete.remote.maree", (Object[])new Object[]{tripDecorated, programDecorated}));
            this.getDataService().deleteTrip(centralSource, tripId);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(tripId + " -- " + I18n.t((String)"observe.message.exportData.replicate.maree", (Object[])new Object[]{tripDecorated, programDecorated})));
        }
        this.sendMessage(I18n.t((String)"observe.message.exportData.replicate.maree", (Object[])new Object[]{tripDecorated, programDecorated}));
        this.replicateData(source, centralSource, tripId);
    }
}

