/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.nuiton.i18n.I18n;

public class ImportStorageFromFileAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final ObserveMainUI ui;

    public ImportStorageFromFileAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.load.from.file", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"local-import"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.load.from.file.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 73);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean canContinue = ObserveContext.get().closeSelectedContentUI(this.ui);
        if (canContinue) {
            new StorageUILauncher((JAXXContext)this.ui, this.ui, I18n.t((String)"observe.title.import.localDB", (Object[])new Object[0])){

                @Override
                protected void init(StorageUI ui) {
                    super.init(ui);
                    StorageUIModel model = ui.getModel();
                    model.setCanCreateLocalService(true);
                    model.setCanUseLocalService(false);
                    model.setCanUseRemoteService(false);
                    model.setDbMode(DbMode.CREATE_LOCAL);
                    model.setCreationMode(CreationMode.IMPORT_EXTERNAL_DUMP);
                    if (model.isLocalStorageExist()) {
                        model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.BACKUP, StorageStep.CONFIRM});
                        model.setDoBackup(true);
                    } else {
                        model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.CONFIRM});
                    }
                }

                @Override
                protected void doAction(StorageUI ui) {
                    super.doAction(ui);
                    StorageUIHandler handler = this.getStorageUIHandler();
                    handler.doChangeStorage((JAXXContext)ui, ui.getModel());
                }
            }.start();
        }
    }
}

