/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.constants.ReferenceLocale;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUICallback;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangeDbLanguageAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ChangeDbLanguageAction.class);
    private final ObserveMainUI ui;
    private final ReferenceLocale newLocale;

    public ChangeDbLanguageAction(ObserveMainUI ui, ReferenceLocale newLocale, String name, String description) {
        super(name, SwingUtil.getUIManagerActionIcon((String)("i18n-" + newLocale.getLocale().getLanguage())));
        this.ui = ui;
        this.newLocale = newLocale;
        this.putValue("ShortDescription", description);
        this.putValue("MnemonicKey", newLocale.getLocale().getLanguage().toUpperCase().charAt(0));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe changing db language...");
        }
        if (!(canContinue = ObserveContext.get().closeSelectedContentUI(this.ui))) {
            return;
        }
        ObserveConfig config = this.ui.getConfig();
        config.setOption(ObserveConfigOption.DB_LOCALE, this.newLocale.getLocale());
        ObserveUICallback.ui.run();
    }
}

