/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUICallback;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangeApplicationLanguageAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ChangeApplicationLanguageAction.class);
    private final ObserveMainUI ui;
    private final Locale newLocale;

    public ChangeApplicationLanguageAction(ObserveMainUI ui, Locale newLocale, String name, String description) {
        super(name, SwingUtil.getUIManagerActionIcon((String)("i18n-" + newLocale.getLanguage())));
        this.ui = ui;
        this.newLocale = newLocale;
        this.putValue("ShortDescription", description);
        this.putValue("MnemonicKey", newLocale.getLanguage().toUpperCase().charAt(0));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe changing application language...");
        }
        if (canContinue = ObserveContext.get().closeSelectedContentUI(this.ui)) {
            ObserveConfig config = this.ui.getConfig();
            config.setOption(ObserveConfigOption.LOCALE, this.newLocale);
            ObserveUICallback.ui.run();
        }
    }
}

