/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.longline.SetLonglineUI;
import fr.ird.observe.ui.content.impl.longline.SetLonglineUIModel;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.Date;
import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class SetLonglineUIHandler
extends ContentUIHandler<SetLongline> {
    private static Log log = LogFactory.getLog(SetLonglineUIHandler.class);
    protected final TableModelListener computeTabValidStateListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            SwingValidatorMessageTableModel source = (SwingValidatorMessageTableModel)e.getSource();
            SetLonglineUIHandler.this.computeTabValidState(source);
        }
    };

    public SetLonglineUIHandler(SetLonglineUI ui) {
        super(ui, DataContextType.ActivitySeine, DataContextType.SetLongline);
    }

    public SetLonglineUI getUi() {
        return (SetLonglineUI)super.getUi();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String setId = this.getSelectedId();
        if (setId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(ActivityLongline.class)) {
            return ContentMode.UPDATE;
        }
        SetLonglineUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.activityLongline.message.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("OpenUI: " + this.getModel()));
        }
        super.openUI();
        String activityId = this.getSelectedParentId();
        String setId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
            log.info((Object)("setId      = " + setId));
        }
        ContentMode mode = this.computeContentMode();
        DataService dataService = this.getDataService();
        SetLongline bean = (SetLongline)this.getBean();
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (setId == null) {
            dataService.preCreate(source, activityId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, setId, this.getLoadExecutor());
        }
        this.setContentMode(mode);
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
        this.getUi().getErrorTableModel().addTableModelListener(this.computeTabValidStateListener);
        SwingValidatorMessageTableModel errorTableModel = this.getUi().getErrorTableModel();
        this.computeTabValidState(errorTableModel);
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    protected void closeSafeUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("CloseUI: " + this.getModel()));
        }
        super.closeSafeUI();
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
    }

    @Override
    protected SetLongline onPreCreate(TopiaContext tx, Object parent, SetLongline bean) throws TopiaException {
        ActivityLongline parentBean = (ActivityLongline)parent;
        Date timeStamp = parentBean.getTimeStamp();
        bean.setSettingStartTimeStamp(timeStamp);
        bean.setSettingEndTimeStamp(DateUtils.addHours((Date)timeStamp, (int)1));
        bean.setHaulingStartTimeStamp(DateUtils.addHours((Date)timeStamp, (int)2));
        bean.setHaulingEndTimeStamp(DateUtils.addHours((Date)timeStamp, (int)3));
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        this.getUi().getValidator().setContext(contextName);
        if (create) {
            this.addInfoMessage(I18n.t((String)"observe.setLongline.message.creating", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.t((String)"observe.setLongline.message.updating", (Object[])new Object[0]));
        }
        super.startEditUI("comment2.text", "homeId.text", "number.model", "settingStartTimeStamp.date", "settingStartCoordinates.latitude", "settingStartCoordinates.longitude", "settingStartCoordinates.quadrant", "settingEndTimeStamp.date", "settingEndCoordinates.latitude", "settingEndCoordinates.longitude", "settingEndCoordinates.quadrant", "settingVesselSpeed.model", "shooterUsed.selected", "shooterSpeed.model", "timeBetweenHooks.model", "settingShape.selectedItem", "weightedSwivel.selected", "swivelWeight.model", "weightedSnap.selected", "snapWeight.model", "lineType.selectedItem", "maxDepthTargeted.model", "monitored.selected", "lightsticksType.selectedItem", "lightsticksColor.selectedItem", "branchlineLength.model", "tracelineLength.model", "lightsticksPerBasketCount.model", "basketsPerSectionCount.model", "totalBasketsCount.model", "hooksPerBasketCount.model", "totalSectionsCount.model", "totalHooksCount.model", "haulingDirectionSameAsSetting.booleanValue", "haulingStartTimeStamp.date", "haulingStartCoordinates.latitude", "haulingStartCoordinates.longitude", "haulingStartCoordinates.quadrant", "haulingEndTimeStamp.date", "haulingEndCoordinates.latitude", "haulingEndCoordinates.longitude", "haulingEndCoordinates.quadrant", "haulingBreaks.model");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(SetLongline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<SetLongline> binder) throws Exception {
        String activityId = this.getSelectedParentId();
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, activityId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        return true;
    }

    @Override
    protected SetLongline onCreate(TopiaContext tx, Object parent, SetLongline editBean) throws TopiaException {
        ActivityLongline parentBean = (ActivityLongline)parent;
        SetLongline beanToSave = (SetLongline)ObserveDAOHelper.getSetLonglineDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.setSetLongline(beanToSave);
        return beanToSave;
    }

    @Override
    protected SetLongline onUpdate(TopiaContext tx, Object parentBean, SetLongline beanToSave) throws TopiaException {
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"baitsComposition", "floatlinesComposition", "hooksComposition", "branchlinesComposition", "section", "catchLongline", "mitigationType", "tdr"});
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        boolean create;
        super.afterSave(refresh);
        SetLongline bean = (SetLongline)this.getBean();
        SwingValidatorUtil.setValidatorChanged((JAXXObject)this.getUi(), (boolean)false, (String[])new String[0]);
        ObserveTreeHelper treeHelper = SetLonglineUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        boolean bl = create = node.getId() == null;
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
            node = treeHelper.addSet(parentNode, bean);
            this.stopEditUI();
            treeHelper.selectNode((NavNode)node);
        } else {
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected boolean doDelete(SetLongline bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, SetLongline> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        String activityId = this.getSelectedParentId();
        dataService.delete(dataSource, activityId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, SetLongline beanToDelete) throws TopiaException {
        ActivityLongline parentBean = (ActivityLongline)parent;
        ObserveDAOHelper.getSetLonglineDAO((TopiaContext)tx).delete(parentBean.getSetLongline());
        parentBean.setSetLongline(null);
    }

    protected void computeTabValidState(SwingValidatorMessageTableModel errorTableModel) {
        HashSet<String> errorProperties = new HashSet<String>();
        int rowCount = errorTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            SwingValidatorMessage row = errorTableModel.getRow(i);
            if (!NuitonValidatorScope.ERROR.equals((Object)row.getScope())) continue;
            errorProperties.add(row.getField());
        }
        boolean settingTabValid = !errorProperties.removeAll(SetLonglineUIModel.SETTING_TAB_PROPERTIES);
        boolean settingCaracteristicsTabValid = !errorProperties.removeAll(SetLonglineUIModel.SETTING_CARACTERISTICS_TAB_PROPERTIES);
        boolean haulingTabValid = !errorProperties.removeAll(SetLonglineUIModel.HAULING_TAB_PROPERTIES);
        SetLonglineUIModel model = (SetLonglineUIModel)this.getModel();
        model.setSettingTabValid(settingTabValid);
        model.setSettingCaracteristicsTabValid(settingCaracteristicsTabValid);
        model.setHaulingTabValid(haulingTabValid);
    }
}

