/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.table;

import fr.ird.observe.ui.util.table.AbstractEditableTableModel;
import fr.ird.observe.ui.util.table.AbstractSelectTableAction;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoveToNextEditableRowAction<M extends AbstractEditableTableModel>
extends AbstractSelectTableAction<M> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MoveToNextEditableRowAction.class);

    protected MoveToNextEditableRowAction(M model, JTable table) {
        super(model, table);
    }

    public static <M extends AbstractEditableTableModel> MoveToNextEditableRowAction<M> newAction(M model, JTable table) {
        return new MoveToNextEditableRowAction<M>(model, table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int rowCount;
        int currentRow = this.getSelectedRow();
        int currentColumn = this.getSelectedColumn();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Move to next row editable cell " + this.getCellCoordinate(currentRow, currentColumn)));
        }
        if (currentRow < (rowCount = this.getRowCount())) {
            boolean canSelect = true;
            if (++currentRow >= rowCount) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No next row");
                }
                if (this.isCreateNewRow()) {
                    this.addNewRow();
                } else {
                    canSelect = false;
                }
            }
            if (canSelect) {
                this.doSelectCell(currentRow, currentColumn);
            }
        }
    }
}

