/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.Routes;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.seine.TripSeineUI;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.DateUtil;

public class TripSeineUIHandler
extends ContentOpenableUIHandler<TripSeine> {
    private static final Log log = LogFactory.getLog(TripSeineUIHandler.class);

    public TripSeineUIHandler(TripSeineUI ui) {
        super(ui, DataContextType.Program, DataContextType.TripSeine, I18n.n((String)"observe.message.maree.not.open", (Object[])new Object[0]));
    }

    @Override
    public TripSeineUI getUi() {
        return (TripSeineUI)super.getUi();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String mareeId = this.getSelectedId();
        if (mareeId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(TripSeine.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.t((String)this.closeMessage, (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        boolean create;
        super.openUI();
        ContentMode mode = this.computeContentMode();
        String programId = this.getSelectedParentId();
        String mareeId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "programId = " + programId));
            log.info((Object)(this.prefix + "mareeId     = " + mareeId));
            log.info((Object)(this.prefix + "mode        = " + (Object)((Object)mode)));
        }
        DataService dataService = this.getDataService();
        TripSeine bean = (TripSeine)this.getBean();
        DataSource source = this.getDataSource();
        boolean bl = create = mareeId == null;
        if (create) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.prefix + "create a new maree"));
            }
            dataService.preCreate(source, programId, (TopiaEntity)bean, this.getLoadBinder(), this.getPreCreateExecutor());
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.prefix + "using existing maree " + mareeId));
            }
            dataService.loadEditEntity(source, mareeId, this.getLoadExecutor());
            if (!bean.isRouteEmpty()) {
                Routes.sort((List)bean.getRoute());
            }
        }
        this.finalizeOpenUI(mode, create);
    }

    @Override
    protected TripSeine onPreCreate(TopiaContext tx, Object parent, TripSeine bean) throws TopiaException {
        Program parentBean = (Program)parent;
        Date date = DateUtil.getDay((Date)new Date());
        bean.setStartDate(date);
        if (log.isDebugEnabled()) {
            log.debug((Object)("date debut " + date));
            log.debug((Object)("program : " + parentBean));
        }
        bean.setProgram(parentBean);
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        TripSeineUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        ContentMode mode = model.getMode();
        boolean create = mode == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(mode);
        ui.getValidator().setContext(contextName);
        if (create) {
            this.addInfoMessage(I18n.t((String)"observe.message.creating.maree", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.t((String)"observe.message.updating.maree", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)model).isHistoricalData()) {
                this.addInfoMessage(I18n.t((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        }
        if (model.getMode() == ContentMode.UPDATE && ((TripSeine)this.getBean()).getEndDate() == null) {
            Date date = DateUtil.getEndOfDay((Date)new Date());
            ((TripSeine)this.getBean()).setEndDate(date);
            if (log.isDebugEnabled()) {
                log.debug((Object)("date fin " + date));
            }
        }
        super.startEditUI("vessel.selectedItem", "observer.selectedItem", "captain.selectedItem", "dataEntryOperator.selectedItem", "ocean.selectedItem", "seineCircumference.model", "seineDepth.model", "seineBallastWeight.model", "startDate.date", "endDate.date", "comment2.text", "ersId.text", "close.enabled", "closeAndCreate.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(TripSeine bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<TripSeine> binder) throws Exception {
        String programId = this.getDataContext().getSelectedProgramId();
        Date startDate = DateUtil.getDay((Date)bean.getStartDate());
        if (log.isDebugEnabled()) {
            log.debug((Object)("startDate = " + startDate));
        }
        bean.setStartDate(startDate);
        bean.updateDateFin();
        Date endDate = bean.getEndDate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("endDate   = " + endDate));
        }
        bean.setOpen(true);
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, programId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected TripSeine onCreate(TopiaContext tx, Object parent, TripSeine editBean) throws TopiaException {
        TripSeine beanToSave = (TripSeine)ObserveDAOHelper.getTripSeineDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        return beanToSave;
    }

    @Override
    protected TripSeine onUpdate(TopiaContext tx, Object parentBean, TripSeine beanToSave) throws TopiaException {
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"route"});
        return beanToSave;
    }

    @Override
    protected boolean doDelete(TripSeine bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, TripSeine> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete Trip " + bean.getTopiaId()));
        }
        dataService.delete(dataSource, null, (TopiaEntity)bean, deletor);
        if (log.isInfoEnabled()) {
            log.info((Object)("Delete done for Trip " + bean.getTopiaId()));
        }
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parentBean, TripSeine beanToDelete) throws TopiaException {
        TopiaDAO dao = this.getDataSource().getDAO(tx, TripSeine.class);
        dao.delete((TopiaEntity)beanToDelete);
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        return !create && !dataContext.isOpenTrip();
    }
}

