/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.Basket;
import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.entities.longline.CatchLongline;
import fr.ird.observe.entities.longline.Section;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.Species2;
import fr.ird.observe.entities.referentiel.longline.CatchFateLongline;
import fr.ird.observe.entities.referentiel.longline.Healthness;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.longline.CatchAcquisitionModeEnum;
import fr.ird.observe.ui.content.table.impl.longline.CatchLonglineUI;
import fr.ird.observe.ui.content.table.impl.longline.CatchLonglineUIModel;
import fr.ird.observe.ui.content.table.impl.longline.SizeMeasureUI;
import fr.ird.observe.ui.content.table.impl.longline.SizeMeasureUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public class CatchLonglineUIHandler
extends ContentTableUIHandler<SetLongline, CatchLongline> {
    private static Log log = LogFactory.getLog(CatchLonglineUIHandler.class);
    protected final PropertyChangeListener catchFateChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CatchFateLongline newValue = (CatchFateLongline)evt.getNewValue();
            CatchLonglineUI ui = CatchLonglineUIHandler.this.getUi();
            if (newValue == null || !"fr.ird.observe.entities.referentiel.longline.CatchFateLongline#1239832686125#0.3".equals(newValue.getTopiaId())) {
                ui.getDiscardHealthness().setEnabled(false);
                ui.getHookWhenDiscarded().setEnabled(false);
                ((CatchLongline)CatchLonglineUIHandler.this.getTableEditBean()).setHookWhenDiscarded(null);
                ((CatchLongline)CatchLonglineUIHandler.this.getTableEditBean()).setDiscardHealthness(null);
            } else {
                ui.getDiscardHealthness().setEnabled(true);
                ui.getHookWhenDiscarded().setEnabled(true);
            }
        }
    };
    protected final PropertyChangeListener depredatedChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Boolean newValue = (Boolean)evt.getNewValue();
            CatchLonglineUI ui = CatchLonglineUIHandler.this.getUi();
            CatchLongline tableEditBean = (CatchLongline)evt.getSource();
            if (BooleanUtils.isTrue((Boolean)newValue)) {
                ui.getBeatDiameter().setEnabled(true);
                ui.getPredator().setEnabled(true);
            } else {
                ui.getBeatDiameter().setEnabled(false);
                ui.getPredator().setEnabled(false);
                ui.getPredator().clearSelection();
                tableEditBean.setBeatDiameter(null);
            }
        }
    };
    protected boolean locationIsAdjusting;
    protected final PropertyChangeListener sectionChanged = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CatchLonglineUIHandler.this.locationIsAdjusting = true;
            try {
                Section oldValue = (Section)evt.getOldValue();
                Section newValue = (Section)evt.getNewValue();
                CatchLonglineUI ui = CatchLonglineUIHandler.this.getUi();
                CatchLongline tableEditBean = (CatchLongline)evt.getSource();
                Basket basket = tableEditBean.getBasket();
                Branchline branchline = tableEditBean.getBranchline();
                if (newValue == null) {
                    ui.getBasket().setData(Collections.emptyList());
                    ui.getBranchline().setData(Collections.emptyList());
                    tableEditBean.setBasket(null);
                    tableEditBean.setBranchline(null);
                } else {
                    ui.getBranchline().setData(Collections.emptyList());
                    tableEditBean.setBasket(null);
                    tableEditBean.setBranchline(null);
                }
            }
            finally {
                CatchLonglineUIHandler.this.locationIsAdjusting = false;
            }
        }
    };
    protected final PropertyChangeListener basketChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!CatchLonglineUIHandler.this.locationIsAdjusting) {
                Basket oldValue = (Basket)evt.getNewValue();
                Basket newValue = (Basket)evt.getNewValue();
                CatchLonglineUI ui = CatchLonglineUIHandler.this.getUi();
                CatchLongline tableEditBean = (CatchLongline)evt.getSource();
                Branchline branchline = tableEditBean.getBranchline();
                if (newValue == null) {
                    ui.getBranchline().setData(Collections.emptyList());
                } else {
                    ui.getBranchline().setData(Collections.emptyList());
                }
                tableEditBean.setBranchline(null);
            }
        }
    };
    JAXXContextEntryDef<List<Section>> ALL_SECTIONS_ENTRY = UIHelper.newListContextEntryDef((String)"CatchLonglineUI-all-sections");

    public CatchLonglineUIHandler(CatchLonglineUI ui) {
        super(ui, DataContextType.SetLongline);
    }

    @Override
    public CatchLonglineUI getUi() {
        return (CatchLonglineUI)super.getUi();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, CatchLongline bean, boolean create) {
        BeanComboBox<Healthness> requestFocus;
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        Species species = bean.getSpeciesCatch();
        CatchLonglineUI ui = this.getUi();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected species " + species));
        }
        if (create) {
            ui.getAcquisitionModeGroup().setSelectedValue(null);
            ui.getAcquisitionModeGroup().setSelectedValue((Object)CatchAcquisitionModeEnum.INDIVIDUAL);
            ui.getPredator().setEnabled(false);
            ui.getHookWhenDiscarded().setEnabled(false);
            ui.getDiscardHealthness().setEnabled(false);
            ui.getBeatDiameter().setEnabled(false);
            requestFocus = ui.getSpeciesCatch();
        } else {
            int acquisitionMode = bean.getAcquisitionMode();
            CatchAcquisitionModeEnum enumValue = CatchAcquisitionModeEnum.valueOf(acquisitionMode);
            ui.getAcquisitionModeGroup().setSelectedValue(null);
            ui.getAcquisitionModeGroup().setSelectedValue((Object)enumValue);
            requestFocus = enumValue.equals((Object)CatchAcquisitionModeEnum.GROUPED) ? ui.getCount() : ui.getCatchHealthness();
        }
        CatchLongline tableEditBean = (CatchLongline)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("catchFateLongline", this.catchFateChanged);
        tableEditBean.addPropertyChangeListener("catchFateLongline", this.catchFateChanged);
        tableEditBean.removePropertyChangeListener("depredated", this.depredatedChanged);
        tableEditBean.addPropertyChangeListener("depredated", this.depredatedChanged);
        tableEditBean.removePropertyChangeListener("section", this.sectionChanged);
        tableEditBean.addPropertyChangeListener("section", this.sectionChanged);
        tableEditBean.removePropertyChangeListener("basket", this.basketChanged);
        tableEditBean.addPropertyChangeListener("basket", this.basketChanged);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.catchlongline.table.speciesCatch", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.speciesCatch.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.acquisitionMode", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.acquisitionMode.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.count", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.count.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.catchHealthness", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.catchHealthness.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.catchFateLongline", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.catchFateLongline.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.discardHealthness", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.discardHealthness.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.depredated", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.depredated.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.comment", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.comment.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, CatchAcquisitionModeEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Healthness.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, CatchFateLongline.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Healthness.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)6, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)7, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedSetId();
    }

    @Override
    public void initUI() throws Exception {
        ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
        String speciesListId = config.getSpeciesListLonglineCatch();
        Set speciesIds = this.getDataService().getSpeciesListSpeciesIds(this.getDataSource(), speciesListId);
        this.getUi().getSpeciesCatch().putClientProperty((Object)"listPredicate", (Object)Species2.newSpeciesByIdPredicate((Set)speciesIds));
        speciesListId = config.getSpeciesListLonglineDepredator();
        speciesIds = this.getDataService().getSpeciesListSpeciesIds(this.getDataSource(), speciesListId);
        this.getUi().getPredatorHeader().putClientProperty((Object)"listPredicate", (Object)Species2.newSpeciesByIdPredicate((Set)speciesIds));
        super.initUI();
        this.ui.getModel().addPropertyChangeListener("showIndividualTabs ", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CatchLonglineUIModel source = (CatchLonglineUIModel)evt.getSource();
                Boolean newValue = (Boolean)evt.getNewValue();
                CatchLonglineUI ui = CatchLonglineUIHandler.this.getUi();
                ui.getFoodAndSexualFormTab().setEnabled(newValue.booleanValue());
                ui.getSizeMeasuresFormTab().setEnabled(newValue.booleanValue());
                ui.getWeightMeasuresFormTab().setEnabled(newValue.booleanValue());
                JTabbedPane tabPane = ui.getFishingOperationTabPane();
                if (newValue.booleanValue()) {
                    SizeMeasureUI sizeMeasureUI;
                    JComponent tabComponent = (JComponent)tabPane.getComponentAt(3);
                    if (tabComponent instanceof SizeMeasureUI) {
                        sizeMeasureUI = (SizeMeasureUI)tabComponent;
                    } else {
                        tabPane.setComponentAt(3, null);
                        sizeMeasureUI = new SizeMeasureUI((JAXXContext)ui);
                        source.setSizeMeasureUIModel(sizeMeasureUI.getModel());
                        try {
                            sizeMeasureUI.init();
                        }
                        catch (Exception e) {
                            throw new ObserveTechnicalException("Could not init ui", (Throwable)e);
                        }
                        try {
                            sizeMeasureUI.open();
                        }
                        catch (Exception e) {
                            throw new ObserveTechnicalException("Could not init open ", (Throwable)e);
                        }
                        tabPane.setComponentAt(3, sizeMeasureUI);
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Load sizeMeasure for catchLongline... " + CatchLonglineUIHandler.this.getModel().getTableEditBean() + " into " + sizeMeasureUI));
                    }
                } else {
                    JComponent tabComponent = (JComponent)tabPane.getComponentAt(3);
                    if (tabComponent instanceof SizeMeasureUI) {
                        SizeMeasureUI sizeMeasureUI = (SizeMeasureUI)tabComponent;
                        sizeMeasureUI.close();
                        tabPane.setComponentAt(3, null);
                        source.setSizeMeasureUIModel(null);
                        JLabel label = new JLabel();
                        label.setText(I18n.t((String)"observe.catchLongline.sizeMeasures.tab", (Object[])new Object[0]));
                        tabPane.setComponentAt(3, label);
                    }
                }
            }
        });
    }

    @Override
    protected SetLongline loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        SetLongline setLongline = (SetLongline)super.loadEditBean(mode, dataContext, dataService, dataSource);
        List sectionList = dataService.getSections(dataSource, setLongline.getTopiaId());
        if (!setLongline.isSectionEmpty()) {
            sectionList.addAll(setLongline.getSection());
        }
        this.ALL_SECTIONS_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)sectionList);
        return setLongline;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        this.getTableModel().addPropertyChangeListener("create", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean oldValue = (Boolean)evt.getOldValue();
                Boolean newValue = (Boolean)evt.getNewValue();
                if (BooleanUtils.isTrue((Boolean)oldValue) && BooleanUtils.isFalse((Boolean)newValue)) {
                    CatchAcquisitionModeEnum acquisitionModeEnum = (CatchAcquisitionModeEnum)((Object)CatchLonglineUIHandler.this.getUi().getAcquisitionModeGroup().getSelectedValue());
                    CatchLonglineUIHandler.this.getUi().getAcquisitionModeGroup().setSelectedValue(null);
                    CatchLonglineUIHandler.this.getUi().getAcquisitionModeGroup().setSelectedValue((Object)acquisitionModeEnum);
                }
            }
        });
    }

    public void updateCatchAcquisitionMode(CatchAcquisitionModeEnum newMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Change CatchAcquisitionMode " + (Object)((Object)newMode)));
        }
        if (newMode == null) {
            return;
        }
        CatchLonglineUI ui = this.getUi();
        boolean createMode = ui.getTableModel().isCreate();
        CatchLongline editBean = ui.getTableEditBean();
        switch (newMode) {
            case GROUPED: {
                if (!createMode) break;
                editBean.setTotalWeight(null);
                editBean.setCount(null);
                editBean.setHookPosition(null);
                break;
            }
            case INDIVIDUAL: {
                if (!createMode) break;
                editBean.setCount(Integer.valueOf(1));
            }
        }
        boolean isGrouped = CatchAcquisitionModeEnum.GROUPED.equals((Object)newMode);
        ui.getTotalWeight().setEnabled(isGrouped);
        ui.getCount().setEnabled(isGrouped);
        boolean isIndividual = CatchAcquisitionModeEnum.INDIVIDUAL.equals((Object)newMode);
        ui.getHookPosition().setEnabled(isIndividual);
        ui.getSection().setEnabled(isIndividual);
        ui.getBasket().setEnabled(isIndividual);
        ui.getBranchline().setEnabled(isIndividual);
        if (createMode) {
            editBean.setAcquisitionMode(newMode.ordinal());
        }
        boolean showIndividualTabs = !createMode && isIndividual;
        ui.getModel().setShowIndividualTabs(showIndividualTabs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPredator(CatchLongline bean, Object[] selected) {
        boolean update;
        if (!this.getModel().isEditing()) {
            return;
        }
        boolean bl = update = selected.length != bean.sizePredator();
        if (!update && selected.length > 0) {
            Collection list = bean.getPredator();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = this.getUi().getPredator().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                ArrayList<Species> newList = new ArrayList<Species>(selected.length);
                for (Object o : selected) {
                    newList.add((Species)o);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update predator " + newList.size()));
                }
                bean.setPredator(newList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    protected int[] updateIndices(Collection<Species> list) {
        int i;
        if (log.isInfoEnabled()) {
            log.info((Object)(list == null ? 0 : list.size()));
        }
        List ids = list == null ? Collections.emptyList() : TopiaEntityHelper.getTopiaIdList(list);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (list != null && !list.isEmpty()) {
            ListModel model = this.getUi().getPredator().getModel();
            int max = model.getSize();
            for (i = 0; i < max; ++i) {
                Species s = (Species)model.getElementAt(i);
                if (!ids.contains(s.getTopiaId())) continue;
                indices.add(i);
            }
        }
        int[] result = new int[indices.size()];
        i = 0;
        for (Integer indice : indices) {
            result[i++] = indice;
        }
        indices.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected indices : " + Arrays.toString(result)));
        }
        return result;
    }

    @Override
    public CatchLonglineUIModel getModel() {
        return (CatchLonglineUIModel)super.getModel();
    }

    @Override
    protected SetLongline onUpdate(TopiaContext tx, Object parentBean, SetLongline beanToSave) throws TopiaException {
        SetLongline setLongline = super.onUpdate(tx, parentBean, beanToSave);
        SizeMeasureUIModel sizeMeasureUIModel = this.getModel().getSizeMeasureUIModel();
        if (sizeMeasureUIModel != null) {
            // empty if block
        }
        return setLongline;
    }
}

