/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import com.google.common.base.Preconditions;
import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.OpenableEntity;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.referentiel.Programs;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.FloatingObject;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.NavigationTreeSelectionModel;
import fr.ird.observe.ui.tree.ObserveDataProvider;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeBridge;
import fr.ird.observe.ui.tree.loadors.ActivityLonglineNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ActivityLonglinesNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ActivitySeineNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ActivitySeinesNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ProgramLonglineNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ProgramSeineNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.RootNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.RoutesNodeChildLoador;
import java.awt.Container;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ObserveTreeHelper
extends NavTreeHelper<ObserveNode> {
    private static final Log log = LogFactory.getLog(ObserveTreeHelper.class);
    protected DataService dataService;
    private boolean createUnsaved;

    public ObserveTreeHelper() {
        super((NavTreeBridge)new ObserveTreeBridge());
    }

    protected DataService getDataService() {
        if (this.dataService == null) {
            this.dataService = ObserveContext.get().getDataService();
        }
        return this.dataService;
    }

    protected ObserveDataProvider getDataProvider() {
        DataSource source;
        ObserveDataProvider provider = (ObserveDataProvider)super.getDataProvider();
        if (provider == null && (source = ObserveContext.get().getDataSource()) != null) {
            provider = new ObserveDataProvider(source);
            this.setDataProvider(provider);
        }
        return provider;
    }

    public NavigationTreeSelectionModel newNavigationSelectionModel() {
        NavigationTreeSelectionModel model = new NavigationTreeSelectionModel();
        model.setSelectionMode(1);
        return model;
    }

    public AbstractObserveTreeCellRenderer getTreeCellRenderer() {
        JTree t = (JTree)this.getUI();
        if (t == null) {
            return null;
        }
        TreeCellRenderer r = t.getCellRenderer();
        return (AbstractObserveTreeCellRenderer)((Object)(r instanceof AbstractObserveTreeCellRenderer ? r : null));
    }

    public TreeModel createEmptyModel() {
        this.setDataSource(null);
        ObserveNode node = new ObserveNode(I18n.n((String)"observe.message.db.none.loaded", (Object[])new Object[0]), false);
        DefaultTreeModel model = this.createModel(node, new Object[0]);
        return model;
    }

    public TreeModel createModel(DataSource source) {
        this.setDataSource(source);
        ObserveNode node = new ObserveNode(String.class, "Root node", null, new RootNodeChildLoador(true, true), false);
        DefaultTreeModel model = this.createModel(node, new Object[0]);
        node.populateChilds((NavBridge)this.getBridge(), this.getDataProvider());
        return model;
    }

    public DefaultTreeModel createModel(JAXXContext context, DataSelectionModel dataModel, DataSource source) {
        this.setDataSource(source);
        context.setContextValue((Object)dataModel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("create tree model " + (Object)((Object)this)));
        }
        ObserveDataProvider dataProvider = this.getDataProvider();
        RootNodeChildLoador loador = (RootNodeChildLoador)ObserveTreeHelper.getChildLoador(RootNodeChildLoador.class);
        loador.setAddData(dataModel.isUseData());
        loador.setAddReferentiel(dataModel.isUseReferentiel());
        dataProvider.setSelectionModel(dataModel);
        ObserveNode node = new ObserveNode(String.class, "Root node", loador, false);
        DefaultTreeModel model = this.createModel(node, new Object[0]);
        this.loadAllNodes((NavNode)node, this.getDataProvider());
        return model;
    }

    public void loadNavigationUI(DataSource source, ObserveMainUI mainUI) {
        ObserveNode.count = 0L;
        this.getBridge().setUi((JTree)this.getUI());
        this.createModel(source);
        this.selectInitialNode(mainUI);
        ((JTree)this.getUI()).setVisible(true);
    }

    protected ObserveTreeBridge getBridge() {
        return (ObserveTreeBridge)super.getBridge();
    }

    public void cleanNavigationUI(ObserveMainUI mainUI) {
        this.setDataSource(null);
        mainUI.getContentLayout().reset((Container)mainUI.getContent());
        mainUI.getContextValue(SwingValidatorMessageTableModel.class).clear();
        JTree tree = (JTree)this.getUI();
        this.getBridge().setUi(null);
        ObserveNode root = (ObserveNode)this.getBridge().getRoot();
        root.removeAllChildren();
        this.createEmptyModel();
        tree.setVisible(false);
    }

    public void selectOpenNode(JAXXContext ui, Class<?> type) {
        DataContext context = (DataContext)ui.getContextValue(DataContext.class);
        Object[] ids = context.getOpenIds(type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("using open ids = " + Arrays.toString(ids)));
        }
        if (ids == null) {
            return;
        }
        this.selectNode((String[])ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectInitialNode(ObserveMainUI ui) {
        Object[] path;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will select initial node...");
        }
        DataContext context = ui.getDataContext();
        JTree tree = (JTree)this.getUI();
        List<String> selectedIds = ObserveContext.get().getNodesToReselect();
        if (CollectionUtils.isNotEmpty(selectedIds)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("will select previous ids " + selectedIds));
            }
            path = selectedIds.toArray(new String[selectedIds.size()]);
        } else {
            String id = context.getHigherOpenId();
            if (id != null) {
                path = context.getOpenIds();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will select open ids " + Arrays.toString(path)));
                }
            } else {
                ObserveNode node = (ObserveNode)((Object)tree.getModel().getRoot());
                if (!node.isLeaf()) {
                    node = (ObserveNode)node.getFirstChild();
                }
                path = new String[]{node.getId()};
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will select first program " + Arrays.toString(path)));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected path : " + Arrays.toString(path)));
        }
        try {
            this.selectNode((String[])path);
        }
        finally {
            ObserveContext.get().setNodesToReselect(null);
        }
        tree.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNode(String ... path) {
        long count = ObserveNode.count;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will select path : " + Arrays.toString(path)));
        }
        this.getBridge().setPathToSelect(path);
        try {
            super.selectNode(path);
        }
        finally {
            this.getBridge().setPathToSelect(new String[0]);
            if (log.isInfoEnabled()) {
                log.info((Object)("Creates " + (ObserveNode.count - count) + " nodes to select path " + Arrays.toString(path)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObserveNode addUnsavedNode(ObserveNode parentNode, Class<?> type) {
        DecoratorService decorator = this.getDataService().getDecoratorService();
        String label = decorator.getEntityLabel(type) + ".unsaved";
        ObserveNode result = new ObserveNode(type, null, label, null, false);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        this.refreshNode((NavNode)parentNode, true);
        ((JTree)this.getUI()).fireTreeExpanded(new TreePath(result.getPath()));
        this.createUnsaved = true;
        try {
            this.selectNode((NavNode)result);
        }
        finally {
            this.createUnsaved = false;
        }
        return result;
    }

    public ObserveNode addOpenable(ObserveNode parentNode, OpenableEntity bean) {
        if (bean instanceof TripSeine) {
            return this.addTrip(parentNode, (TripSeine)bean);
        }
        if (bean instanceof TripLongline) {
            return this.addTrip(parentNode, (TripLongline)bean);
        }
        if (bean instanceof Route) {
            return this.addRoute(parentNode, (Route)bean);
        }
        if (bean instanceof ActivitySeine) {
            return this.addActivity(parentNode, (ActivitySeine)bean);
        }
        if (bean instanceof ActivityLongline) {
            return this.addActivity(parentNode, (ActivityLongline)bean);
        }
        throw new IllegalStateException("Can not come here!");
    }

    public ObserveNode addTrip(ObserveNode parentNode, TripSeine bean) {
        ProgramSeineNodeChildLoador loador = (ProgramSeineNodeChildLoador)ObserveTreeHelper.getChildLoador(ProgramSeineNodeChildLoador.class);
        ObserveNode result = loador.createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addTrip(ObserveNode parentNode, TripLongline bean) {
        ProgramLonglineNodeChildLoador loador = (ProgramLonglineNodeChildLoador)ObserveTreeHelper.getChildLoador(ProgramLonglineNodeChildLoador.class);
        ObserveNode result = loador.createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addRoute(ObserveNode parentNode, Route bean) {
        RoutesNodeChildLoador loador = (RoutesNodeChildLoador)ObserveTreeHelper.getChildLoador(RoutesNodeChildLoador.class);
        ObserveNode result = loador.createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addActivity(ObserveNode parentNode, ActivitySeine bean) {
        ActivitySeinesNodeChildLoador loador = (ActivitySeinesNodeChildLoador)ObserveTreeHelper.getChildLoador(ActivitySeinesNodeChildLoador.class);
        ObserveNode result = loador.createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addActivity(ObserveNode parentNode, ActivityLongline bean) {
        ActivityLonglinesNodeChildLoador loador = (ActivityLonglinesNodeChildLoador)ObserveTreeHelper.getChildLoador(ActivityLonglinesNodeChildLoador.class);
        ObserveNode result = loador.createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addFloatingObject(ObserveNode parentNode, FloatingObject bean) {
        ActivitySeineNodeChildLoador loador = (ActivitySeineNodeChildLoador)ObserveTreeHelper.getChildLoador(ActivitySeineNodeChildLoador.class);
        ObserveNode result = loador.createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addSet(ObserveNode parentNode, SetSeine bean) {
        ActivitySeineNodeChildLoador loador = (ActivitySeineNodeChildLoador)ObserveTreeHelper.getChildLoador(ActivitySeineNodeChildLoador.class);
        ObserveNode result = loador.createSetNode(bean);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addSet(ObserveNode parentNode, SetLongline bean) {
        ActivityLonglineNodeChildLoador loador = (ActivityLonglineNodeChildLoador)ObserveTreeHelper.getChildLoador(ActivityLonglineNodeChildLoador.class);
        ObserveNode result = loador.createSetNode(bean);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addProgram(Program bean) throws Exception {
        List data = this.getDataService().getList(this.getDataProvider().getDataSource(), Program.class);
        int newIndex = 0;
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            Programs.sort((List)data);
            newIndex = data.indexOf(bean);
        }
        RootNodeChildLoador loador = (RootNodeChildLoador)ObserveTreeHelper.getChildLoador(RootNodeChildLoador.class);
        ObserveNode result = loador.createNode(bean, this.dataProvider);
        this.insertNode(this.getRootNode(), (NavNode)result, newIndex);
        return result;
    }

    public void removeProgram(String programId) {
        ObserveNode rootNode = (ObserveNode)this.getRootNode();
        ObserveNode result = (ObserveNode)rootNode.getChild(programId, (NavBridge)this.getBridge(), this.dataProvider);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)("Could not find program node with id: " + programId));
        this.removeNode((NavNode)result);
    }

    public void updateProgram(Program bean) {
        ObserveNode rootNode = (ObserveNode)this.getRootNode();
        ObserveNode result = (ObserveNode)rootNode.getChild(bean.getTopiaId(), (NavBridge)this.getBridge(), this.dataProvider);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)("Could not find program node with id: " + bean.getTopiaId()));
        this.refreshNode((NavNode)result, false);
    }

    void setDataSource(DataSource source) {
        ObserveDataProvider provider = null;
        if (source != null) {
            provider = new ObserveDataProvider(source);
        }
        this.setDataProvider(provider);
    }

    public boolean isCreateUnsaved() {
        return this.createUnsaved;
    }
}

