/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.constants.seine.Ownership;
import fr.ird.observe.entities.constants.seine.TypeTransmittingBuoyOperation;
import fr.ird.observe.entities.referentiel.seine.TransmittingBuoyOperation;
import fr.ird.observe.entities.referentiel.seine.TransmittingBuoyType;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.FloatingObject;
import fr.ird.observe.entities.seine.TransmittingBuoy;
import fr.ird.observe.entities.seine.TransmittingBuoyDAO;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.seine.FloatingObjectTransmittingBuoyOperationUI;
import fr.ird.observe.ui.content.impl.seine.FloatingObjectTransmittingBuoyOperationUIModel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class FloatingObjectTransmittingBuoyOperationUIHandler
extends ContentUIHandler<FloatingObject> {
    private static Log log = LogFactory.getLog(FloatingObjectTransmittingBuoyOperationUIHandler.class);

    public FloatingObjectTransmittingBuoyOperationUIHandler(FloatingObjectTransmittingBuoyOperationUI ui) {
        super(ui, DataContextType.FloatingObject, null);
    }

    public FloatingObjectTransmittingBuoyOperationUI getUi() {
        return (FloatingObjectTransmittingBuoyOperationUI)super.getUi();
    }

    public FloatingObjectTransmittingBuoyOperationUIModel getModel() {
        return (FloatingObjectTransmittingBuoyOperationUIModel)super.getModel();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(ActivitySeine.class)) {
            return ContentMode.UPDATE;
        }
        FloatingObjectTransmittingBuoyOperationUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(ActivitySeine.class), I18n.t((String)"observe.message.activity.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        ContentMode mode = this.computeContentMode();
        String dcpId = this.getSelectedParentId();
        if (log.isInfoEnabled()) {
            log.info((Object)("dcpId = " + dcpId));
        }
        FloatingObject bean = (FloatingObject)this.getBean();
        bean.clearTransmittingBuoy();
        this.getModel().setEditing(false);
        this.getDataService().loadEditEntity(this.getDataSource(), dcpId, this.getLoadExecutor());
        this.getUi().processDataBinding("typeOperation.selectedItem");
        TypeTransmittingBuoyOperation typeOperation = (TypeTransmittingBuoyOperation)this.getUi().getTypeOperation().getSelectedItem();
        this.changeTypeOperation(typeOperation, false);
        this.getModel().setMode(mode);
        if (mode == ContentMode.UPDATE) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    protected void onLoad(TopiaContext tx, FloatingObject bean) throws TopiaException {
        FloatingObject editBean = (FloatingObject)this.getBean();
        this.getLoadBinder().load((TopiaEntity)bean, (TopiaEntity)editBean, true, new String[0]);
        editBean.clearTransmittingBuoy();
        List objets = bean.getTransmittingBuoy();
        if (objets != null) {
            DecoratorService decoratorService = this.getDecoratorService();
            Decorator dB = decoratorService.getDecoratorByType(TransmittingBuoy.class);
            Decorator dB2 = decoratorService.getDecoratorByType(TransmittingBuoyOperation.class);
            Decorator dB3 = decoratorService.getDecoratorByType(TransmittingBuoyType.class);
            for (TransmittingBuoy transmittingBuoy : objets) {
                TransmittingBuoyType type;
                TransmittingBuoyOperation objectOperation;
                String s = dB.toString((Object)transmittingBuoy);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use balise lue : " + s));
                }
                if ((objectOperation = transmittingBuoy.getTransmittingBuoyOperation()) != null) {
                    s = dB2.toString((Object)objectOperation);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("use objectOperation balise : " + s));
                    }
                }
                if ((type = transmittingBuoy.getTransmittingBuoyType()) != null) {
                    s = dB3.toString((Object)type);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("use type balise : " + s));
                    }
                }
                editBean.addTransmittingBuoy(transmittingBuoy);
            }
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        super.startEditUI("transmittingBuoyOperation1.selectedItem", "transmittingBuoyOperation2.selectedItem", "code1.text", "code2.text", "ownership1.selectedItem", "ownership2.selectedItem", "transmittingBuoyType1.selectedItem", "transmittingBuoyType2.selectedItem", "brand1.text", "brand2.text", "typeOperation.selectedItem");
        FloatingObjectTransmittingBuoyOperationUI ui = this.getUi();
        this.addInfoMessage(I18n.t((String)"observe.message.updating.floatingObject", (Object[])new Object[0]));
        List balises = ((FloatingObject)this.getBean()).getTransmittingBuoy();
        if (balises != null && !balises.isEmpty()) {
            TransmittingBuoy transmittingBuoy1 = ui.getTransmittingBuoy1();
            ui.getValidatorBalise1().setBean((Object)transmittingBuoy1);
            if (balises.size() == 2) {
                TransmittingBuoy transmittingBuoy2 = ui.getTransmittingBuoy2();
                ui.getValidatorBalise2().setBean((Object)transmittingBuoy2);
            }
        }
        UIHelper.processDataBinding((JAXXObject)ui, (String[])new String[]{"transmittingBuoyOperation1.selectedItem", "transmittingBuoyOperation2.selectedItem", "code1.text", "code2.text", "ownership1.selectedItem", "ownership2.selectedItem", "brand1.text", "brand2.text", "transmittingBuoyType1.selectedItem", "transmittingBuoyType2.selectedItem"});
        this.getModel().setModified(false);
    }

    public boolean isBalisePose(TransmittingBuoyOperation operation) {
        return operation != null && "3".equals(operation.getCode());
    }

    @Override
    protected boolean doSave(FloatingObject bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<FloatingObject> binder) throws Exception {
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected FloatingObject onUpdate(TopiaContext tx, Object parentBean, FloatingObject beanToSave) throws TopiaException {
        FloatingObject editBean = (FloatingObject)this.getBean();
        List objets = editBean.getTransmittingBuoy();
        beanToSave.setComment(editBean.getComment());
        beanToSave.clearTransmittingBuoy();
        TopiaEntityBinder<TransmittingBuoy> childLoador = this.getModel().getChildLoador();
        TransmittingBuoyDAO transmittingBuoyDAO = ObserveDAOHelper.getTransmittingBuoyDAO((TopiaContext)tx);
        for (TransmittingBuoy transmittingBuoy : objets) {
            TransmittingBuoy newBalise;
            if (transmittingBuoy.getTopiaId() == null) {
                Map map = childLoador.obtainProperties((Object)transmittingBuoy, new String[0]);
                newBalise = (TransmittingBuoy)transmittingBuoyDAO.create(map);
            } else {
                newBalise = (TransmittingBuoy)transmittingBuoyDAO.findByTopiaId(transmittingBuoy.getTopiaId());
                childLoador.load((TopiaEntity)transmittingBuoy, (TopiaEntity)newBalise, false, new String[0]);
            }
            beanToSave.addTransmittingBuoy(newBalise);
        }
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        this.resetEditUI();
    }

    protected void changeTypeOperation(TypeTransmittingBuoyOperation typeOperation, boolean reset) {
        FloatingObjectTransmittingBuoyOperationUI ui = this.getUi();
        if (log.isInfoEnabled()) {
            log.info((Object)(typeOperation + " doReset ? " + reset));
        }
        int nbBalises = typeOperation.getNbBalises();
        FloatingObject bean = (FloatingObject)this.getBean();
        boolean hasBalise = !bean.isTransmittingBuoyEmpty();
        ArrayList objets = new ArrayList();
        if (!reset && hasBalise) {
            objets.addAll(bean.getTransmittingBuoy());
        }
        if (hasBalise) {
            bean.getTransmittingBuoy().clear();
        }
        JPanel editorPanel = ui.getTransmittingBuoys();
        editorPanel.removeAll();
        String[] codeOperations = typeOperation.getCodeOperation();
        List operations = ui.getTransmittingBuoyOperation1().getData();
        switch (nbBalises) {
            case 0: {
                editorPanel.setLayout(new GridLayout());
                editorPanel.add(ui.getNoBaliseEditor());
                if (!this.getModel().isEditing()) break;
                ui.getValidatorBalise1().setBean(null);
                ui.getValidatorBalise2().setBean(null);
                break;
            }
            case 1: {
                TransmittingBuoy transmittingBuoy = reset ? null : (TransmittingBuoy)objets.get(0);
                TransmittingBuoyOperation objectOperation = reset ? this.getObjectOperation(operations, codeOperations[0]) : null;
                this.bindEditBalise(ui.getTransmittingBuoy1(), objectOperation, transmittingBuoy);
                editorPanel.setLayout(new GridLayout(1, 0));
                editorPanel.add((Component)ui.getTransmittingBuoy1Editor());
                if (!this.getModel().isEditing()) break;
                ui.getValidatorBalise1().setBean((Object)ui.getTransmittingBuoy1());
                ui.getValidatorBalise2().setBean(null);
                break;
            }
            case 2: {
                TransmittingBuoy transmittingBuoy = reset ? null : (TransmittingBuoy)objets.get(0);
                TransmittingBuoyOperation objectOperation = reset ? this.getObjectOperation(operations, codeOperations[0]) : null;
                this.bindEditBalise(ui.getTransmittingBuoy1(), objectOperation, transmittingBuoy);
                transmittingBuoy = reset ? null : (TransmittingBuoy)objets.get(1);
                objectOperation = reset ? this.getObjectOperation(operations, codeOperations[1]) : null;
                this.bindEditBalise(ui.getTransmittingBuoy2(), objectOperation, transmittingBuoy);
                editorPanel.setLayout(new GridLayout(2, 0));
                editorPanel.add((Component)ui.getTransmittingBuoy1Editor());
                editorPanel.add((Component)ui.getTransmittingBuoy2Editor());
                if (!this.getModel().isEditing()) break;
                ui.getValidatorBalise1().setBean((Object)ui.getTransmittingBuoy1());
                ui.getValidatorBalise2().setBean((Object)ui.getTransmittingBuoy2());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FloatingObjectTransmittingBuoyOperationUIHandler.this.getUi().revalidate();
            }
        });
    }

    protected void bindEditBalise(TransmittingBuoy editBean, TransmittingBuoyOperation transmittingBuoyOperation, TransmittingBuoy transmittingBuoy) {
        FloatingObject bean;
        this.getModel().getChildLoador().load((TopiaEntity)transmittingBuoy, (TopiaEntity)editBean, false, new String[0]);
        if (transmittingBuoy == null) {
            editBean.setTransmittingBuoyOperation(transmittingBuoyOperation);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reuse an empty balise lue for objectOperation " + transmittingBuoyOperation.getLabel1()));
            }
            if (this.isBalisePose(transmittingBuoyOperation)) {
                editBean.setOwnership(Ownership.ceVessel);
            }
        }
        if ((bean = (FloatingObject)this.getBean()).getTransmittingBuoy() == null) {
            bean.setTransmittingBuoy(new ArrayList());
        }
        bean.getTransmittingBuoy().add(editBean);
    }

    protected TransmittingBuoyOperation getObjectOperation(List<TransmittingBuoyOperation> objectOperations, String codeOperation) {
        TransmittingBuoyOperation objectOperation = null;
        for (TransmittingBuoyOperation op : objectOperations) {
            if (!codeOperation.equals(op.getCode())) continue;
            objectOperation = op;
            break;
        }
        if (objectOperation == null) {
            throw new IllegalArgumentException("could not find a " + TransmittingBuoyOperation.class + " with code " + codeOperation);
        }
        return objectOperation;
    }
}

