/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveCLAction;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveResourceManager;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.constants.CommonDataSourceConfigParam;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.H2DataSourceConfigParam;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.db.impl.PGDataSourceConfigParam;
import fr.ird.observe.ui.UIHelper;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;

public class ObserveConfig
extends ApplicationConfig
implements IObserveConfig {
    private static Log log = LogFactory.getLog(ObserveConfig.class);
    protected boolean displayMainUI = true;
    protected boolean localStorageExist;
    protected boolean initialDumpExist;
    protected boolean mainStorageOpened;
    protected Boolean mainStorageOpenedLocal;
    protected boolean canUseUI = true;
    private Version version;
    protected String copyrightText;
    protected String[] unsavables;
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];

    public ObserveConfig() {
        this.setConfigFileName(ObserveConfigOption.CONFIG_FILE.defaultValue);
        this.loadDefaultOptions(ObserveConfigOption.values());
    }

    public boolean containActions(Step action) {
        List list = (List)this.actions.get(action.ordinal());
        return list != null && !list.isEmpty();
    }

    public void initConfig(ObserveResourceManager manager) throws IOException {
        Version version = null;
        Properties p = manager.getResource(ObserveResourceManager.Resource.application);
        for (Object k : p.keySet()) {
            String key = String.valueOf(k);
            Object value = p.get(k);
            if (log.isDebugEnabled()) {
                log.debug((Object)("install property [" + k + "] : " + value));
            }
            String strValue = String.valueOf(value);
            if ("application.version".equals(key)) {
                version = Versions.valueOf((String)strValue);
                if (!version.isSnapshot()) continue;
                version = Versions.removeSnapshot((Version)version);
                continue;
            }
            this.setDefaultOption(key, strValue);
        }
        if (version == null) {
            throw new IllegalStateException("No application.version found in application configuration.");
        }
        this.setVersion(version);
        this.setDefaultOption("version", version.getVersion());
        this.setDefaultOption("application.version", version.getVersion());
        Version dbVersion = Versions.valueOf((String)ObserveDAOHelper.getModelVersion());
        this.setDefaultOption("db.version", dbVersion.getVersion());
        boolean isAdmin = ObserveRunner.isAdmin();
        for (ObserveCLAction.ActionDefinition a : ObserveCLAction.ActionDefinition.values()) {
            if (a.isAdmin() && !isAdmin) continue;
            for (String alias : a.aliases) {
                this.addActionAlias(alias, a.action);
            }
        }
    }

    protected void migrateUserConfigurationFile(File oldHomeConfig, File homeConfig) throws IOException {
        super.migrateUserConfigurationFile(oldHomeConfig, homeConfig);
        JOptionPane.showInternalMessageDialog(null, I18n.t((String)"observe.title.config.migrate", (Object[])new Object[0]), I18n.t((String)"observe.runner.config.migrate.file", (Object[])new Object[]{oldHomeConfig.getName(), oldHomeConfig, homeConfig}), 2);
    }

    protected void installSaveAction() {
        ArrayList<String> result = new ArrayList<String>();
        boolean isAdmin = ObserveRunner.isAdmin();
        for (ObserveConfigOption option : ObserveConfigOption.values()) {
            String key;
            if (option.isAdmin() && !isAdmin || (key = option.getPropertyKey()) == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("register action listener for property " + key));
            }
            result.add(key);
        }
        this.installSaveUserAction(result.toArray(new String[result.size()]));
    }

    public String getCopyrightText() {
        if (this.copyrightText == null) {
            Date date = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            this.copyrightText = "Version " + this.getVersion() + " IRD @ 2008-" + year;
        }
        return this.copyrightText;
    }

    public boolean isDevMode() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.DEV_MODE.key);
        return result;
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getDbVersion() {
        Version option = (Version)this.getOption(Version.class, "db.version");
        return option;
    }

    public boolean isAutoPopupNumberEditor() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.AUTO_POPUP_NUMBER_EDITOR.key);
        return result;
    }

    public boolean isShowNumberEditorButton() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.SHOW_NUMBER_EDITOR_BUTTON.key);
        return result;
    }

    public boolean isShowTimeEditorSlider() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.SHOW_DATE_TIME_EDITOR_SLIDER.key);
        return result;
    }

    public boolean isFullScreen() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.FULL_SCREEN.key);
        return result;
    }

    public File getDataDirectory() {
        File file = this.getOptionAsFile(ObserveConfigOption.DATA_DIRECTORY.key);
        return file;
    }

    public File getValidationReportDirectory() {
        File file = this.getOptionAsFile(ObserveConfigOption.VALIDATION_REPORT_DIRECTORY.key);
        return file;
    }

    public File getLocalDBDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.DB_DIRECTORY.key);
        return result;
    }

    public File getResourcesDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.RESOURCES_DIRECTORY.key);
        return result;
    }

    public File getI18nDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.I18N_DIRECTORY.key);
        return result;
    }

    public void setResourcesDirectory(File newValue) {
        this.setOption(ObserveConfigOption.RESOURCES_DIRECTORY, newValue);
    }

    public File getInitialDbDump() {
        File result = this.getOptionAsFile(ObserveConfigOption.INITIAL_DB_DUMP.key);
        return result;
    }

    public File getBackupDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.BACKUP_DIRECTORY.key);
        return result;
    }

    public File getReportDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.REPORT_DIRECTORY.key);
        return result;
    }

    public File getTmpDirectory() {
        File result = this.getOptionAsFile(ObserveConfigOption.TMP_DIRECTORY.key);
        return result;
    }

    public String getH2Login() {
        String result = this.getOption(ObserveConfigOption.H2_LOGIN.key);
        return result;
    }

    public char[] getH2Password() {
        String result = this.getOption(ObserveConfigOption.H2_PASSWORD.key);
        char[] r = result.toCharArray();
        return r;
    }

    public int getH2ServerPort() {
        Integer port = this.getOptionAsInt(ObserveConfigOption.H2_SERVER_PORT.key);
        return port;
    }

    public String getObstunaUrl() {
        String result = this.getOption(ObserveConfigOption.OBSTUNA_URL.key);
        return result;
    }

    public String getObstunaLogin() {
        String result = this.getOption(ObserveConfigOption.OBSTUNA_LOGIN.key);
        return result;
    }

    public char[] getObstunaPassword() {
        String result = this.getOption(ObserveConfigOption.OBSTUNA_PASSWORD.key);
        char[] r = result.toCharArray();
        return r;
    }

    public boolean isObstunaUseSsl() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.OBSTUNA_USE_SSL_CERT.key);
        return result;
    }

    public DbMode getDefaultDbMode() {
        DbMode result = (DbMode)this.getOption(DbMode.class, ObserveConfigOption.DEFAULT_DB_MODE.key);
        return result;
    }

    public CreationMode getDefaultCreationMode() {
        CreationMode result = (CreationMode)this.getOption(CreationMode.class, ObserveConfigOption.DEFAULT_CREATION_MODE.key);
        return result;
    }

    public boolean isShowMigrationSql() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.SHOW_MIGRATION_SQL.key);
        return result;
    }

    public boolean isShowMigrationProgression() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.SHOW_MIGRATION_PROGRESSION.key);
        return result;
    }

    public boolean isShowSql() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.SHOW_SQL.key);
        return result;
    }

    public int getDefaultGpsMaxDelay() {
        Integer i = this.getOptionAsInt(ObserveConfigOption.DEFAULT_GPS_MAX_DELAY.key);
        return i;
    }

    public float getDefaultGpsMaxSpeed() {
        double i = this.getOptionAsDouble(ObserveConfigOption.DEFAULT_GPS_MAX_SPEED.key);
        return (float)i;
    }

    public boolean isChangeSynchroSrc() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.CHANGE_SYNCHRO_SRC.key);
        return result;
    }

    public boolean isStoreRemoteStorage() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.STORE_REMOTE_STORAGE.key);
        return result;
    }

    public boolean isCanMigrateObstuna() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.OBSTUNA_CAN_MIGRATE.key);
        return result;
    }

    public boolean isCanMigrateH2() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.H2_CAN_MIGRATE.key);
        return result;
    }

    public boolean isLoadLocalStorage() {
        boolean result = this.getOptionAsBoolean(ObserveConfigOption.LOAD_LOCAL_STORAGE.key);
        return result;
    }

    public Locale getLocale() {
        Locale result = (Locale)this.getOption(Locale.class, ObserveConfigOption.LOCALE.key);
        return result;
    }

    public Locale getDbLocale() {
        Locale result = (Locale)this.getOption(Locale.class, ObserveConfigOption.DB_LOCALE.key);
        return result;
    }

    public int getNonTargetObservation() {
        int value = this.getOptionAsInt(ObserveConfigOption.NON_TARGET_OBSERVATION.key);
        return value;
    }

    public int getTargetDiscardsObservation() {
        int value = this.getOptionAsInt(ObserveConfigOption.TARGET_DISCARDS_OBSERVATION.key);
        return value;
    }

    public int getSamplesObservation() {
        int value = this.getOptionAsInt(ObserveConfigOption.SAMPLES_OBSERVATION.key);
        return value;
    }

    public int getObjectsObservation() {
        int value = this.getOptionAsInt(ObserveConfigOption.OBJECTS_OBSERVATION.key);
        return value;
    }

    public int getDetailledActivitiesObservation() {
        int value = this.getOptionAsInt(ObserveConfigOption.DETAILLED_ACTIVITIES_OBSERVATION.key);
        return value;
    }

    public int getMammalsObservation() {
        int value = this.getOptionAsInt(ObserveConfigOption.MAMMALS_OBSERVATION.key);
        return value;
    }

    public int getBirdsObservation() {
        int value = this.getOptionAsInt(ObserveConfigOption.BIRDS_OBSERVATION.key);
        return value;
    }

    public int getBaitObservation() {
        int value = this.getOptionAsInt(ObserveConfigOption.BAIT_OBSERVATION.key);
        return value;
    }

    public boolean isDisplayMainUI() {
        return this.displayMainUI;
    }

    public boolean isCanUseUI() {
        return this.canUseUI;
    }

    public boolean isLocalStorageExist() {
        return this.localStorageExist;
    }

    public boolean isInitialDumpExist() {
        return this.initialDumpExist;
    }

    public boolean isMainStorageOpened() {
        return this.mainStorageOpened;
    }

    public Boolean getMainStorageOpenedLocal() {
        return this.mainStorageOpenedLocal;
    }

    public void setLocalStorageExist(boolean newValue) {
        this.localStorageExist = newValue;
        this.firePropertyChange("localStorageExist", newValue);
    }

    public void setInitialDumpExist(boolean newValue) {
        this.initialDumpExist = newValue;
        this.firePropertyChange("initialDumpExist", newValue);
    }

    public void setMainStorageOpened(boolean newValue) {
        this.mainStorageOpened = newValue;
        if (!newValue) {
            this.setMainStorageOpenedLocal(null);
        }
        this.firePropertyChange("mainStorageOpened", newValue);
    }

    public void setMainStorageOpenedLocal(Boolean newValue) {
        this.mainStorageOpenedLocal = newValue;
        this.firePropertyChange("mainStorageOpenedLocal", newValue);
    }

    public void setDisplayMainUI(boolean b) {
        this.displayMainUI = b;
    }

    public void setCanUseUI(boolean canUseUI) {
        this.canUseUI = canUseUI;
        if (!canUseUI) {
            this.setDisplayMainUI(false);
        }
    }

    public void setAutoPopupNumberEditor(boolean newValue) {
        this.setOption(ObserveConfigOption.AUTO_POPUP_NUMBER_EDITOR, newValue);
    }

    public void setShowNumberEditorButton(boolean newValue) {
        this.setOption(ObserveConfigOption.SHOW_NUMBER_EDITOR_BUTTON, newValue);
    }

    public void setShowTimeEditorSlider(boolean newValue) {
        this.setOption(ObserveConfigOption.SHOW_DATE_TIME_EDITOR_SLIDER, newValue);
    }

    public void setFullScreen(boolean newValue) {
        this.setOption(ObserveConfigOption.FULL_SCREEN, newValue);
    }

    public void setChangeSynchroSrc(boolean newValue) {
        this.setOption(ObserveConfigOption.CHANGE_SYNCHRO_SRC, newValue);
    }

    public void setStoreRemoteStorage(boolean newValue) {
        this.setOption(ObserveConfigOption.STORE_REMOTE_STORAGE, newValue);
    }

    public void setLoadLocalStorage(boolean newValue) {
        this.setOption(ObserveConfigOption.LOAD_LOCAL_STORAGE, newValue);
    }

    public void setDefaultDbMode(DbMode newValue) {
        this.setOption(ObserveConfigOption.DEFAULT_DB_MODE, newValue);
    }

    public void setDefaultCreationMode(CreationMode newValue) {
        this.setOption(ObserveConfigOption.DEFAULT_CREATION_MODE, newValue);
    }

    public void setDefaultGpsMaxDelay(int newValue) {
        this.setOption(ObserveConfigOption.DEFAULT_GPS_MAX_DELAY, newValue);
    }

    public void setDefaultGpsMaxSpeed(float newValue) {
        this.setOption(ObserveConfigOption.DEFAULT_GPS_MAX_SPEED, Float.valueOf(newValue));
    }

    public void setLocale(Locale newValue) {
        this.setOption(ObserveConfigOption.LOCALE, newValue);
    }

    public void setDbLocale(Locale newValue) {
        this.setOption(ObserveConfigOption.DB_LOCALE, newValue);
    }

    public void setCanMigrateObstuna(Boolean newValue) {
        this.setOption(ObserveConfigOption.OBSTUNA_CAN_MIGRATE, newValue);
    }

    public void setCanMigrateH2(Boolean newValue) {
        this.setOption(ObserveConfigOption.H2_CAN_MIGRATE, newValue);
    }

    public void setNonTargetObservation(int newValue) {
        this.setOption(ObserveConfigOption.NON_TARGET_OBSERVATION, newValue);
    }

    public void setTargetDiscardsObservation(int newValue) {
        this.setOption(ObserveConfigOption.TARGET_DISCARDS_OBSERVATION, newValue);
    }

    public void setSamplesObservation(int newValue) {
        this.setOption(ObserveConfigOption.SAMPLES_OBSERVATION, newValue);
    }

    public void setObjectsObservation(int newValue) {
        this.setOption(ObserveConfigOption.OBJECTS_OBSERVATION, newValue);
    }

    public void setDetailledActivitiesObservation(int newValue) {
        this.setOption(ObserveConfigOption.DETAILLED_ACTIVITIES_OBSERVATION, newValue);
    }

    public void setMammalsObservation(int newValue) {
        this.setOption(ObserveConfigOption.MAMMALS_OBSERVATION, newValue);
    }

    public void setBirdsObservation(int newValue) {
        this.setOption(ObserveConfigOption.BIRDS_OBSERVATION, newValue);
    }

    public void setBaitObservation(int newValue) {
        this.setOption(ObserveConfigOption.BAIT_OBSERVATION, newValue);
    }

    public void setShowMigrationSql(boolean showMigrationSql) {
        this.setOption(ObserveConfigOption.SHOW_MIGRATION_SQL, showMigrationSql);
    }

    public void setShowMigrationProgression(boolean showMigrationProgression) {
        this.setOption(ObserveConfigOption.SHOW_MIGRATION_PROGRESSION, showMigrationProgression);
    }

    public void setShowSql(boolean showSql) {
        this.setOption(ObserveConfigOption.SHOW_SQL, showSql);
    }

    public String getSpeciesListSeineNonTargetCatch() {
        String value = this.getOption(ObserveConfigOption.SPECIES_LIST_SEINE_NON_TARGET_CATCH.key);
        return value;
    }

    public String getSpeciesListSeineTargetCatch() {
        String value = this.getOption(ObserveConfigOption.SPECIES_LIST_SEINE_TARGET_CATCH.key);
        return value;
    }

    public String getSpeciesListSeineSchoolEstimate() {
        String value = this.getOption(ObserveConfigOption.SPECIES_LIST_SEINE_SCHOOL_ESTIMATE.key);
        return value;
    }

    public String getSpeciesListSeineObjectObservedSpecies() {
        String value = this.getOption(ObserveConfigOption.SPECIES_LIST_SEINE_OBJECT_OBSERVED_SPECIES.key);
        return value;
    }

    public String getSpeciesListSeineObjectSchoolEstimate() {
        String value = this.getOption(ObserveConfigOption.SPECIES_LIST_SEINE_OBJECT_SCHOOL_ESTIMATE.key);
        return value;
    }

    public String getSpeciesListLonglineCatch() {
        String value = this.getOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_CATCH.key);
        return value;
    }

    public String getSpeciesListLonglineEncounter() {
        String value = this.getOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_ENCOUNTER.key);
        return value;
    }

    public String getSpeciesListLonglineDepredator() {
        String value = this.getOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_DEPREDATOR.key);
        return value;
    }

    public void setSpeciesListSeineNonTargetCatch(String speciesListSeineNonTargetCatch) {
        this.setOption(ObserveConfigOption.SPECIES_LIST_SEINE_NON_TARGET_CATCH, speciesListSeineNonTargetCatch);
    }

    public void setSpeciesListSeineTargetCatch(String speciesListSeineTargetCatch) {
        this.setOption(ObserveConfigOption.SPECIES_LIST_SEINE_TARGET_CATCH, speciesListSeineTargetCatch);
    }

    public void setSpeciesListSeineSchoolEstimate(String speciesListSeineSchoolEstimate) {
        this.setOption(ObserveConfigOption.SPECIES_LIST_SEINE_SCHOOL_ESTIMATE, speciesListSeineSchoolEstimate);
    }

    public void setSpeciesListSeineObjectObservedSpecies(String speciesListSeineObjectObservedSpecies) {
        this.setOption(ObserveConfigOption.SPECIES_LIST_SEINE_OBJECT_OBSERVED_SPECIES, speciesListSeineObjectObservedSpecies);
    }

    public void setSpeciesListSeineObjectSchoolEstimate(String speciesListseineObjectSchoolEstimate) {
        this.setOption(ObserveConfigOption.SPECIES_LIST_SEINE_OBJECT_SCHOOL_ESTIMATE, speciesListseineObjectSchoolEstimate);
    }

    public void setSpeciesListLonglineCatch(String speciesListLonglineCatch) {
        this.setOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_CATCH, speciesListLonglineCatch);
    }

    public void setSpeciesListLonglineEncounter(String speciesListLonglineEncounter) {
        this.setOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_ENCOUNTER, speciesListLonglineEncounter);
    }

    public void setSpeciesListLonglineDepredator(String speciesListLonglineDepredator) {
        this.setOption(ObserveConfigOption.SPECIES_LIST_LONGLINE_DEPREDATOR, speciesListLonglineDepredator);
    }

    public String[] getUnsavables() {
        if (this.unsavables == null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(ObserveConfigOption.OBSTUNA_PASSWORD.getKey());
            tmp.add(ObserveConfigOption.H2_PASSWORD.getKey());
            tmp.add(ObserveConfigOption.OBSTUNA_CAN_MIGRATE.getKey());
            if (!ObserveRunner.isAdmin()) {
                for (ObserveConfigOption option : ObserveConfigOption.values()) {
                    if (!option.isAdmin()) continue;
                    tmp.add(option.key);
                }
            }
            this.unsavables = tmp.toArray(new String[tmp.size()]);
        }
        return this.unsavables;
    }

    public void saveForUser(String ... excludeKeys) {
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"observe.message.save.configuration", (Object[])new Object[]{this.getUserConfigFile()}));
        }
        super.saveForUser(this.getUnsavables());
    }

    public void fromStorageConfig(H2DataSourceConfig config) {
        this.setOption(ObserveConfigOption.SHOW_MIGRATION_PROGRESSION, config.isShowMigrationProgression());
        this.setOption(ObserveConfigOption.SHOW_MIGRATION_SQL, config.isShowMigrationSql());
        this.saveForUser(new String[0]);
    }

    public void fromStorageConfig(PGDataSourceConfig config) {
        this.setOption(ObserveConfigOption.OBSTUNA_URL.getKey(), config.getUrl());
        this.setOption(ObserveConfigOption.OBSTUNA_LOGIN.getKey(), config.getLogin());
        this.setOption(ObserveConfigOption.OBSTUNA_PASSWORD.getKey(), new String(config.getPassword()));
        boolean useSsl = config.isUseSsl();
        this.setOption(ObserveConfigOption.OBSTUNA_USE_SSL_CERT, useSsl);
        this.setOption(ObserveConfigOption.SHOW_MIGRATION_PROGRESSION, config.isShowMigrationProgression());
        this.setOption(ObserveConfigOption.SHOW_MIGRATION_SQL, config.isShowMigrationSql());
        this.saveForUser(new String[0]);
    }

    public H2DataSourceConfig toH2StorageConfig(String label) {
        H2DataSourceConfig result = DataSourceFactory.newH2Config((String)label, (Object[])new Object[]{CommonDataSourceConfigParam.LOGIN, this.getH2Login(), CommonDataSourceConfigParam.PASSWORD, this.getH2Password(), CommonDataSourceConfigParam.CAN_MIGRATE, this.isCanMigrateH2(), CommonDataSourceConfigParam.SHOW_MIGRATION_PROGRESSION, this.isShowMigrationProgression(), CommonDataSourceConfigParam.SHOW_MIGRATION_SQL, this.isShowMigrationSql(), H2DataSourceConfigParam.DIRECTORY, this.getLocalDBDirectory()});
        return result;
    }

    public PGDataSourceConfig toPostgresStorageConfig(String label) {
        PGDataSourceConfig result = DataSourceFactory.newPGConfig((String)label, (Object[])new Object[]{PGDataSourceConfigParam.URL, this.getObstunaUrl(), CommonDataSourceConfigParam.LOGIN, this.getObstunaLogin(), CommonDataSourceConfigParam.PASSWORD, this.getObstunaPassword(), CommonDataSourceConfigParam.CAN_MIGRATE, this.isCanMigrateObstuna(), CommonDataSourceConfigParam.SHOW_MIGRATION_PROGRESSION, this.isShowMigrationProgression(), CommonDataSourceConfigParam.SHOW_MIGRATION_SQL, this.isShowMigrationSql(), PGDataSourceConfigParam.USE_SSL, this.isObstunaUseSsl()});
        return result;
    }

    public void removeJaxxPropertyChangeListener() {
        String[] propertyNames;
        PropertyChangeListener[] toRemove;
        ArrayList<String> tmp = new ArrayList<String>();
        for (ObserveConfigOption option : ObserveConfigOption.values()) {
            String propertyName = option.getPropertyKey();
            if (propertyName == null) continue;
            tmp.add(propertyName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("property names to seek for options : " + tmp));
        }
        if ((toRemove = UIHelper.findJaxxPropertyChangeListener((String[])(propertyNames = tmp.toArray(new String[tmp.size()])), (PropertyChangeListener[])this.getPropertyChangeListeners())) == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    public void setOption(ObserveConfigOption option, Object newValue) {
        String propertyName;
        String key = option.getKey();
        String oldValue = this.getOption(key);
        String value = String.valueOf(newValue);
        this.setOption(key, value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("set option " + key + " value : " + value));
        }
        if ((propertyName = option.getPropertyKey()) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("fires config change from option " + key));
            }
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    void setVersion(Version version) {
        this.version = version;
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.pcs.firePropertyChange(propertyName, null, newValue);
    }

    public static enum Step {
        AfterInit,
        BeforeExit;

    }
}

