/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.seine;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.constants.seine.NonTargetCatchComputedValueSource;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.ReferenceEntities;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.Species2;
import fr.ird.observe.entities.referentiel.seine.ReasonForDiscard;
import fr.ird.observe.entities.referentiel.seine.SpeciesFate;
import fr.ird.observe.entities.seine.NonTargetCatch;
import fr.ird.observe.entities.seine.NonTargetLength;
import fr.ird.observe.entities.seine.NonTargetSample;
import fr.ird.observe.entities.seine.Set;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.seine.NonTargetCatchUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class NonTargetCatchUIHandler
extends ContentTableUIHandler<Set, NonTargetCatch> {
    private static Log log = LogFactory.getLog(NonTargetCatchUIHandler.class);
    protected final JAXXContextEntryDef<List<Species>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"NonTargetCatchUI-all-speciess");
    protected final JAXXContextEntryDef<List<NonTargetLength>> ALL_TAILLES_TO_DELETE_ENTRY = UIHelper.newListContextEntryDef((String)"NonTargetCatchUI-all-taille-to-delete");
    protected final PropertyChangeListener totalCountChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NonTargetCatch source = (NonTargetCatch)evt.getSource();
            source.setTotalCountComputedSource(null);
        }
    };
    protected final PropertyChangeListener catchWeightChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NonTargetCatch source = (NonTargetCatch)evt.getSource();
            source.setCatchWeightComputedSource(null);
        }
    };
    protected final PropertyChangeListener meanWeightChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NonTargetCatch source = (NonTargetCatch)evt.getSource();
            source.setMeanWeightComputedSource(null);
        }
    };
    protected final PropertyChangeListener meanLengthChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NonTargetCatch source = (NonTargetCatch)evt.getSource();
            source.setMeanLengthComputedSource(null);
        }
    };

    public static ContentTableUIModel<Set, NonTargetCatch> newModel(NonTargetCatchUI ui) {
        return new ContentTableUIModel<Set, NonTargetCatch>(Set.class, NonTargetCatch.class, new String[]{"nonTargetCatch", "nonTargetDiscarded"}, new String[]{"species", "catchWeight", "totalCount", "meanWeight", "meanLength", "reasonForDiscard", "speciesFate", "totalCountComputedSource", "meanWeightComputedSource", "catchWeightComputedSource", "meanLengthComputedSource", "comment"}, ui, ContentTableModel.newTableMeta(NonTargetCatch.class, "species", false), ContentTableModel.newTableMeta(NonTargetCatch.class, "speciesFate", false), ContentTableModel.newTableMeta(NonTargetCatch.class, "reasonForDiscard", false), ContentTableModel.newTableMeta(NonTargetCatch.class, "catchWeight", false), ContentTableModel.newTableMeta(NonTargetCatch.class, "totalCount", false), ContentTableModel.newTableMeta(NonTargetCatch.class, "meanWeight", false), ContentTableModel.newTableMeta(NonTargetCatch.class, "meanLength", false), ContentTableModel.newTableMeta(NonTargetCatch.class, "comment", false));
    }

    public NonTargetCatchUIHandler(NonTargetCatchUI ui) {
        super(ui);
    }

    @Override
    public NonTargetCatchUI getUi() {
        return (NonTargetCatchUI)super.getUi();
    }

    public String getCatchWeightDataTip(NonTargetCatchComputedValueSource computed) {
        String result = computed == null ? I18n.t((String)"observe.common.catchWeightComputed.observed.tip", (Object[])new Object[0]) : I18n.t((String)"observe.common.catchWeightComputed.computed.tip", (Object[])new Object[]{computed.toString()});
        return result;
    }

    public String getTotalCountDataTip(NonTargetCatchComputedValueSource computed) {
        String result = computed == null ? I18n.t((String)"observe.common.totalCountComputed.observed.tip", (Object[])new Object[0]) : I18n.t((String)"observe.common.totalCountComputed.computed.tip", (Object[])new Object[]{computed.toString()});
        return result;
    }

    public String getMeanWeightDataTip(NonTargetCatchComputedValueSource computed) {
        String result = computed == null ? I18n.t((String)"observe.common.meanWeightComputed.observed.tip", (Object[])new Object[0]) : I18n.t((String)"observe.common.meanWeightComputed.computed.tip", (Object[])new Object[]{computed.toString()});
        return result;
    }

    public String getMeanLengthDataTip(NonTargetCatchComputedValueSource computed) {
        String result = computed == null ? I18n.t((String)"observe.common.meanLengthComputed.observed.tip", (Object[])new Object[0]) : I18n.t((String)"observe.common.meanLengthComputed.computed.tip", (Object[])new Object[]{computed.toString()});
        return result;
    }

    public void resetCatchWeightComputed() {
        ((NonTargetCatch)this.getTableEditBean()).setCatchWeightComputedSource(null);
        this.getUi().getCatchWeight().grabFocus();
    }

    public void resetTotalCountComputed() {
        ((NonTargetCatch)this.getTableEditBean()).setTotalCountComputedSource(null);
        this.getUi().getTotalCount().grabFocus();
    }

    public void resetMeanWeightComputed() {
        ((NonTargetCatch)this.getTableEditBean()).setMeanWeightComputedSource(null);
        this.getUi().getMeanWeight().grabFocus();
    }

    public void resetMeanLengthComputed() {
        ((NonTargetCatch)this.getTableEditBean()).setMeanLengthComputedSource(null);
        this.getUi().getMeanLength().grabFocus();
    }

    @Override
    protected Set loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        List speciesList;
        if (mode == ContentMode.UPDATE) {
            Ocean ocean = dataService.getTripOcean(dataSource, dataContext.getSelectedTripId());
            ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
            String speciesListId = config.getSpeciesListSeineNonTargetCatch();
            List allSpecies = dataService.loadDecoratedSpecies(dataSource, speciesListId);
            ReferenceEntities.filterReferentielListByStatus((List)allSpecies);
            speciesList = Species2.filterByOcean((Collection)allSpecies, (Ocean)ocean);
        } else {
            speciesList = new ArrayList();
        }
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)this.getUi(), speciesList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("speciesList = " + speciesList.size()));
        }
        return (Set)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, NonTargetCatch bean, boolean create) {
        Object requestFocus;
        List<Object> availableEspeces;
        NonTargetCatchUI ui = this.getUi();
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        if (create) {
            availableEspeces = new ArrayList((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)ui));
            requestFocus = ui.getSpecies();
        } else {
            Species species = bean.getSpecies();
            availableEspeces = Arrays.asList(species);
            requestFocus = ui.getTable();
        }
        ui.getSpecies().setData(availableEspeces);
        ((JComponent)requestFocus).requestFocus();
        NonTargetCatch tableEditBean = (NonTargetCatch)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("totalCount", this.totalCountChanged);
        tableEditBean.addPropertyChangeListener("totalCount", this.totalCountChanged);
        tableEditBean.removePropertyChangeListener("catchWeight", this.catchWeightChanged);
        tableEditBean.addPropertyChangeListener("catchWeight", this.catchWeightChanged);
        tableEditBean.removePropertyChangeListener("meanWeight", this.meanWeightChanged);
        tableEditBean.addPropertyChangeListener("meanWeight", this.meanWeightChanged);
        tableEditBean.removePropertyChangeListener("meanLength", this.meanLengthChanged);
        tableEditBean.addPropertyChangeListener("meanLength", this.meanLengthChanged);
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)55);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)65);
        UIHelper.fixTableColumnWidth((JTable)table, (int)5, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table, (int)6, (int)55);
        UIHelper.fixTableColumnWidth((JTable)table, (int)7, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.table.nonTargetCatch.speciesFaune", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.speciesFaune.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.speciesFate", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.speciesFate.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.reasonForDiscard", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.reasonForDiscard.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.catchWeight", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.catchWeight.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.totalCount", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.totalCount.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.meanWeight", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.meanWeight.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.meanLength", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.meanLength.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.comment", (Object[])new Object[0]), I18n.n((String)"observe.table.nonTargetCatch.comment.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SpeciesFate.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, ReasonForDiscard.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)6, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)7, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSave(Set bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Set> binder) throws Exception {
        try {
            boolean bl = super.doSave(bean, dataService, dataSource, binder);
            return bl;
        }
        finally {
            this.ALL_TAILLES_TO_DELETE_ENTRY.removeContextValue((JAXXContext)this.getUi());
        }
    }

    @Override
    protected boolean prepareSave(Set editBean, List<NonTargetCatch> objets) throws Exception {
        super.prepareSave(editBean, objets);
        List speciessUsed = this.getTableModel().getColumnValues(0);
        HashSet speciessToDelete = new HashSet();
        ArrayList tailleToDelete = new ArrayList();
        this.getDataService().getObsoleteEspeceForNonTargetSample(this.getDataSource(), editBean.getTopiaId(), speciessUsed, speciessToDelete, tailleToDelete);
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            Decorator decorator = this.getDecoratorService().getDecoratorByType(Species.class);
            Decorator decorator2 = this.getDecoratorService().getDecoratorByType(NonTargetLength.class);
            for (Species e : speciessToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append('\n');
            }
            for (NonTargetLength t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append('\n');
            }
            int reponse = UIHelper.askUser(I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.message.table.nonTargetCatch.will.delete.nonTargetSample", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n.t((String)"observe.choice.continue", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            this.ALL_TAILLES_TO_DELETE_ENTRY.setContextValue((JAXXContext)this.getUi(), tailleToDelete);
        }
        boolean hasRejet = false;
        for (NonTargetCatch c : objets) {
            if (c.getReasonForDiscard() == null) continue;
            hasRejet = true;
            break;
        }
        editBean.setNonTargetDiscarded(Boolean.valueOf(hasRejet));
        return true;
    }

    @Override
    protected void onUpendDatealize(TopiaContext tx, Set bean, Collection<NonTargetCatch> oldChilds) {
        List tailleToDelete = (List)this.ALL_TAILLES_TO_DELETE_ENTRY.getContextValue((JAXXContext)this.getUi());
        if (tailleToDelete != null && !tailleToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will remove " + tailleToDelete.size() + " obsolete nonTargetSample(s)."));
            }
            NonTargetSample echantillon = (NonTargetSample)bean.getNonTargetSample().get(0);
            echantillon.getNonTargetLength().removeAll(tailleToDelete);
        }
    }
}

