/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.ref;

import com.google.common.collect.Sets;
import fr.ird.observe.BinderService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.EntityMap;
import fr.ird.observe.entities.constants.ReferenceLocale;
import fr.ird.observe.entities.constants.ReferenceStatus;
import fr.ird.observe.entities.referentiel.I18nReferenceEntity;
import fr.ird.observe.entities.referentiel.LengthWeightAble;
import fr.ird.observe.entities.referentiel.LengthWeightParameter;
import fr.ird.observe.entities.referentiel.NeedCommentReferenceEntity;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.referentiel.ReferenceEntity;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.SpeciesList;
import fr.ird.observe.entities.referentiel.VesselSizeCategory;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.ref.ContentReferenceUI;
import fr.ird.observe.ui.content.ref.ContentReferenceUIModel;
import fr.ird.observe.ui.content.ref.UniqueKeyTableModel;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.ui.usage.UsagesUI;
import fr.ird.observe.ui.util.SpringUtilities;
import fr.ird.observe.validation.ValidationContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderModelBuilder;

public class ContentReferenceUIHandler<E extends ReferenceEntity>
extends ContentUIHandler<E> {
    private static final Log log = LogFactory.getLog(ContentReferenceUIHandler.class);
    protected String[] properties;
    protected String[] dataBinding;
    protected String[] naturalIds;
    public static final String SUFFIX_TEXT = ".text";
    public static final String SUFFIX_MODEL = ".model";
    public static final String SUFFIX_SELECTED_INDEX = ".selectedIndex";
    public static final String SUFFIX_SELECTED_ITEM = ".selectedItem";
    public static final String SUFFIX_SELECTED = ".selected";
    public static final String SUFFIX_SELECTED_INDICES = ".selectedIndices";
    public static final String SUFFIX_DATE = ".date";
    protected static final String[] DEFAULT_DATABINDING = new String[]{"code.text", "uri.text", "status.selectedIndex"};
    protected static final String[] DEFAULT_NEED_COMMENT_DATABINDING = new String[]{"needComment.selected"};
    protected static final String[] DEFAULT_LENGTH_WEIGHT_ABLE_DATABINDING = new String[]{"lengthMeasureType.text", "minLength.model", "maxLength.model", "minWeight.model", "maxWeight.model"};
    protected static final String[] DEFAULT_LENGTH_WEIGHT_PARAMETER_ABLE_DATABINDING = new String[]{"startDate.date", "endDate.date", "species.selectedItem", "ocean.selectedItem", "sex.selectedIndex", "lengthWeightFormula.text", "weightLengthFormula.text", "coefficients.text", "meanLength.model", "meanWeight.model"};
    protected static final String[] DEFAULT_SPECIES_DATABINDING = new String[]{"homeId.text", "faoCode.text", "wormsId.text", "scientificLabel.text", "ocean.selectedIndices"};
    protected static final String[] DEFAULT_I18N_DATABINDING = new String[]{"label1.text", "label2.text", "label3.text", "label4.text", "label5.text", "label6.text", "label7.text", "label8.text"};
    protected static final String[] DEFAULT_PROPERTIES = new String[]{"code", "uri", "status"};
    protected static final String[] DEFAULT_NEED_COMMENT_PROPERTIES = new String[]{"needComment"};
    protected static final String[] DEFAULT_TAILLE_POIDS_ABLE_PROPERTIES = new String[]{"lengthMeasureType", "minLength", "maxLength", "minWeight", "maxWeight"};
    protected static final String[] DEFAULT_PARAMETRAGE_TAILLE_POIDS_ABLE_PROPERTIES = new String[]{"startDate", "endDate", "ocean", "species", "sex", "lengthWeightFormula", "weightLengthFormula", "coefficients", "meanLength", "meanWeight"};
    protected static final String[] DEFAULT_ESPECE_PROPERTIES = new String[]{"homeId", "faoCode", "wormsId", "scientificLabel", "ocean"};
    protected static final String[] DEFAULT_I18N_PROPERTIES = new String[]{"label1", "label2", "label3", "label4", "label5", "label6", "label7", "label8"};
    private final Runnable revalidate = new Runnable(){

        @Override
        public void run() {
            ContentUI ui = ContentReferenceUIHandler.this.getUi();
            Container parent = ui.getParent();
            if (parent == null) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Will revalidate " + parent.getName()));
            }
            ui.revalidate();
        }
    };

    public ContentReferenceUIHandler(ContentReferenceUI<E> ui, String[] extraProperties, String[] naturalIds, String ... extraBindings) {
        super(ui, null, null);
        String[] stringArray;
        boolean useDefault;
        boolean bl = useDefault = naturalIds == null;
        if (useDefault) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = DEFAULT_PROPERTIES[0];
        } else {
            stringArray = naturalIds;
        }
        this.naturalIds = stringArray;
        List<String> bindings = this.buildDataBindings(useDefault, extraBindings);
        List<String> properties = this.buildProperties(useDefault, extraProperties);
        if (log.isDebugEnabled()) {
            log.debug((Object)("useDefault = " + useDefault));
            log.debug((Object)("dataBinding = " + bindings));
            log.debug((Object)("properties = " + properties));
        }
        this.dataBinding = bindings.toArray(new String[bindings.size()]);
        this.properties = properties.toArray(new String[properties.size()]);
    }

    public void selectBean(E selectedBean) {
        ((ContentReferenceUIModel)this.getModel()).setSelectedBean(selectedBean);
        this.getLoadBinder().load(selectedBean, this.getBean(), true, new String[0]);
    }

    @Override
    public ContentReferenceUI<E> getUi() {
        return (ContentReferenceUI)super.getUi();
    }

    @Override
    public ContentReferenceUIModel<E> getModel() {
        return ((ContentReferenceUI)this.getUi()).getModel();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteReferentiel();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        this.addInfoMessage(I18n.t((String)"observe.message.referentiel.editable", (Object[])new Object[0]));
        return ContentMode.UPDATE;
    }

    public void showUniqueKeys(JButton button) {
        List entities;
        Class beanType = this.getBeanType();
        try {
            entities = this.getDataService().loadDecoratedEntities(this.getDataSource(), beanType);
        }
        catch (DataSourceException e) {
            ErrorDialogUI.showError((Exception)((Object)e));
            return;
        }
        ArrayList<Object[]> datas = new ArrayList<Object[]>(entities.size());
        int nbColumns = this.naturalIds.length + 1;
        String[] columns = new String[nbColumns];
        System.arraycopy(this.naturalIds, 0, columns, 1, this.naturalIds.length);
        columns[0] = Introspector.decapitalize(beanType.getSimpleName());
        DecoratorService dService = this.getDecoratorService();
        TopiaEntityBinder binder = this.getLoadBinder();
        Decorator decorator = dService.getDecoratorByType(beanType);
        for (ReferenceEntity e : entities) {
            Map values = binder.obtainProperties((Object)e, this.naturalIds);
            Object[] data = new Object[nbColumns];
            int index = 0;
            data[0] = decorator.toString((Object)e);
            for (String property : this.naturalIds) {
                Object value;
                Object o = values.get(property);
                if (DEFAULT_PROPERTIES[0].equals(property) && o == null) {
                    o = 0;
                }
                if ("code".equals(property) && o == null) {
                    o = 0;
                }
                if ("gender".equals(property) && o == null) {
                    o = 0;
                }
                if (o instanceof ReferenceEntity) {
                    Decorator d = dService.getDecoratorByType(o.getClass());
                    value = d.toString(o);
                } else {
                    value = o;
                }
                data[++index] = value;
            }
            datas.add(data);
        }
        JTable table = new JTable(new UniqueKeyTableModel(columns, datas));
        table.setAutoCreateRowSorter(true);
        table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        table.setFillsViewportHeight(true);
        JScrollPane pane = new JScrollPane();
        ((ContentReferenceUI)this.getUi()).decorateUniqueKeyTable(table, new DefaultTableCellRenderer(), pane);
        pane.setViewportView(table);
        pane.setVerticalScrollBarPolicy(20);
        String title = I18n.t((String)"observe.title.unique.key", (Object[])new Object[]{I18n.t((String)dService.getEntityLabel(beanType), (Object[])new Object[0])});
        pane.setBorder(new TitledBorder(title));
        JPopupMenu popup = new JPopupMenu();
        popup.setBorder(null);
        popup.add(pane);
        popup.pack();
        Dimension dim = popup.getPreferredSize();
        int x = (int)(button.getPreferredSize().getWidth() - dim.getWidth());
        int y = button.getHeight();
        popup.show(button, x, y);
    }

    public void showUsages() {
        EntityMap usages;
        ReferenceEntity bean = this.getModel().isEditing() ? (ReferenceEntity)this.getModel().getBean() : (ReferenceEntity)((ContentReferenceUIModel)this.getModel()).getSelectedBean();
        try {
            usages = this.getDataService().findAllUsages(this.getDataSource(), (TopiaEntity)bean);
        }
        catch (DataSourceException e) {
            ErrorDialogUI.showError((Exception)((Object)e));
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            return;
        }
        DecoratorService dService = ObserveContext.get().getDecoratorService();
        Decorator decorator = dService.getDecoratorByType(bean.getClass());
        String type = dService.getEntityLabel(bean.getClass());
        type = I18n.t((String)type, (Object[])new Object[0]);
        String message = I18n.t((String)"observe.message.show.usages", (Object[])new Object[]{type, decorator.toString((Object)bean)});
        ContentUI ui = this.getUi();
        UsagesUI usagesUI = new UsagesUI((JAXXContext)ui);
        usagesUI.init(message, null, null, (Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>)usages);
        UIHelper.askUser((Component)((Object)ui), I18n.t((String)"observe.title.show.usage", (Object[])new Object[0]), usagesUI, 1, new Object[]{I18n.t((String)"observe.choice.quit", (Object[])new Object[0])}, 0);
    }

    public void showTechnicalInformations(JButton button) {
        ReferenceEntity bean = this.getModel().isEditing() ? (ReferenceEntity)this.getBean() : (ReferenceEntity)((ContentReferenceUIModel)this.getModel()).getSelectedBean();
        JPanel content = new JPanel(new SpringLayout());
        content.add(new JLabel(I18n.t((String)"observe.common.topiaId", (Object[])new Object[0])));
        content.add(new JLabel(bean.getTopiaId()));
        content.add(new JLabel(I18n.t((String)"observe.common.topiaCreateDate", (Object[])new Object[0])));
        content.add(new JLabel(bean.getTopiaCreateDate().toString()));
        content.add(new JLabel(I18n.t((String)"observe.common.topiaVersion", (Object[])new Object[0])));
        content.add(new JLabel(bean.getTopiaVersion() + ""));
        SpringUtilities.makeCompactGrid(content, 3, 2, 5, 5, 5, 5);
        Decorator decorator = this.getDecoratorService().getDecoratorByType(this.getBeanType());
        String title = I18n.t((String)"observe.title.technical.informations", (Object[])new Object[]{"\n" + decorator.toString((Object)bean)});
        content.setBorder(new TitledBorder(title));
        JPopupMenu popup = new JPopupMenu();
        popup.setBorderPainted(true);
        popup.add(content);
        popup.pack();
        Dimension dim = popup.getPreferredSize();
        int x = (int)(button.getPreferredSize().getWidth() - dim.getWidth());
        int y = button.getHeight();
        popup.show(button, x, y);
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        ContentUI ui = this.getUi();
        ((ContentReferenceUI)ui).getViewLayout().addPropertyChangeListener("selected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(ContentReferenceUIHandler.this.revalidate);
            }
        });
    }

    @Override
    protected void init(DataSource service, BeanListHeader beanList) throws DataSourceException {
        beanList.setI18nPrefix("observe.common.");
        if (log.isInfoEnabled()) {
            log.info((Object)("init list for " + beanList.getBeanType()));
        }
        if ("listHeader".equals(beanList.getName())) {
            UIHelper.prepareEntityList(service, beanList.getBeanType(), beanList, this.getLoadBinder());
        } else {
            UIHelper.prepareEntityList(service, beanList.getBeanType(), beanList, null);
        }
        JList jlist = beanList.getList();
        Object init = jlist.getClientProperty("addDecorator");
        if (init != null) {
            Class klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("addDecorator to list " + jlist.getName()));
            }
            Decorator decorator = this.getDecoratorService().getDecoratorByType(klass);
            jlist.putClientProperty("decorator", decorator);
        }
        if ((init = jlist.getClientProperty("addToogleListSelectionModel")) != null && init instanceof Boolean && ((Boolean)init).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            UIHelper.prepareToogleListSelectionModel(jlist);
        }
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        ContentUIModel model = this.getModel();
        ContentUI ui = this.getUi();
        if (I18nReferenceEntity.class.isAssignableFrom(model.getBeanType())) {
            ReferenceLocale localeEnum = ReferenceLocale.valueOf((Locale)ui.getConfig().getDbLocale());
            String libelleName = localeEnum.getLibelle() + "Label";
            for (int i = 1; i <= 8; ++i) {
                String lib = "libelle" + i + "Label";
                JLabel label = (JLabel)ui.getObjectById(lib);
                if (label == null) continue;
                Font font = label.getFont();
                Font normalFont = font.deriveFont(0);
                Font boldFont = font.deriveFont(1);
                font = libelleName.equals(lib) ? boldFont : normalFont;
                label.setFont(font);
                ((JComponent)ui.getObjectById("libelle" + i)).setFont(font);
            }
        }
        ContentMode mode = this.computeContentMode();
        model.setMode(mode);
        if (mode != ContentMode.READ) {
            ui.processDataBinding("deleteFromList.enabled");
        }
    }

    @Override
    protected void updateToolbarActions() {
        super.updateToolbarActions();
        ContentUI ui = this.getUi();
        JToolBar toolBar = ui.getTitleRightToolBar();
        toolBar.add((Component)((ContentReferenceUI)ui).getShowUniqueKeys(), 2);
        toolBar.add((Component)((ContentReferenceUI)ui).getShowTechnicalInformations(), 2);
        toolBar.add((Component)((ContentReferenceUI)ui).getShowUsages(), 2);
    }

    @Override
    public void startEditUI(String ... binding) {
        boolean canEdit;
        ContentUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        ReferenceEntity bean = (ReferenceEntity)model.getBean();
        ContentMode mode = model.getMode();
        boolean bl = canEdit = mode != ContentMode.READ;
        if (canEdit) {
            ContentReferenceUIHandler.removeAllMessages(ui);
            String contextName = this.getValidatorContextName(mode);
            if (log.isDebugEnabled()) {
                log.debug((Object)("contextName = " + contextName));
            }
            ((ContentReferenceUI)ui).getValidator().setContext(contextName);
            if (mode == ContentMode.CREATE) {
                this.addInfoMessage(I18n.t((String)"observe.message.creating.referentiel", (Object[])new Object[0]));
                try {
                    this.getDataService().preCreate(this.getDataSource(), null, (TopiaEntity)bean, this.getLoadBinder(), this.getPreCreateExecutor());
                }
                catch (DataSourceException e) {
                    ErrorDialogUI.showError((Exception)((Object)e));
                }
            } else {
                this.addInfoMessage(I18n.t((String)"observe.message.updating.referentiel", (Object[])new Object[0]));
            }
            super.startEditUI(this.dataBinding);
            if (mode == ContentMode.UPDATE) {
                ((ContentReferenceUI)ui).getValidator().setChanged(false);
            }
        } else {
            SwingValidatorUtil.setValidatorBean((JAXXObject)ui, null, (String[])new String[0]);
            UIHelper.processDataBinding((JAXXObject)ui, (String[])this.dataBinding);
            model.setEditing(true);
            ObserveServiceHelper.get().getValidationContext().cleanCache();
        }
    }

    @Override
    protected void prepareValidationContext() {
        super.prepareValidationContext();
        BeanListHeader jList = ((ContentReferenceUI)this.getUi()).getListHeader();
        List data = jList.getData();
        ValidationContext validationContext = ObserveServiceHelper.get().getValidationContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set referentiel list [" + this.getBeanType().getSimpleName() + "] in validation context : " + data.size()));
        }
        validationContext.setEditingReferentielList(data);
    }

    @Override
    public boolean closeUI() throws Exception {
        return super.closeUI();
    }

    public final void createUI() {
        ContentUI ui = this.getUi();
        this.getModel().setMode(ContentMode.CREATE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will create new entity [" + this.getModel().getBeanType() + "]"));
        }
        this.getLoadBinder().load(null, this.getBean(), true, new String[0]);
        ui.startEdit(null);
    }

    public void modifyUI() {
        ContentUIModel model = this.getModel();
        if (model.getMode() != ContentMode.READ) {
            model.setMode(ContentMode.UPDATE);
        }
        this.getLoadBinder().load(((ContentReferenceUIModel)model).getSelectedBean(), this.getBean(), true, new String[0]);
        this.getUi().startEdit(null);
    }

    @Override
    public void stopEditUI() {
        super.stopEditUI();
        ContentUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        if (model.getMode() != ContentMode.READ) {
            model.setMode(ContentMode.UPDATE);
            ContentReferenceUIHandler.removeAllMessages(ui);
            this.addInfoMessage(I18n.t((String)"observe.message.referentiel.editable", (Object[])new Object[0]));
        }
    }

    @Override
    public final void resetEditUI() {
        ContentMode mode = this.getModel().getMode();
        super.resetEditUI();
        if (mode == ContentMode.CREATE) {
            this.createUI();
        } else {
            this.modifyUI();
        }
    }

    public void backToList() {
        ContentUIModel model = this.getModel();
        if (!model.isModified() || ContentReferenceUIHandler.checkEdit(this.getUi())) {
            this.getUi().stopEdit();
            this.getLoadBinder().load(((ContentReferenceUIModel)model).getSelectedBean(), this.getBean(), true, new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectOceans(Species bean, JList jlist, Object[] selected) {
        boolean update;
        boolean bl = update = selected.length != bean.sizeOcean();
        if (!update && selected.length > 0) {
            Collection list = bean.getOcean();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = jlist.getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                HashSet newList = Sets.newHashSet();
                for (Object o : selected) {
                    newList.add((Ocean)o);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update oceans " + newList.size()));
                }
                bean.setOcean((Collection)newList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSpecies(SpeciesList bean, JList jlist, Object[] selected) {
        boolean update;
        boolean bl = update = selected.length != bean.sizeSpecies();
        if (!update && selected.length > 0) {
            Collection list = bean.getSpecies();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = jlist.getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                HashSet newList = Sets.newHashSet();
                for (Object o : selected) {
                    newList.add((Species)o);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update species " + newList.size()));
                }
                bean.setSpecies((Collection)newList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    @Override
    protected boolean doSave(E bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<E> binder) throws Exception {
        ReferenceEntity oldBean;
        ContentUIModel model = this.getModel();
        if (bean.getTopiaId() == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Create referentiel " + bean));
            }
            dataService.create(dataSource, null, bean, binder, this.getCreateExecutor());
            if (bean instanceof Program) {
                ObserveTreeHelper treeHelper = ContentReferenceUIHandler.getTreeHelper((JAXXContext)this.getUi());
                treeHelper.addProgram((Program)bean);
            }
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will update exisintg entity : " + bean.getTopiaId()));
        }
        if ((oldBean = (ReferenceEntity)((ContentReferenceUIModel)model).getSelectedBean()) != null && oldBean.getStatus() == ReferenceStatus.enabled && bean.getStatus() == ReferenceStatus.disabled) {
            EntityMap usages;
            if (log.isDebugEnabled()) {
                log.debug((Object)"entity status was desactivated, looking for usage");
            }
            if ((usages = dataService.findAllUsages(dataSource, bean)).isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No usage found, no warning to display");
                }
            } else {
                boolean willsave = ContentReferenceUIHandler.showUsagesForDesactivated((JAXXContext)this.getUi(), bean, (Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>)usages);
                if (!willsave) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User refuses to continue, skip saving...");
                    }
                    return false;
                }
            }
        }
        if ((bean = (ReferenceEntity)dataService.update(dataSource, null, bean, this.getUpdateExecutor())) instanceof Program) {
            ObserveTreeHelper treeHelper = ContentReferenceUIHandler.getTreeHelper((JAXXContext)this.getUi());
            treeHelper.updateProgram((Program)bean);
        }
        return true;
    }

    @Override
    protected E onUpdate(TopiaContext tx, Object parentBean, E beanToSave) throws TopiaException {
        this.getLoadBinder().copy(this.getBean(), beanToSave, new String[0]);
        return beanToSave;
    }

    @Override
    protected boolean doDelete(E bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, E> deletor) throws Exception {
        EntityMap usages;
        ContentUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        if (log.isInfoEnabled()) {
            log.info((Object)"entity to be deleted, looking for usage");
        }
        if ((usages = dataService.findAllUsages(this.getDataSource(), bean)).isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No usage found, no warning to display");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"can not delete referentiel entity (found usages)");
            }
            ContentReferenceUIHandler.showUsagesForDelete((JAXXContext)ui, bean, (Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>)usages);
            return false;
        }
        if (!UIHelper.confirmForEntityDelete(ui, model.getBeanType(), bean)) {
            return false;
        }
        String beanId = bean.getTopiaId();
        dataService.delete(dataSource, null, bean, deletor);
        if (bean instanceof Program) {
            ObserveTreeHelper treeHelper = ContentReferenceUIHandler.getTreeHelper((JAXXContext)this.getUi());
            treeHelper.removeProgram(beanId);
        }
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parentBean, E beanToDelete) throws TopiaException {
        TopiaDAO dao = this.getDataSource().getDAO(tx, beanToDelete);
        dao.delete(beanToDelete);
    }

    protected final List<String> buildProperties(boolean usedefault, String[] properties) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(DEFAULT_PROPERTIES));
        result.addAll(Arrays.asList(properties));
        Class beanType = this.getBeanType();
        if (I18nReferenceEntity.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_I18N_PROPERTIES));
        }
        if (NeedCommentReferenceEntity.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_NEED_COMMENT_PROPERTIES));
        }
        if (LengthWeightAble.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_TAILLE_POIDS_ABLE_PROPERTIES));
        }
        if (LengthWeightParameter.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_PARAMETRAGE_TAILLE_POIDS_ABLE_PROPERTIES));
        }
        if (Species.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_ESPECE_PROPERTIES));
        }
        if (!usedefault) {
            result.remove(DEFAULT_PROPERTIES[0]);
        }
        return result;
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
        this.getUi().stopEdit();
    }

    @Override
    protected E onPreCreate(TopiaContext tx, Object parent, E bean) throws TopiaException {
        bean.setTopiaId(null);
        bean.setTopiaCreateDate(null);
        bean.setTopiaVersion(0L);
        bean.setStatus(ReferenceStatus.enabled);
        return bean;
    }

    @Override
    protected final E onCreate(TopiaContext tx, Object parent, E editBean) throws TopiaException {
        Map properties = this.getLoadBinder().obtainProperties(editBean, this.naturalIds);
        TopiaDAO dao = this.getDataSource().getDAO(tx, this.getModel().getBeanType());
        ReferenceEntity beanToSave = (ReferenceEntity)dao.create(properties);
        editBean.setTopiaId(beanToSave.getTopiaId());
        return (E)beanToSave;
    }

    @Override
    protected TopiaEntityBinder<E> createOpeningBinder(BinderService binderService) {
        String binderName;
        Class mainEntityClass = this.getBeanType();
        TopiaEntityBinder r = binderService.getTopiaBinder(mainEntityClass, binderName = this.getClass().getName() + "-open");
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(mainEntityClass, this.properties);
            r = binderService.registerTopiaBinder(mainEntityClass, builder, binderName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("new binder [" + this.getClass().getName() + "#" + mainEntityClass.getName() + "] : " + Arrays.toString(this.properties)));
            }
        }
        return r;
    }

    protected final List<String> buildDataBindings(boolean usedefault, String[] dataBinding) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(DEFAULT_DATABINDING));
        result.addAll(Arrays.asList(dataBinding));
        Class beanType = this.getBeanType();
        if (I18nReferenceEntity.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_I18N_DATABINDING));
        }
        if (NeedCommentReferenceEntity.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_NEED_COMMENT_DATABINDING));
        }
        if (LengthWeightAble.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_LENGTH_WEIGHT_ABLE_DATABINDING));
        }
        if (LengthWeightParameter.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_LENGTH_WEIGHT_PARAMETER_ABLE_DATABINDING));
        }
        if (Species.class.isAssignableFrom(beanType)) {
            result.addAll(Arrays.asList(DEFAULT_SPECIES_DATABINDING));
        }
        if (!usedefault) {
            result.remove(DEFAULT_DATABINDING[0]);
        }
        return result;
    }

    public static <E extends TopiaEntity> void showUsagesForDelete(JAXXContext tx, E entity, Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> usages) {
        DecoratorService service = ObserveContext.get().getDecoratorService();
        Decorator decorator = service.getDecoratorByType(entity.getClass());
        String type = service.getEntityLabel(entity.getClass());
        type = I18n.t((String)type, (Object[])new Object[0]);
        String message = I18n.t((String)"observe.message.show.usage.for.delete", (Object[])new Object[]{type, decorator.toString(entity)});
        String message2 = I18n.t((String)"observe.message.show.usage.for.delete2", (Object[])new Object[0]);
        UsagesUI usagesUI = new UsagesUI(tx);
        usagesUI.init(message, message2, null, usages);
        UIHelper.askUser(null, I18n.t((String)"observe.title.can.not.delete.referentiel", (Object[])new Object[0]), usagesUI, 2, new Object[]{I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
    }

    public static <E extends TopiaEntity> boolean showUsagesForDesactivated(JAXXContext tx, E entity, Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> usages) {
        DecoratorService service = ObserveContext.get().getDecoratorService();
        Decorator decorator = service.getDecoratorByType(entity.getClass());
        String type = service.getEntityLabel(entity.getClass());
        type = I18n.t((String)type, (Object[])new Object[0]);
        String message = I18n.t((String)"observe.message.show.usage.for.desactivated", (Object[])new Object[]{type, decorator.toString(entity)});
        String message2 = I18n.t((String)"observe.message.show.usage.for.desactivated2", (Object[])new Object[0]);
        String message3 = I18n.t((String)"observe.message.show.usage.for.desactivated3", (Object[])new Object[0]);
        UsagesUI usagesUI = new UsagesUI(tx);
        usagesUI.init(message, message2, message3, usages);
        int reponse = UIHelper.askUser(null, I18n.t((String)"observe.title.need.confirm.to.desactivate.referentiel", (Object[])new Object[0]), usagesUI, 2, new Object[]{I18n.t((String)"observe.choice.save", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("response : " + reponse));
        }
        switch (reponse) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public <I> int[] updateIndices(JList jlist, Collection<I> list) {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)(list == null ? 0 : list.size()));
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (list != null && !list.isEmpty()) {
            ListModel model = jlist.getModel();
            int max = model.getSize();
            for (i = 0; i < max; ++i) {
                Object s = model.getElementAt(i);
                if (!list.contains(s)) continue;
                indices.add(i);
            }
        }
        int[] result = new int[indices.size()];
        i = 0;
        for (Integer indice : indices) {
            result[i++] = indice;
        }
        indices.clear();
        return result;
    }

    public boolean canSeeI18nTable(E bean) {
        return bean instanceof I18nReferenceEntity || bean instanceof VesselSizeCategory;
    }

    public void decorateUniqueKeyTable(JTable table, TableCellRenderer renderer, JScrollPane pane) {
        table.setAutoResizeMode(3);
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)70);
    }

    public String updateView(boolean editing) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Editing has changed : " + editing));
        }
        return editing ? "detailView" : "listView";
    }
}

