/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl.seine;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.referentiel.seine.VesselActivity;
import fr.ird.observe.entities.seine.Activity;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.Trip;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.seine.ActivityUI;
import fr.ird.observe.ui.content.open.impl.seine.RouteUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Component;
import java.util.Date;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;
import org.nuiton.validator.NuitonValidatorScope;

public class RouteUIHandler
extends ContentOpenableUIHandler<Route> {
    private static Log log = LogFactory.getLog(RouteUIHandler.class);
    public static final String UPDATE_MAREE_NODE = "updateTripNode";

    public RouteUIHandler(RouteUI ui) {
        super(ui, DataContextType.Trip, DataContextType.Route, I18n.n((String)"observe.message.route.not.open", (Object[])new Object[0]));
    }

    @Override
    public RouteUI getUi() {
        return (RouteUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Route> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Route.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Route.class, new String[]{"date", "startLogValue", "endLogValue", "checkLevel", "activity", "open", "comment"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"activity"});
            BinderModelBuilder builder2 = binderService.newBinderBuilder(Activity.class, new String[]{"quadrant", "latitude", "longitude", "time", "seaSurfaceTemperature", "reasonForNoFishing", "vesselActivity", "wind", "open"});
            TopiaEntityBinder binder = binderService.registerTopiaBinder(Activity.class, builder2, binderName);
            builder.addBinder("activity", (Binder)binder);
            r = binderService.registerTopiaBinder(Route.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String routeId = this.getSelectedId();
        if (routeId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Route.class)) {
            return ContentMode.UPDATE;
        }
        RouteUI ui = this.getUi();
        if (!dataContext.isSelectedOpen(Trip.class)) {
            RouteUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Trip.class), I18n.t((String)"observe.message.maree.not.open", (Object[])new Object[0]));
        } else {
            RouteUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Route.class), I18n.t((String)this.closeMessage, (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        boolean create;
        super.openUI();
        String mareeId = this.getSelectedParentId();
        String routeId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "mareeId = " + mareeId));
            log.info((Object)(this.prefix + "routeId = " + routeId));
        }
        ContentMode mode = this.computeContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "content mode = " + (Object)((Object)mode)));
        }
        DataService dataService = this.getDataService();
        Route editBean = (Route)this.getBean();
        boolean bl = create = routeId == null;
        if (create) {
            dataService.preCreate(this.getDataSource(), mareeId, (TopiaEntity)editBean, this.getLoadBinder(), this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(this.getDataSource(), routeId, this.getLoadExecutor());
            if (!editBean.isActivityEmpty()) {
                DBHelper.sortActivitys((List)editBean.getActivity());
            }
        }
        this.finalizeOpenUI(mode, create);
    }

    @Override
    protected Route onPreCreate(TopiaContext tx, Object parent, Route bean) throws TopiaException {
        Date date;
        Trip parentBean = (Trip)parent;
        Route lastRoute = parentBean.getLastRoute();
        if (lastRoute == null) {
            date = new Date();
        } else {
            date = DateUtils.addDays((Date)lastRoute.getDate(), (int)1);
            bean.setStartLogValue(lastRoute.getEndLogValue());
        }
        bean.setDate(DBHelper.getDay((Date)date));
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use date : " + bean.getDate()));
            log.info((Object)("Will loch matin ast last loch soir : " + bean.getStartLogValue()));
        }
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        boolean create = this.getModel().getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(this.getModel().getMode());
        RouteUI ui = this.getUi();
        ui.getValidator().setContext(contextName);
        if (create) {
            RouteUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Route.class), I18n.t((String)"observe.message.creating.route", (Object[])new Object[0]));
        } else {
            RouteUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Route.class), I18n.t((String)"observe.message.updating.route", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)this.getModel()).isHistoricalData()) {
                this.addInfoMessage(I18n.t((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        }
        super.startEditUI("date.date", "startLogValue.model", "endLogValue.enabled", "comment2.text", "close.enabled", "closeAndCreate.enabled");
        this.getModel().setModified(create);
    }

    @Override
    protected boolean doSave(Route bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Route> binder) throws Exception {
        String mareeId = this.getSelectedParentId();
        if (log.isInfoEnabled()) {
            log.info((Object)("will save route " + bean.getTopiaId()));
        }
        Date date = DBHelper.getDay((Date)bean.getDate());
        bean.setDate(date);
        bean.setOpen(true);
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, mareeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, mareeId, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
        this.repaintTripNode();
    }

    @Override
    protected void afterDelete() {
        super.afterDelete();
        this.repaintTripNode();
    }

    @Override
    protected Route onCreate(TopiaContext tx, Object parent, Route editBean) throws TopiaException {
        Trip parentBean = (Trip)parent;
        Route beanToSave = (Route)ObserveDAOHelper.getRouteDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addRoute(beanToSave);
        beanToSave.setDate(editBean.getDate());
        this.updateDateFin(parentBean);
        return beanToSave;
    }

    @Override
    protected Route onUpdate(TopiaContext tx, Object parent, Route beanToSave) throws TopiaException {
        Trip parentBean = (Trip)parent;
        Route editBean = (Route)this.getBean();
        Date oldDate = DBHelper.getDay((Date)beanToSave.getDate());
        this.getLoadBinder().copyExcluding((Object)editBean, (Object)beanToSave, new String[]{"activity"});
        if (!oldDate.equals(editBean.getDate())) {
            beanToSave.updateDates();
        }
        this.updateDateFin(parentBean);
        return beanToSave;
    }

    @Override
    protected boolean doDelete(Route bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, Route> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        String mareeId = this.getSelectedParentId();
        dataService.delete(dataSource, mareeId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, Route beanToDelete) {
        Trip parentBean = (Trip)parent;
        parentBean.removeRoute(beanToDelete);
        this.updateDateFin(parentBean);
    }

    @Override
    public boolean doCloseData() throws Exception {
        Route route = (Route)this.getBean();
        boolean mustAddFinVeille = !route.isActivityFindDeVeilleFound();
        boolean createActivityFinDeVeille = false;
        boolean closeActivityFinDeVeille = false;
        boolean gotoActivityFinDeVeille = false;
        ObserveTreeHelper treeHelper = RouteUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode routeNode = (ObserveNode)treeHelper.getSelectedNode();
        if (mustAddFinVeille) {
            int reponse = UIHelper.askUser((Component)((Object)this.getUi()), I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.message.need.fin.veille.activity", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.not.create.fin.veille.activity.and.continue", (Object[])new Object[0]), I18n.t((String)"observe.choice.create.fin.veille.activity.and.continue", (Object[])new Object[0]), I18n.t((String)"observe.choice.create.fin.veille.activity", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 3: {
                    return false;
                }
                case 0: {
                    break;
                }
                case 1: {
                    createActivityFinDeVeille = true;
                    closeActivityFinDeVeille = true;
                    break;
                }
                case 2: {
                    createActivityFinDeVeille = true;
                    gotoActivityFinDeVeille = true;
                }
            }
        }
        if (createActivityFinDeVeille) {
            this.stopEditUI();
            this.addActivityFinDeVeille(closeActivityFinDeVeille);
            if (gotoActivityFinDeVeille) {
                return false;
            }
            treeHelper.selectNode((NavNode)routeNode);
        }
        super.doCloseData();
        return true;
    }

    protected ActivityUI addActivityFinDeVeille(boolean close) {
        ObserveTreeHelper treeHelper = RouteUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode parentNode = (ObserveNode)treeHelper.getSelectedNode();
        parentNode = (ObserveNode)treeHelper.findNode((NavNode)parentNode, new String[]{I18n.n((String)"observe.common.activitys", (Object[])new Object[0])});
        if (log.isDebugEnabled()) {
            log.debug((Object)("PARENT NODE = " + (Object)((Object)parentNode)));
        }
        treeHelper.addUnsavedNode(parentNode, Activity.class);
        ActivityUI selectedUI = (ActivityUI)ObserveContext.get().getSelectedContentUI();
        VesselActivity vesselActivity = null;
        for (Object o : selectedUI.getVesselActivity().getData()) {
            VesselActivity a = (VesselActivity)o;
            if (!"16".equals(a.getCode())) continue;
            vesselActivity = a;
            break;
        }
        selectedUI.getBean().setVesselActivity(vesselActivity);
        if (close) {
            selectedUI.save(false);
            selectedUI.closeData();
            selectedUI.stopEdit();
        }
        return selectedUI;
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        boolean canReopen = !create && dataContext.isSelectedOpen(Trip.class) && !dataContext.isOpenRoute();
        return canReopen;
    }

    protected void repaintTripNode() {
        Boolean updateTripNode = this.getUi().getContextValue(Boolean.class, UPDATE_MAREE_NODE);
        this.getUi().removeContextValue(Boolean.class, UPDATE_MAREE_NODE);
        if (updateTripNode == null || !updateTripNode.booleanValue()) {
            return;
        }
        ObserveTreeHelper treeHelper = RouteUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode mareeNode = (ObserveNode)((ObserveNode)((ObserveNode)treeHelper.getSelectedNode()).getParent()).getParent();
        if (log.isInfoEnabled()) {
            log.info((Object)("Refresh maree node : " + (Object)((Object)mareeNode)));
        }
        treeHelper.refreshNode((NavNode)mareeNode, false);
    }

    protected void updateDateFin(Trip parentBean) {
        Date endDate = parentBean.getEndDate();
        parentBean.updateDateFin();
        if (!endDate.equals(parentBean.getEndDate())) {
            this.getUi().setContextValue(Boolean.TRUE, UPDATE_MAREE_NODE);
        } else {
            this.getUi().removeContextValue(Boolean.class, UPDATE_MAREE_NODE);
        }
    }
}

