/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.seine;

import fr.ird.observe.BinderService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.seine.Activity;
import fr.ird.observe.entities.seine.FloatingObject;
import fr.ird.observe.entities.seine.FloatingObjectDAO;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.seine.FloatingObjectUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderModelBuilder;
import org.nuiton.validator.NuitonValidatorScope;

public class FloatingObjectUIHandler
extends ContentUIHandler<FloatingObject> {
    private static Log log = LogFactory.getLog(FloatingObjectUIHandler.class);

    public FloatingObjectUIHandler(FloatingObjectUI ui) {
        super(ui, DataContextType.Activity, DataContextType.FloatingObject);
    }

    public FloatingObjectUI getUi() {
        return (FloatingObjectUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<FloatingObject> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(this.getBeanType(), binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(FloatingObject.class, new String[]{"objectType", "objectFate", "objectOperation", "comment", "supportVesselName", "daysAtSeaCount"});
            r = binderService.registerTopiaBinder(this.getBeanType(), builder, binderName);
        }
        return r;
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String dcpId = this.getSelectedId();
        if (dcpId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Activity.class)) {
            return ContentMode.UPDATE;
        }
        FloatingObjectUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(Activity.class), I18n.t((String)"observe.message.activity.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activityId = this.getSelectedParentId();
        String dcpId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
            log.info((Object)("dcpId      = " + dcpId));
        }
        ContentMode mode = this.computeContentMode();
        FloatingObject bean = (FloatingObject)this.getBean();
        DataService dataService = this.getDataService();
        if (dcpId == null) {
            dataService.preCreate(this.getDataSource(), activityId, (TopiaEntity)bean, this.getLoadBinder(), this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(this.getDataSource(), dcpId, this.getLoadExecutor());
        }
        this.setContentMode(mode);
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        ContentUIModel contentUIModel = this.getModel();
        boolean create = contentUIModel.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(contentUIModel.getMode());
        this.getUi().getValidator().setContext(contextName);
        if (create) {
            FloatingObjectUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(FloatingObject.class), I18n.t((String)"observe.message.creating.floatingObject", (Object[])new Object[0]));
        } else {
            FloatingObjectUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(FloatingObject.class), I18n.t((String)"observe.message.updating.floatingObject", (Object[])new Object[0]));
        }
        super.startEditUI("daysAtSeaCount.model", "objectType.selectedItem", "objectFate.selectedItem", "supportVesselName.text", "comment2.text");
        contentUIModel.setModified(create);
    }

    @Override
    protected boolean doSave(FloatingObject bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<FloatingObject> binder) throws Exception {
        String activityId = this.getSelectedParentId();
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, activityId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        return true;
    }

    @Override
    protected FloatingObject onCreate(TopiaContext tx, Object parent, FloatingObject editBean) throws TopiaException {
        Activity parentBean = (Activity)parent;
        FloatingObjectDAO dao = ObserveDAOHelper.getFloatingObjectDAO((TopiaContext)tx);
        FloatingObject beanToSave = (FloatingObject)dao.create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addFloatingObject(beanToSave);
        return beanToSave;
    }

    @Override
    protected FloatingObject onUpdate(TopiaContext tx, Object parentBean, FloatingObject beanToSave) throws TopiaException {
        this.getLoadBinder().copy(this.getBean(), (Object)beanToSave, new String[0]);
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        boolean create;
        super.afterSave(refresh);
        FloatingObject bean = (FloatingObject)this.getBean();
        ObserveTreeHelper treeHelper = FloatingObjectUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        boolean bl = create = node.getId() == null;
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
            node = treeHelper.addFloatingObject(parentNode, bean);
            this.stopEditUI();
            if (refresh) {
                treeHelper.selectNode((NavNode)node);
            }
        } else {
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected boolean doDelete(FloatingObject bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, FloatingObject> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        if (bean.getTopiaId() != null) {
            String activityId = this.getSelectedParentId();
            dataService.delete(dataSource, activityId, (TopiaEntity)bean, deletor);
        }
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, FloatingObject beanToDelete) {
        Activity parentBean = (Activity)parent;
        parentBean.removeFloatingObject(beanToDelete);
    }
}

