/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.synchronize;

import fr.ird.observe.DBHelper;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.SendMessageAble;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.synchronize.ObsoleteEntityTableModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.editor.MyDefaultCellEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.DiffState;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class SynchronizeUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(SynchronizeUIHandler.class);

    public SynchronizeUIHandler(SynchronizeUI ui) {
        super(ui);
    }

    public SynchronizeModel getStepModel() {
        return this.model.getSynchronizeReferentielModel();
    }

    @Override
    public SynchronizeUI getUi() {
        return (SynchronizeUI)super.getUi();
    }

    public void initTabUI(AdminUI ui, SynchronizeUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        final JTable table = tabUI.getObsoleteRefs();
        table.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table, (int)0, (int)20);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.synchro.table.obsolete.entity.select", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.obsolete.entity.select.tip", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.obsolete.entity.label", (Object[])new Object[0]), I18n.n((String)"observe.synchro.table.obsolete.entity.label.tip", (Object[])new Object[0])});
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        tabUI.getStartAction().setText(I18n.t((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n.t((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        tabUI.setContextValue(renderer, "defaultTableRenderer");
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, TopiaEntityRef.class));
        UIHelper.setTableColumnEditor((JTable)table, (int)0, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor((boolean)false));
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colIndex = table.getTableHeader().columnAtPoint(e.getPoint());
                if ((colIndex = table.convertColumnIndexToModel(colIndex)) == 0) {
                    ObsoleteEntityTableModel model;
                    boolean oldValue = (model = (ObsoleteEntityTableModel)table.getModel()).isSelectAll();
                    model.setSelectAll(!oldValue);
                }
            }
        });
    }

    @Override
    public void updateState(AdminTabUI tabUI, WizardState newState) {
        super.updateState(tabUI, newState);
        if (newState == WizardState.NEED_FIX) {
            this.setObsoleteRefs(this.getStepModel().getObsoleteRefs());
        }
    }

    public void onPropertyChanged(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("refsResolved".equals(propertyName)) {
            this.updateSelectedObsoleteEntity();
        } else if ("obsoleteResolved".equals(propertyName)) {
            SynchronizeUI ui = (SynchronizeUI)evt.getSource();
            SynchronizeModel model = ui.getStepModel();
            TopiaEntity entity = (TopiaEntity)evt.getNewValue();
            DecoratorService decoratorService = this.getDecoratorService();
            String type = I18n.t((String)decoratorService.getEntityLabel(entity.getClass()), (Object[])new Object[0]);
            Decorator decorator = decoratorService.getDecoratorByType(entity.getClass());
            String label = I18n.t((String)"observe.synchro.obsolete.entity.label", (Object[])new Object[]{type, decorator.toString((Object)entity)});
            this.sendMessage(I18n.t((String)"observe.synchro.message.obsolete.entities.fixed", (Object[])new Object[]{label}));
            if (model.getObsoleteRefs().isEmpty()) {
                this.sendMessage(I18n.t((String)"observe.synchro.message.all.obsolete.entities.fixed", (Object[])new Object[0]));
            } else {
                this.setObsoleteRefs(model.getObsoleteRefs());
            }
        }
    }

    public void setObsoleteRefs(SortedMap<TopiaEntity, List<TopiaEntityRef>> refs) {
        SynchronizeUI ui = this.getUi();
        ui.errorsSelectionModel.clearSelection();
        ui.errorsModel.removeAllElements();
        for (Map.Entry<TopiaEntity, List<TopiaEntityRef>> entry : refs.entrySet()) {
            ui.errorsModel.addElement(entry);
        }
        ui.setCanApply(false);
        ui.errors.setSelectedIndex(0);
    }

    public void updateSelectedObsoleteEntity() {
        SynchronizeUI ui = this.getUi();
        int row = ui.errorsSelectionModel.getMinSelectionIndex();
        DefaultListModel errorsModel = ui.errorsModel;
        if (row == -1 || errorsModel.getElementAt(row) == null || ((List)((Map.Entry)errorsModel.getElementAt(row)).getValue()).isEmpty()) {
            ui.obsoleteRefLabel.setText("");
            ui.setObsoleteEntity(null);
            ui.obsoleteTableModel.initEntity(Collections.<TopiaEntityRef>emptyList());
        } else {
            Map.Entry entry = (Map.Entry)errorsModel.getElementAt(row);
            TopiaEntity entity = (TopiaEntity)entry.getKey();
            ui.setObsoleteEntity(entity);
            List refs = (List)entry.getValue();
            DecoratorService decoratorService = this.getDecoratorService();
            String type = decoratorService.getEntityLabel(entity.getClass());
            Decorator decorator = decoratorService.getDecoratorByType(entity.getClass());
            String label = I18n.t((String)"observe.synchro.obsolete.entity.label", (Object[])new Object[]{type, decorator.toString((Object)entity)});
            ui.obsoleteRefLabel.setText(label);
            this.changeSafeRefsComboBox(entry);
            ui.obsoleteTableModel.initEntity(refs);
        }
    }

    public void updateCanApply() {
        SynchronizeUI ui = this.getUi();
        ui.setCanApply(!ui.obsoleteTableModel.getSelectedIndex().isEmpty() && this.getSafeComboBox() != null && this.getSafeComboBox().getSelectedItem() != null);
    }

    public BeanComboBox<?> getSafeComboBox() {
        SynchronizeUI ui = this.getUi();
        JPanel panel = ui.getSafeRefsPanel();
        return (BeanComboBox)ui.getSafeRefsPanelLayout().getVisibleComponent((Container)panel);
    }

    public void changeSafeRefsComboBox(Map.Entry<TopiaEntity, List<TopiaEntityRef>> entry) {
        SynchronizeUI ui = this.getUi();
        TopiaEntity entity = entry.getKey();
        ObserveEntityEnum constant = ObserveEntityEnum.valueOf((TopiaEntity)entity);
        String key = constant.getContract().getName();
        CardLayout2 safeRefsPanelLayout = ui.getSafeRefsPanelLayout();
        JPanel safeRefsPanel = ui.getSafeRefsPanel();
        if (safeRefsPanelLayout.contains((Serializable)((Object)key))) {
            BeanComboBox list = (BeanComboBox)safeRefsPanelLayout.getComponent((Container)safeRefsPanel, key);
            if (!this.getSafeComboBox().equals((Object)list)) {
                safeRefsPanelLayout.show((Container)safeRefsPanel, key);
            }
            return;
        }
        Decorator decorator = this.getDecoratorService().getDecoratorByType(entity.getClass());
        List<?> data = this.getEntityListFromSynchroDB(entity.getClass(), true);
        BeanComboBox box = new BeanComboBox((JAXXContext)ui);
        box.setBean((Object)this);
        box.setProperty("safeEntity");
        box.setShowReset(Boolean.valueOf(true));
        box.addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SynchronizeUIHandler.this.updateCanApply();
            }
        });
        safeRefsPanel.add((Component)box, key);
        box.init((JXPathDecorator)decorator, data);
        safeRefsPanelLayout.show((Container)safeRefsPanel, key);
    }

    public void doStartAction() {
        this.addAdminWorker(this.getUi().getStartAction().getToolTipText(), new Callable<WizardState>(){

            @Override
            public WizardState call() throws Exception {
                return SynchronizeUIHandler.this.doAction();
            }
        });
    }

    public WizardState doAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        DataSource source = this.model.getSafeLocalSource(false);
        this.getStepModel().setSource(source);
        DataSource centralSource = this.model.getSafeCentralSource(false);
        this.getStepModel().setCentralSource(centralSource);
        this.openSource(source);
        this.openSource(centralSource);
        this.sendMessage(I18n.t((String)"observe.message.synchro.build.diff", (Object[])new Object[]{centralSource.getLabel()}));
        DiffState.DiffStateMap diff = this.getDataService().buildReferentielDifferentiel(centralSource, source, (SendMessageAble)this);
        this.getStepModel().setDiff(diff);
        if (diff.isEmpty() || CollectionUtils.isEmpty((Collection)((Collection)diff.get((Object)DiffState.REMOVED)))) {
            this.reportSuccess();
            return WizardState.SUCCESSED;
        }
        SortedMap<TopiaEntity, List<TopiaEntityRef>> obsoleteRefs = this.detectObsoleteEntities();
        this.getStepModel().setObsoleteRefs(obsoleteRefs);
        if (obsoleteRefs == null || obsoleteRefs.isEmpty()) {
            this.reportSuccess();
            return WizardState.SUCCESSED;
        }
        ArrayList<TopiaEntity> obsoleteEntities = new ArrayList<TopiaEntity>(obsoleteRefs.keySet());
        this.removeUndirectObsoleteRefs();
        if (obsoleteRefs.isEmpty()) {
            this.reportSuccess();
            return WizardState.SUCCESSED;
        }
        this.sendMessage(I18n.t((String)"observe.message.synchro.create.temporary.db.to.resolve.obsoletes", (Object[])new Object[0]));
        DataSource tmpSource = this.model.getSafeTmpSource(false);
        this.getStepModel().setTmpSource(tmpSource);
        this.openSource(tmpSource);
        this.replicateReferentiel(centralSource, tmpSource);
        this.replicateObsoletesEntities(obsoleteEntities, source, tmpSource);
        this.replicateData(source, tmpSource, new String[0]);
        this.model.getSaveLocalModel().addStepForSave(AdminStep.SYNCHRONIZE);
        this.sendMessage(I18n.t((String)"observe.message.synchro.operation.needFix", (Object[])new Object[0]));
        return WizardState.NEED_FIX;
    }

    public void reportSuccess() {
        boolean needSave = false;
        DiffState.DiffStateMap diff = this.getStepModel().getDiff();
        List ids = (List)diff.get((Object)DiffState.REMOVED);
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            needSave = true;
            this.sendMessage(I18n.t((String)"observe.message.synchro.referentiel.was.removed", (Object[])new Object[]{ids.size()}));
            for (String id : ids) {
                this.sendMessage("  - " + id);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(ids = (List)diff.get((Object)DiffState.NEW)))) {
            needSave = true;
            this.sendMessage(I18n.t((String)"observe.message.synchro.referentiel.was.added", (Object[])new Object[]{ids.size()}));
            for (String id : ids) {
                this.sendMessage("  - " + id);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(ids = (List)diff.get((Object)DiffState.MODIFIED)))) {
            needSave = true;
            this.sendMessage(I18n.t((String)"observe.message.synchro.referentiel.was.modified", (Object[])new Object[]{ids.size()}));
            for (String id : ids) {
                this.sendMessage("  - " + id);
            }
        }
        if (needSave) {
            this.model.getSaveLocalModel().addStepForSave(AdminStep.SYNCHRONIZE);
            this.sendMessage(I18n.t((String)"observe.message.synchro.local.modification", (Object[])new Object[0]));
            this.sendMessage(I18n.t((String)"observe.message.synchro.no.referentiel.conflict", (Object[])new Object[0]));
        } else {
            this.sendMessage(I18n.t((String)"observe.message.synchro.ref.is.updtodate", (Object[])new Object[0]));
        }
        this.sendMessage(I18n.t((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SortedMap<TopiaEntity, List<TopiaEntityRef>> detectObsoleteEntities() throws Exception {
        DiffState.DiffStateMap diff = this.getStepModel().getDiff();
        DataSource source = this.getStepModel().getSource();
        List removedList = (List)diff.get((Object)DiffState.REMOVED);
        String[] ids = removedList.toArray(new String[removedList.size()]);
        TopiaContext tx = this.beginTransaction(source, "detectObsoleteRefs");
        try {
            SortedMap result;
            List marees = ObserveDAOHelper.getTripDAO((TopiaContext)tx).findAll();
            ObserveEntityEnum[] contracts = ObserveDAOHelper.getContracts();
            SortedMap sortedMap = result = TopiaEntityHelper.detectReferences((TopiaEntityEnum[])contracts, (String[])ids, (Collection)marees);
            return sortedMap;
        }
        finally {
            this.closeTransaction(source, tx, "detectObsoleteRefs");
        }
    }

    protected void removeUndirectObsoleteRefs() {
        SortedMap<TopiaEntity, List<TopiaEntityRef>> obsoleteRefs = this.getStepModel().getObsoleteRefs();
        Iterator<Map.Entry<TopiaEntity, List<TopiaEntityRef>>> itr = obsoleteRefs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<TopiaEntity, List<TopiaEntityRef>> entry = itr.next();
            Iterator<TopiaEntityRef> itrRef = entry.getValue().iterator();
            while (itrRef.hasNext()) {
                TopiaEntityRef ref = itrRef.next();
                TopiaEntity refInvoker = ref.getInvoker();
                if (refInvoker == null) {
                    itrRef.remove();
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("remove ref " + ref));
                    continue;
                }
                ObserveEntityEnum refConstant = ObserveEntityEnum.valueOf((TopiaEntity)refInvoker);
                if (DBHelper.DATA_ENTITIES_LIST.contains(refConstant)) continue;
                itrRef.remove();
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("remove ref " + ref));
            }
            if (!entry.getValue().isEmpty()) continue;
            itr.remove();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("remove obsolete entity (not direct referentiel) : " + entry.getKey().getTopiaId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replicateObsoletesEntities(List<TopiaEntity> obsoleteEntities, DataSource source, DataSource tmpSource) throws Exception {
        String txName = "replicateObsoletesEntities";
        TopiaContext sourceCtxt = this.beginTransaction(source, txName);
        try {
            TopiaContext tmpCtxt = this.beginTransaction(tmpSource, txName);
            try {
                for (ObserveEntityEnum constant : DBHelper.REFERENCE_ENTITIES) {
                    Class contractClass = constant.getContract();
                    ArrayList<TopiaEntity> toReplicate = new ArrayList<TopiaEntity>();
                    Iterator<TopiaEntity> itr = obsoleteEntities.iterator();
                    while (itr.hasNext()) {
                        TopiaEntity e = itr.next();
                        if (!contractClass.isAssignableFrom(e.getClass())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("obsolete to inject : " + e.getTopiaId()));
                        }
                        itr.remove();
                        toReplicate.add(e);
                        this.sendMessage(I18n.t((String)"observe.message.synchro.obsolete.data.to.duplicate", (Object[])new Object[]{e}));
                    }
                    if (toReplicate.isEmpty()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("no obsolete entity " + constant));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("inject obsolete entity " + constant + " (" + toReplicate.size() + ")"));
                    }
                    sourceCtxt.replicateEntities(tmpCtxt, toReplicate);
                    this.commitTransaction(tmpSource, tmpCtxt, txName);
                }
            }
            finally {
                this.closeTransaction(tmpSource, tmpCtxt, txName);
            }
        }
        finally {
            this.closeTransaction(source, sourceCtxt, txName);
        }
        if (!obsoleteEntities.isEmpty()) {
            throw new IllegalStateException("there is still obsolete entities to inject in synchro db : " + obsoleteEntities);
        }
    }

    public List<?> getEntityListFromSynchroDB(Class<?> type, boolean removeObsoletes) {
        List list;
        DataSource tmpSource = this.getStepModel().getTmpSource();
        try {
            ObserveEntityEnum constant = ObserveEntityEnum.valueOf(type);
            list = this.getDataService().getList(tmpSource, constant.getContract());
        }
        catch (DataSourceException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)ex);
            }
            list = new ArrayList();
        }
        if (removeObsoletes) {
            DiffState.DiffStateMap diff = this.getStepModel().getDiff();
            List removedList = (List)diff.get((Object)DiffState.REMOVED);
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                TopiaEntity e = (TopiaEntity)itr.next();
                if (!removedList.contains(e.getTopiaId())) continue;
                itr.remove();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolvObsoleteReferences(TopiaEntity obsoleteRef, List<TopiaEntityRef> refs, TopiaEntity safeRef) {
        ObsoleteRefReplaceAction action = new ObsoleteRefReplaceAction(obsoleteRef.getTopiaId(), safeRef.getTopiaId(), refs);
        SynchronizeModel stepModel = this.getStepModel();
        stepModel.getReplaceActions().add(action);
        SortedMap<TopiaEntity, List<TopiaEntityRef>> obsoleteRefs = stepModel.getObsoleteRefs();
        List globalRefs = (List)obsoleteRefs.get(obsoleteRef);
        DataSource tmpSource = stepModel.getTmpSource();
        String txName = "resolvObsoleteReferences";
        TopiaContext tx = null;
        try {
            tx = this.beginTransaction(tmpSource, txName);
            action.doAction(tx);
            this.commitTransaction(tmpSource, tx, txName);
            globalRefs.removeAll(refs);
            this.ui.firePropertyChange("refsResolved", null, obsoleteRef);
            if (globalRefs.isEmpty()) {
                obsoleteRefs.remove(obsoleteRef);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("remove resolved obsolete property from temp db : " + obsoleteRef.getTopiaId()));
                }
                obsoleteRef = tx.findByTopiaId(obsoleteRef.getTopiaId());
                this.getDAO(tx, obsoleteRef).delete(obsoleteRef);
                this.ui.firePropertyChange("obsoleteResolved", null, obsoleteRef);
            }
            this.commitTransaction(tmpSource, tx, txName);
            if (obsoleteRefs.isEmpty()) {
                this.sendMessage(I18n.t((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
                this.model.setStepState(WizardState.SUCCESSED);
            }
        }
        catch (Exception e) {
            this.model.setStepState(this.onError(e));
        }
        finally {
            try {
                if (tx != null) {
                    this.closeTransaction(tmpSource, tx, txName);
                }
            }
            catch (DataSourceException e) {
                this.model.setStepState(this.onError((Exception)((Object)e)));
            }
        }
    }

    public class ObsoleteRefReplaceAction {
        String obsoleteId;
        String safeId;
        TopiaEntityRef[] refs;

        ObsoleteRefReplaceAction(String obsoleteId, String safeId, List<TopiaEntityRef> refs) {
            this.obsoleteId = obsoleteId;
            this.refs = refs.toArray(new TopiaEntityRef[refs.size()]);
            this.safeId = safeId;
        }

        public void doAction(TopiaContext tx) throws TopiaException {
            if (log.isInfoEnabled()) {
                log.info((Object)("load obsolete object " + this.obsoleteId));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("load safe     object " + this.safeId));
            }
            TopiaEntity safeRef = tx.findByTopiaId(this.safeId);
            for (TopiaEntityRef ref : this.refs) {
                TopiaEntity invoker = ref.getInvoker();
                if (invoker == null) {
                    throw new NullPointerException("can not have a null invoker in " + ref);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("load invoker object " + invoker.getTopiaId()));
                }
                invoker = tx.findByTopiaId(invoker.getTopiaId());
                String path = ref.getInvokerProperty();
                JXPathContext jxcontext = JXPathContext.newContext((Object)invoker);
                TopiaEntity oldValue = (TopiaEntity)jxcontext.getValue(path);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property to switch " + path + " old        : " + oldValue));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("change path : " + path));
                    log.info((Object)("old value   : " + oldValue.getTopiaId()));
                }
                jxcontext.setValue(path, (Object)safeRef);
                TopiaEntity newValue = (TopiaEntity)jxcontext.getValue(path);
                if (log.isInfoEnabled()) {
                    log.info((Object)("new value    : " + newValue.getTopiaId()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property to switch " + path + " new        : " + safeRef));
                    log.debug((Object)("property to switch " + path + " new Check  : " + newValue));
                }
                TopiaDAO dao = SynchronizeUIHandler.this.getDAO(tx, invoker);
                dao.update(invoker);
            }
        }

        public String getObsoleteId() {
            return this.obsoleteId;
        }
    }
}

