/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.Trip;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.seine.RoutesUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public class RoutesUIHandler
extends ContentListUIHandler<Trip, Route> {
    private static Log log = LogFactory.getLog(RoutesUIHandler.class);

    public RoutesUIHandler(RoutesUI ui) {
        super(ui, DataContextType.Trip, DataContextType.Route);
    }

    @Override
    protected TopiaEntityBinder<Trip> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Trip.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Trip.class, new String[]{"open", "route"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"route"});
            r = binderService.registerTopiaBinder(Trip.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openTripId = dataContext.getOpenTripId();
        if (openTripId == null) {
            this.addInfoMessage(I18n.n((String)"observe.message.no.active.maree.found", (Object[])new Object[0]));
            return ContentMode.READ;
        }
        boolean openRoute = dataContext.isOpenRoute();
        if (dataContext.isSelectedOpen(Trip.class)) {
            if (openRoute) {
                this.addInfoMessage(I18n.n((String)"observe.message.active.route.found", (Object[])new Object[0]));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n((String)"observe.message.no.active.route.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (openRoute) {
            this.addInfoMessage(I18n.n((String)"observe.message.active.route.found.for.other.maree", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.n((String)"observe.message.no.active.route.found.for.other.maree", (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    protected List<Route> getChilds(Trip bean) throws DataSourceException {
        List list = bean.getRoute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + (list == null ? 0 : list.size()) + " routes."));
        }
        return list;
    }
}

