/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.seine.Activity;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.seine.ActivitysUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public class ActivitysUIHandler
extends ContentListUIHandler<Route, Activity> {
    private static Log log = LogFactory.getLog(ActivitysUIHandler.class);

    public ActivitysUIHandler(ActivitysUI ui) {
        super(ui, DataContextType.Route, DataContextType.Activity);
    }

    @Override
    protected TopiaEntityBinder<Route> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Route.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Route.class, new String[]{"open", "activity"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"activity"});
            BinderModelBuilder builder2 = binderService.newBinderBuilder(Activity.class, new String[]{"vesselActivity", "time", "open"});
            TopiaEntityBinder binder = binderService.registerTopiaBinder(Activity.class, builder2, binderName);
            builder.addBinder("activity", (Binder)binder);
            r = binderService.registerTopiaBinder(Route.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openRouteId = dataContext.getOpenRouteId();
        if (openRouteId == null) {
            this.addInfoMessage(I18n.n((String)"observe.message.no.active.route.found", (Object[])new Object[0]));
            return ContentMode.READ;
        }
        boolean openActivity = dataContext.isOpenActivity();
        if (dataContext.isSelectedOpen(Route.class)) {
            if (openActivity) {
                this.addInfoMessage(I18n.n((String)"observe.message.active.activity.found", (Object[])new Object[0]));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n((String)"observe.message.no.active.activity.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (openActivity) {
            this.addInfoMessage(I18n.n((String)"observe.message.active.activity.found.for.other.route", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.n((String)"observe.message.no.active.activity.found.for.other.route", (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    protected List<Activity> getChilds(Route bean) {
        List list = bean.getActivity();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + (list == null ? 0 : list.size()) + " activitys."));
        }
        return list;
    }
}

