/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeNode;
import org.nuiton.i18n.I18n;

public class GoUpUIAction
extends AbstractUIAction {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_NAME = "goUp";

    public GoUpUIAction(ObserveMainUI mainUI) {
        super(mainUI, ACTION_NAME, I18n.n((String)"observe.action.goUp", (Object[])new Object[0]), I18n.n((String)"observe.action.goUp.tip", (Object[])new Object[0]), "go-up");
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent c = (JComponent)e.getSource();
                JPopupMenu p = (JPopupMenu)c.getClientProperty("popup");
                if (p == null) {
                    throw new IllegalStateException("could not find client property popup on component" + c);
                }
                p.show(c, 2, c.getHeight());
            }
        });
    }

    @Override
    public void initAction(ContentUI<?> ui, AbstractButton editor) {
        super.initAction(ui, editor);
        editor.putClientProperty("popup", this.getMainUI().getScopeUpPopup());
    }

    @Override
    public void updateAction(ContentUI<?> ui, AbstractButton editor) {
        super.updateAction(ui, editor);
        ObserveTreeHelper treeHelper = this.getMainUI().getTreeHelper();
        DefaultTreeModel navigationModel = (DefaultTreeModel)treeHelper.getModel();
        AbstractObserveTreeCellRenderer render = treeHelper.getTreeCellRenderer();
        JPopupMenu scopePopup = this.getMainUI().getScopeUpPopup();
        Action action = this.getMainUI().getRootPane().getActionMap().get("selectNode");
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        NavTreeNode root = node.getRoot();
        scopePopup.removeAll();
        scopePopup.setLayout(new GridLayout(0, 1));
        while (!root.equals(node.getParent())) {
            node = (ObserveNode)node.getParent();
            Color color = render.getNavigationTextColor(node);
            Icon icon = render.getNavigationIcon(node, "-16");
            String text = render.getNodeText((NavNode)node);
            JMenuItem mi = new JMenuItem();
            mi.setAction(action);
            mi.setText(text.trim());
            mi.setIcon(icon);
            mi.setForeground(color);
            mi.setBackground(Color.WHITE);
            mi.putClientProperty("node", (Object)node);
            mi.putClientProperty("ui", ui);
            mi.setAction(action);
            scopePopup.add(mi);
        }
        scopePopup.revalidate();
        int nbNodes = scopePopup.getComponentCount();
        editor.setEnabled(nbNodes > 0);
    }
}

