/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUILauncher;
import fr.ird.observe.ui.storage.ObstunaAdminAction;
import fr.ird.observe.ui.storage.RemoteUILauncher;
import java.awt.Component;
import java.awt.Frame;
import java.io.Console;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import javax.help.JHelp;
import javax.swing.JDialog;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.application.ActionWorker;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.i18n.I18n;

public class ObserveCLAction {
    private static Log log = LogFactory.getLog(ObserveCLAction.class);
    protected ObserveConfig config;

    public ObserveCLAction() {
    }

    public ObserveCLAction(ObserveConfig config) {
        this.config = config;
    }

    public void useJMX() throws Exception {
        ObserveServiceHelper.setUseJMX((boolean)true);
    }

    public void disableMainUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.getConfig().setDisplayMainUI(false);
    }

    public void help() {
        this.disableMainUI();
        StringBuilder out = new StringBuilder();
        boolean isAdmin = ObserveRunner.isAdmin();
        out.append(I18n.t((String)"observe.message.help.usage", (Object[])new Object[]{this.getConfig().getVersion()}));
        out.append('\n');
        out.append("Options (set with --option <key> <value>:");
        out.append('\n');
        for (ObserveConfigOption observeConfigOption : ObserveConfigOption.values()) {
            if (observeConfigOption.isAdmin() && !isAdmin) continue;
            out.append("\t");
            out.append(observeConfigOption.key);
            out.append("(");
            out.append(observeConfigOption.defaultValue);
            out.append(") :");
            out.append(I18n.t((String)observeConfigOption.description, (Object[])new Object[0]));
            out.append('\n');
        }
        out.append("Actions:");
        out.append('\n');
        for (Enum enum_ : ActionDefinition.values()) {
            if (((ActionDefinition)enum_).isAdmin() && !isAdmin) continue;
            out.append("\t");
            out.append(Arrays.toString(((ActionDefinition)enum_).aliases));
            out.append("(");
            out.append(((ActionDefinition)enum_).action);
            out.append("):");
            out.append(I18n.t((String)((ActionDefinition)enum_).description, (Object[])new Object[0]));
            out.append('\n');
        }
        Console cons = System.console();
        if (cons != null) {
            cons.printf(out.toString(), new Object[0]);
        }
    }

    public void helpUI() throws InterruptedException {
        this.disableMainUI();
        final String title = I18n.t((String)"observe.help.top.title", (Object[])new Object[0]);
        Runnable target = new Runnable(){

            @Override
            public void run() {
                Locale locale = ObserveCLAction.this.getConfig().getLocale();
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
                JAXXHelpBroker helpBroker = new JAXXHelpBroker(locale, "observe", "help", "top", (JAXXHelpUIHandler)handler);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"no mainUI, open in autonome frame");
                }
                JHelp ui = new JHelp(helpBroker.getHelpset());
                JDialog frame = new JDialog((Frame)null, true);
                frame.setTitle(title);
                frame.setSize(1024, 800);
                frame.add((Component)ui);
                frame.setVisible(true);
            }
        };
        this.launchAction(title, target);
    }

    public void configure() throws InterruptedException {
        this.disableMainUI();
        ObserveContext context = ObserveContext.get();
        ObserveMainUIHandler handler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
        Runnable runnable = this.createRunnable(handler, "showConfig", new Object[]{context});
        this.launchAction(I18n.t((String)"observe.action.showConfig.title", (Object[])new Object[0]), runnable);
    }

    public void launchAdminUI(String operationName) throws InterruptedException {
        this.checkIsAdmin();
        this.disableMainUI();
        EnumSet<AdminStep> operations = AdminStep.getOperations();
        AdminStep operation = AdminStep.valueOfIgnoreCase(operationName);
        if (operation == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)(operationName + " is not a known admin operation."));
                log.error((Object)("Use one of these ones : " + operations));
            }
            return;
        }
        if (!operation.isOperation()) {
            if (log.isErrorEnabled()) {
                log.error((Object)((Object)((Object)operation) + " is not a admin operation(just a step in wizard)."));
                log.error((Object)("Use one of these ones : " + operations));
            }
            return;
        }
        ObserveContext context = ObserveContext.get();
        this.registerJavaHelp(context);
        AdminUILauncher launcher = AdminUILauncher.newLauncher((JAXXContext)context, operation);
        Runnable runnable = this.createRunnable((Object)launcher, "start", new Object[0]);
        this.launchAction(I18n.t((String)operation.getTitle(), (Object[])new Object[0]), runnable);
    }

    public void launchObstunaAdminUI(String operationName) throws InterruptedException {
        this.checkIsAdmin();
        this.disableMainUI();
        EnumSet<ObstunaAdminAction> operations = EnumSet.allOf(ObstunaAdminAction.class);
        ObstunaAdminAction operation = ObstunaAdminAction.valueOfIgnoreCase(operationName);
        if (operation == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)(operationName + " is not a known obstuna admin operation."));
                log.error((Object)("Use one of these ones : " + operations));
            }
            return;
        }
        ObserveContext context = ObserveContext.get();
        this.registerJavaHelp(context);
        this.getConfig().setOption("auto.migrate", "false");
        if (operation == ObstunaAdminAction.UPDATE || operation == ObstunaAdminAction.CREATE) {
            this.getConfig().setOption(ObserveConfigOption.OBSTUNA_CAN_MIGRATE, true);
        }
        RemoteUILauncher launcher = operation.newLauncher((JAXXContext)context, null);
        Runnable runnable = this.createRunnable((Object)launcher, "start", new Object[0]);
        this.launchAction(I18n.t((String)launcher.getTitle(), (Object[])new Object[0]), runnable);
    }

    public void launchH2ServerMode() throws InterruptedException {
        this.checkIsAdmin();
        if (!this.config.isLocalStorageExist()) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Local database does not exist.");
            }
        } else {
            ObserveContext.get().setContextValue(true, ActionDefinition.H2_SERVER_MODE.name());
        }
    }

    protected ObserveConfig getConfig() {
        if (this.config == null) {
            this.config = ObserveContext.get().getConfig();
        }
        return this.config;
    }

    protected Runnable createRunnable(Object invoker, String method, Object ... args) {
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        Runnable runnable = executor.createRunnable(invoker, method, args);
        return runnable;
    }

    protected void launchAction(String title, Runnable target) throws InterruptedException {
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        CommandLineActionWorker action = new CommandLineActionWorker(title, target);
        executor.addAction(action);
        ObserveContext context = ObserveContext.get();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lock main context " + (Object)((Object)context)));
        }
        context.lock();
    }

    protected void registerJavaHelp(ObserveContext context) {
        ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
        Locale locale = this.getConfig().getLocale();
        JAXXHelpBroker broker = new JAXXHelpBroker(locale, "observe", "help", "top", (JAXXHelpUIHandler)uiHandler);
        context.setContextValue(broker);
    }

    protected void checkIsAdmin() {
        if (!ObserveRunner.isAdmin()) {
            throw new IllegalStateException("Your are not allowed to execute admin operation with " + ObserveRunner.getRunner().getRunnerName());
        }
    }

    public class CommandLineActionWorker
    extends ActionWorker<Void, String> {
        public CommandLineActionWorker(String actionLabel, Runnable target) {
            super(actionLabel);
            this.setTarget(target);
        }

        public ObserveCLAction getAction() {
            return ObserveCLAction.this;
        }
    }

    public static enum ActionDefinition implements ConfigActionDef
    {
        HELP(false, I18n.t((String)"observe.action.commandline.help", (Object[])new Object[0]), ObserveCLAction.class.getName() + "#help", "-h", "--help"),
        HELP_UI(false, I18n.t((String)"observe.action.commandline.help.ui", (Object[])new Object[0]), ObserveCLAction.class.getName() + "#helpUI", "--help-ui"),
        NO_MAIN_UI(false, I18n.t((String)"observe.action.commandline.disable.main.ui", (Object[])new Object[0]), ObserveCLAction.class.getName() + "#disableMainUI", "-n", "--no-main"),
        CONFIGURE_UI(false, I18n.t((String)"observe.action.commandline.configure.ui", (Object[])new Object[0]), ObserveCLAction.class.getName() + "#configure", "--configure"),
        ADMIN_UI(true, I18n.t((String)"observe.action.commandline.launch.admin.ui", (Object[])new Object[0]), ObserveCLAction.class.getName() + "#launchAdminUI", "-a", "--admin"),
        OBSTUNA_ADMIN_UI(true, I18n.t((String)"observe.action.commandline.launch.obstuna.admin.ui", (Object[])new Object[0]), ObserveCLAction.class.getName() + "#launchObstunaAdminUI", "--obstuna-admin"),
        H2_SERVER_MODE(true, I18n.t((String)"observe.action.commandline.launch.h2.server.mode", (Object[])new Object[0]), ObserveCLAction.class.getName() + "#launchH2ServerMode", "--h2-server"),
        USE_JMX(true, I18n.t((String)"observe.action.commandline.use.jmx", (Object[])new Object[0]), ObserveCLAction.class.getName() + "#useJMX", "--jmx");

        public String description;
        public String action;
        public String[] aliases;
        public boolean admin;

        private ActionDefinition(boolean admin, String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
            this.admin = admin;
        }

        public String getDescription() {
            return this.description;
        }

        public String getAction() {
            return this.action;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public boolean isAdmin() {
            return this.admin;
        }
    }
}

