/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ird.observe.ui.util.table.EditableList;
import fr.ird.observe.ui.util.table.EditableTableModelSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public abstract class EditableTableWithCacheTableModelSupport<E extends TopiaEntity>
extends EditableTableModelSupport<E> {
    private static final long serialVersionUID = 1L;
    protected final Map<Integer, EditableList<E>> cacheByRow;
    protected final TopiaEntityBinder<E> loader;

    protected EditableTableWithCacheTableModelSupport(TopiaEntityBinder<E> loader) {
        super(true);
        this.loader = loader;
        this.cacheByRow = new TreeMap<Integer, EditableList<E>>();
    }

    public TopiaEntityBinder<E> getLoader() {
        return this.loader;
    }

    public List<E> getCacheForRow(int rowIndex) {
        EditableList<E> measures = this.cacheByRow.get(rowIndex);
        return measures == null ? null : measures.getData();
    }

    public void initCacheForRow(int editingRow, List<E> data) {
        EditableList<E> editableList = this.cacheByRow.get(editingRow);
        Preconditions.checkState((editableList == null ? 1 : 0) != 0);
        editableList = new EditableList();
        List<E> original = this.copyList(data);
        editableList.setOriginal(original);
        editableList.setData(data);
        this.cacheByRow.put(editingRow, editableList);
    }

    public void storeInCacheForRow(int editingRow) {
        List measures = this.getData();
        EditableList editableList = this.cacheByRow.get(editingRow);
        Preconditions.checkState((editableList != null ? 1 : 0) != 0);
        editableList.setData(measures);
    }

    public void removeCacheForRow(int rowToDelete) {
        this.cacheByRow.remove(rowToDelete);
        ArrayList rows = Lists.newArrayList(this.getCacheRowsChanged());
        Collections.sort(rows);
        for (Integer row : rows) {
            if (row <= rowToDelete) continue;
            EditableList<E> remove = this.cacheByRow.remove(row);
            this.cacheByRow.put(row - 1, remove);
        }
    }

    public void resetCacheForRow(int rowtoReset) {
        EditableList<E> editableList = this.cacheByRow.get(rowtoReset);
        Preconditions.checkState((editableList != null ? 1 : 0) != 0);
        editableList.reset();
        List<E> newData = this.copyList(editableList.getOriginal());
        editableList.setData(newData);
        this.setData(newData);
        this.validate();
    }

    public Set<Integer> getCacheRowsChanged() {
        Set<Integer> rows = this.cacheByRow.keySet();
        return rows;
    }

    @Override
    public void clear() {
        this.cacheByRow.clear();
        super.clear();
    }

    protected List<E> copyList(List<E> data) {
        ArrayList<TopiaEntity> copy = new ArrayList<TopiaEntity>(data.size());
        for (TopiaEntity measure : data) {
            TopiaEntity originalMeasure = (TopiaEntity)this.createNewRow();
            this.loader.load(measure, originalMeasure, true, new String[0]);
            copy.add(originalMeasure);
        }
        return copy;
    }
}

