/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.consolidate;

import fr.ird.observe.ConsolidateDataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.SendMessageAble;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIModel;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.consolidate.ConsolidateModel;
import fr.ird.observe.ui.admin.consolidate.ConsolidateUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class ConsolidateUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ConsolidateUIHandler.class);

    public ConsolidateUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public ConsolidateModel getStepModel() {
        return this.model.getConsolidateModel();
    }

    public void initTabUI(AdminUI ui, ConsolidateUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getStartButton().setText(I18n.t((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n.t((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        final SelectDataUI selectTabUI = (SelectDataUI)ui.getStepUI(AdminStep.SELECT_DATA);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AdminUIModel model = (AdminUIModel)((Object)evt.getSource());
                if (!model.containsStep((WizardStep)selectTabUI.getStep())) {
                    return;
                }
                DataSelectionModel value = (DataSelectionModel)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("selection model changed to " + value));
                }
                ConsolidateUIHandler.this.updateSelectionModel(selectTabUI);
            }
        };
        tabUI.getModel().addPropertyChangeListener("selectionModelChanged", listener);
    }

    public void startAction() {
        this.addAdminWorker(((ConsolidateUI)this.ui).getStartButton().getToolTipText(), new Callable<WizardState>(){

            @Override
            public WizardState call() throws Exception {
                return ConsolidateUIHandler.this.doAction();
            }
        });
    }

    public WizardState doAction() throws Exception {
        WizardState init;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        if ((init = this.initDB()) != null) {
            return init;
        }
        Set mareeIds = this.model.getSelectionDataModel().getSelectedData();
        ArrayList<TripSeine> toUpdate = new ArrayList<TripSeine>(mareeIds.size());
        ConsolidateDataService service = ObserveServiceHelper.getConsolidateDataService();
        DataSource source = this.getStepModel().getSource();
        String txName = "consolidateData";
        TopiaContext tx = source.beginTransaction(txName);
        try {
            boolean needCommit;
            TopiaDAO dao = source.getDAO(tx, TripSeine.class);
            for (String mareeId : mareeIds) {
                TripSeine maree = (TripSeine)tx.findByTopiaId(mareeId);
                boolean needUpdate = service.consolidateTrip((SendMessageAble)this, tx, maree);
                if (!needUpdate) continue;
                dao.update((TopiaEntity)maree);
                toUpdate.add(maree);
            }
            boolean bl = needCommit = !toUpdate.isEmpty();
            if (needCommit) {
                this.sendMessage(I18n.t((String)"observe.message.consolidate.save.changes", (Object[])new Object[]{toUpdate.size()}));
                source.commitTransaction(tx, txName);
            }
        }
        catch (Exception eee) {
            block12: {
                try {
                    source.rollbackTransaction(tx, txName);
                }
                catch (DataSourceException e1) {
                    if (!log.isErrorEnabled()) break block12;
                    log.error((Object)e1);
                }
            }
            throw eee;
        }
        finally {
            service.clear();
            source.closeTransaction(tx, txName);
        }
        this.sendMessage(I18n.t((String)"observe.message.consolidate.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    protected WizardState initDB() throws Exception {
        DataSource source = this.model.getSafeLocalSource(false);
        this.getStepModel().setSource(source);
        this.openSource(source);
        DecoratorService dProvider = this.getDecoratorService();
        ConsolidateModel stepModel = this.getStepModel();
        Decorator p = dProvider.getDecoratorByType(Program.class);
        Decorator m = dProvider.getDecoratorByType(TripSeine.class);
        Decorator a = dProvider.getDecoratorByType(ActivitySeine.class);
        Decorator c = dProvider.getDecoratorByType(SetSeine.class);
        stepModel.setProgramDecorator((Decorator<Program>)p);
        stepModel.setTripDecorator((Decorator<TripSeine>)m);
        stepModel.setActivityDecorator((Decorator<ActivitySeine>)a);
        stepModel.setSetDecorator((Decorator<SetSeine>)c);
        return null;
    }
}

