/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.entities.longline.Basket;
import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.entities.longline.Section;
import fr.ird.observe.entities.longline.Sections;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUI;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUIModel;
import fr.ird.observe.ui.util.ObserveSwingValidatorMessageTableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorEvent;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorListener;

public class LonglineDetailCompositionUIValidationHelper {
    private static final Log log = LogFactory.getLog(LonglineDetailCompositionUIValidationHelper.class);
    private final LonglineDetailCompositionUIModel model;
    private final ObserveSwingValidatorMessageTableModel errorTableModel;
    private boolean objectValueAdjusting;
    private final LonglineDetailCompositionValidatorService validatorService;
    private final Set<SwingValidator> validators;

    public LonglineDetailCompositionUIValidationHelper(LonglineDetailCompositionUI ui, DecoratorService decoratorService) {
        this.model = ui.getModel();
        this.errorTableModel = (ObserveSwingValidatorMessageTableModel)ui.getErrorTableModel();
        SwingValidator<Section> sectionValidator = ui.getSectionValidator();
        SwingValidator<Basket> basketValidator = ui.getBasketValidator();
        SwingValidator<Branchline> branchlineValidator = ui.getBranchlineValidator();
        this.validators = ImmutableSet.builder().add((Object[])new SwingValidator[]{sectionValidator, basketValidator, branchlineValidator}).build();
        ImmutableMap validatorEditor = ImmutableMap.builder().put(sectionValidator, (Object)ui.getSectionsPane()).put(basketValidator, (Object)ui.getBasketsPane()).put(branchlineValidator, (Object)ui.getBranchlinesPane()).build();
        this.validatorService = new LonglineDetailCompositionValidatorService(sectionValidator, basketValidator, branchlineValidator, (Map<SwingValidator, JComponent>)validatorEditor, decoratorService);
    }

    public void whenSectionChanged() {
        if (!this.objectValueAdjusting) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Rebuild messages, section model changes.");
            }
            List notEmptyData = this.model.getSectionsTableModel().getNotEmptyData();
            List<SwingValidatorMessage> messages = this.validatorService.validateSections(notEmptyData);
            this.removeOldMessages();
            this.errorTableModel.addMessages(messages);
            this.model.setCompositionTabValid(messages.isEmpty());
        }
    }

    public void whenBasketChanged() {
        if (!this.objectValueAdjusting) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Rebuild messages, basket model changes.");
            }
            List notEmptyData = this.model.getSectionsTableModel().getNotEmptyData();
            List<SwingValidatorMessage> messages = this.validatorService.validateSections(notEmptyData);
            this.removeOldMessages();
            this.errorTableModel.addMessages(messages);
            this.model.setCompositionTabValid(messages.isEmpty());
        }
    }

    public void whenBranchlineChanged() {
        if (!this.objectValueAdjusting) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Rebuild messages, branchline model changes.");
            }
            List notEmptyData = this.model.getSectionsTableModel().getNotEmptyData();
            List<SwingValidatorMessage> messages = this.validatorService.validateSections(notEmptyData);
            this.removeOldMessages();
            this.errorTableModel.addMessages(messages);
            this.model.setCompositionTabValid(messages.isEmpty());
        }
    }

    public void removeOldMessages() {
        this.errorTableModel.removeMessages(new Predicate<SwingValidatorMessage>(){

            public boolean apply(SwingValidatorMessage input) {
                SimpleBeanValidator validator = input.getValidator();
                boolean remove = LonglineDetailCompositionUIValidationHelper.this.validators.contains(validator);
                return remove;
            }
        });
    }

    public void setObjectValueAdjusting(boolean objectValueAdjusting) {
        this.objectValueAdjusting = objectValueAdjusting;
    }

    private static class LonglineDetailCompositionValidationContext
    implements SimpleBeanValidatorListener {
        Section section;
        Basket basket;
        Branchline branchline;
        String contextLabel;
        final List<SwingValidatorMessage> messages;
        final DecoratorService decoratorService;
        private final Map<SwingValidator, JComponent> validatorEditors;

        private LonglineDetailCompositionValidationContext(DecoratorService decoratorService, Map<SwingValidator, JComponent> validatorEditors) {
            this.decoratorService = decoratorService;
            this.validatorEditors = validatorEditors;
            this.messages = new ArrayList<SwingValidatorMessage>();
        }

        public List<SwingValidatorMessage> getMessages() {
            return this.messages;
        }

        public void setSection(Section section) {
            this.section = section;
            this.basket = null;
            this.branchline = null;
            this.updateContextLabel();
        }

        public void setBasket(Basket basket) {
            this.basket = basket;
            this.branchline = null;
            this.updateContextLabel();
        }

        public void setBranchline(Branchline branchline) {
            this.branchline = branchline;
            this.updateContextLabel();
        }

        protected void updateContextLabel() {
            this.contextLabel = "";
            if (this.section != null) {
                this.contextLabel = this.contextLabel + "S " + this.section.getSettingIdentifier();
                if (this.basket != null) {
                    this.contextLabel = this.contextLabel + " Ba " + this.basket.getSettingIdentifier();
                    if (this.branchline != null) {
                        this.contextLabel = this.contextLabel + " Br " + this.branchline.getSettingIdentifier();
                    }
                }
            }
        }

        public void onFieldChanged(SimpleBeanValidatorEvent event) {
            String[] messagesToAdd = event.getMessagesToAdd();
            if (messagesToAdd != null) {
                String field = event.getField();
                NuitonValidatorScope scope = event.getScope();
                SwingValidator validator = (SwingValidator)event.getSource();
                for (String messageToAdd : messagesToAdd) {
                    this.addMessage(validator, scope, field, messageToAdd);
                }
            }
        }

        public void addMessage(SwingValidator validator, NuitonValidatorScope scope, String field, String messageToAdd) {
            String propertyLabel = this.decoratorService.getPropertyLabel(field);
            SwingValidatorMessage message = new SwingValidatorMessage(validator, this.contextLabel + " - " + I18n.t((String)propertyLabel, (Object[])new Object[0]), messageToAdd, scope, this.validatorEditors.get(validator));
            this.messages.add(message);
        }
    }

    public static class LonglineDetailCompositionValidatorService {
        private final SwingValidator<Section> sectionValidator;
        private final SwingValidator<Basket> basketValidator;
        private final SwingValidator<Branchline> branchlineValidator;
        private final DecoratorService decoratorService;
        private final Map<SwingValidator, JComponent> validatorEditors;

        public LonglineDetailCompositionValidatorService(SwingValidator<Section> sectionValidator, SwingValidator<Basket> basketValidator, SwingValidator<Branchline> branchlineValidator, Map<SwingValidator, JComponent> validatorEditors, DecoratorService decoratorService) {
            this.sectionValidator = sectionValidator;
            this.basketValidator = basketValidator;
            this.branchlineValidator = branchlineValidator;
            this.validatorEditors = validatorEditors;
            this.decoratorService = decoratorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SwingValidatorMessage> validateSections(List<? extends Section> sections) {
            LonglineDetailCompositionValidationContext validationContext = new LonglineDetailCompositionValidationContext(this.decoratorService, this.validatorEditors);
            this.addListener(validationContext);
            try {
                Section previousSection = null;
                for (Section section : sections) {
                    if (previousSection != null) {
                        Float basketFloatline1Length;
                        Basket lastBasket = Sections.getLastBasket(previousSection);
                        Basket firstBasket = Sections.getFirstBasket((Section)section);
                        Float previousBasketFloatline2Length = lastBasket == null ? null : lastBasket.getFloatline2Length();
                        Float f = basketFloatline1Length = firstBasket == null ? null : firstBasket.getFloatline1Length();
                        if (previousBasketFloatline2Length != null && basketFloatline1Length != null && Math.abs(previousBasketFloatline2Length.floatValue() - basketFloatline1Length.floatValue()) > 0.001f) {
                            validationContext.addMessage(this.sectionValidator, NuitonValidatorScope.ERROR, "floatline2Length", I18n.t((String)"observe.section.invalid.nextFloatline1Length", (Object[])new Object[]{previousBasketFloatline2Length, basketFloatline1Length}));
                        }
                    }
                    this.validateSection(validationContext, section);
                    previousSection = section;
                }
            }
            finally {
                this.removeListener(validationContext);
            }
            return validationContext.getMessages();
        }

        protected void validateSection(LonglineDetailCompositionValidationContext validationContext, Section section) {
            validationContext.setSection(section);
            validationContext.setBasket(null);
            validationContext.setBranchline(null);
            this.sectionValidator.setBean(null);
            this.sectionValidator.setBean((Object)section);
            if (!section.isBasketEmpty()) {
                Basket previousBasket = null;
                for (Basket basket : section.getBasket()) {
                    if (previousBasket != null) {
                        Float previousBasketFloatline2Length = previousBasket.getFloatline2Length();
                        Float basketFloatline1Length = basket.getFloatline1Length();
                        if (previousBasketFloatline2Length != null && basketFloatline1Length != null && Math.abs(previousBasketFloatline2Length.floatValue() - basketFloatline1Length.floatValue()) > 0.001f) {
                            validationContext.addMessage(this.basketValidator, NuitonValidatorScope.ERROR, "floatline2Length", I18n.t((String)"observe.basket.invalid.nextFloatline1Length", (Object[])new Object[]{previousBasketFloatline2Length, basketFloatline1Length}));
                        }
                    }
                    this.validateBasket(validationContext, basket);
                    previousBasket = basket;
                }
            }
        }

        protected void validateBasket(LonglineDetailCompositionValidationContext validationContext, Basket basket) {
            validationContext.setBranchline(null);
            validationContext.setBasket(basket);
            this.basketValidator.setBean(null);
            this.basketValidator.setBean((Object)basket);
            if (!basket.isBranchlineEmpty()) {
                for (Branchline branchline : basket.getBranchline()) {
                    this.validateBranchline(validationContext, branchline);
                }
            }
            validationContext.setBranchline(null);
        }

        protected void validateBranchline(LonglineDetailCompositionValidationContext validationContext, Branchline branchline) {
            validationContext.setBranchline(branchline);
            this.branchlineValidator.setBean(null);
            this.branchlineValidator.setBean((Object)branchline);
        }

        protected void addListener(LonglineDetailCompositionValidationContext validationContext) {
            this.sectionValidator.addSimpleBeanValidatorListener((SimpleBeanValidatorListener)validationContext);
            this.basketValidator.addSimpleBeanValidatorListener((SimpleBeanValidatorListener)validationContext);
            this.branchlineValidator.addSimpleBeanValidatorListener((SimpleBeanValidatorListener)validationContext);
        }

        protected void removeListener(LonglineDetailCompositionValidationContext validationContext) {
            this.sectionValidator.removeSimpleBeanValidatorListener((SimpleBeanValidatorListener)validationContext);
            this.basketValidator.removeSimpleBeanValidatorListener((SimpleBeanValidatorListener)validationContext);
            this.branchlineValidator.removeSimpleBeanValidatorListener((SimpleBeanValidatorListener)validationContext);
        }
    }
}

