/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.entities.longline.LonglineCompositionEntity;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUIModel;
import fr.ird.observe.ui.util.table.EditableTableModelSupport;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class LonglineCompositionTableModelSupport<E extends TopiaEntity & LonglineCompositionEntity>
extends EditableTableModelSupport<E> {
    private static final long serialVersionUID = 1L;
    private final LonglineDetailCompositionUIModel model;

    public LonglineCompositionTableModelSupport(LonglineDetailCompositionUIModel model) {
        super(false);
        this.model = model;
    }

    @Override
    protected final boolean isRowValid(E valid) {
        return true;
    }

    @Override
    public final boolean isRowNotEmpty(E valid) {
        return true;
    }

    public void rearrangeIds(boolean fire) {
        this.rearrangeIds(this.data);
        if (fire && !this.isEmpty()) {
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }
    }

    public void rearrangeIds(List<E> data) {
        boolean generateHaulingIds = this.isGenerateHaulingIds();
        boolean haulingdirectionSameAsSettings = this.model.isHaulingdirectionSameAsSettings();
        int rowCount = this.getRowCount();
        int index = 1;
        for (TopiaEntity e : data) {
            ((LonglineCompositionEntity)e).setSettingIdentifier(Integer.valueOf(index));
            if (generateHaulingIds) {
                int haulingId = haulingdirectionSameAsSettings ? index : rowCount - index + 1;
                ((LonglineCompositionEntity)e).setHaulingIdentifier(Integer.valueOf(haulingId));
            }
            ++index;
        }
    }

    @Override
    public void addNewRow() {
        super.addNewRow();
        this.validate();
        this.setModified(true);
    }

    @Override
    public void insertAfterSelectedRow() {
        super.insertAfterSelectedRow();
        this.validate();
        this.setModified(true);
    }

    @Override
    public void insertBeforeSelectedRow() {
        super.insertBeforeSelectedRow();
        this.validate();
        this.setModified(true);
    }

    @Override
    public void removeData(int selectedRow) {
        super.removeData(selectedRow);
        this.validate();
        this.setModified(true);
    }

    protected boolean isGenerateHaulingIds() {
        return this.model.isGenerateHaulingIds();
    }

    protected boolean isCanGenerate() {
        return this.model.isCanGenerate();
    }

    @Override
    public void fireTableDataChanged() {
        this.rearrangeIds(false);
        super.fireTableDataChanged();
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        super.fireTableRowsDeleted(firstRow, lastRow);
        this.rearrangeIds(true);
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        super.fireTableRowsInserted(firstRow, lastRow);
        this.rearrangeIds(true);
    }

    @Override
    public void removeSelectedRow() {
        super.removeSelectedRow();
        this.validate();
        this.setModified(true);
    }

    @Override
    public void setData(List<E> data) {
        super.setData(data);
        this.validate();
    }
}

