/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUICallback;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ReloadDefaultConfigurationAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ReloadDefaultConfigurationAction.class);
    private final ObserveMainUI ui;

    public ReloadDefaultConfigurationAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.reloadDefaultConfiguration", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"application-reload"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.reloadDefaultConfiguration.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 82);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canContinue;
        if (log.isInfoEnabled()) {
            log.info((Object)"ObServe reloading default configuration...");
        }
        if (canContinue = ObserveContext.get().closeSelectedContentUI(this.ui)) {
            block5: {
                ObserveConfig config = this.ui.getConfig();
                File directory = config.getResourcesDirectory();
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"observe.message.delete.directory", (Object[])new Object[]{directory}));
                }
                try {
                    FileUtils.deleteDirectory((File)directory);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)("Could not delete resources directory: " + directory), (Throwable)e);
                }
            }
            ObserveUICallback.application.run();
        }
    }
}

