/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.synchronize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class ObsoleteEntityTableModel
extends AbstractTableModel {
    protected static final String[] COLUMN_NAMES = new String[]{I18n.n((String)"observe.synchro.common.select", (Object[])new Object[0]), I18n.n((String)"observe.synchro.common.reference", (Object[])new Object[0])};
    protected static final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, TopiaEntity.class};
    private static final long serialVersionUID = 1L;
    protected List<TopiaEntityRef> refs;
    protected Set<Integer> selected = new HashSet<Integer>();
    protected boolean selectAll;

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void initEntity(List<TopiaEntityRef> refs) {
        this.refs = refs;
        this.selected.clear();
        this.setSelectAll(true);
    }

    public List<Integer> getSelectedIndex() {
        return new ArrayList<Integer>(this.selected);
    }

    public List<TopiaEntityRef> getSelectedRefs() {
        ArrayList<TopiaEntityRef> result = new ArrayList<TopiaEntityRef>();
        if (!this.selected.isEmpty()) {
            for (Integer i : this.selected) {
                result.add(this.refs.get(i));
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.refs == null ? 0 : this.refs.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_CLASSES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.selected.contains(rowIndex);
        }
        if (columnIndex == 1) {
            return this.refs.get(rowIndex);
        }
        throw new IllegalStateException("can not get value for row " + rowIndex + ", col " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Boolean value = (Boolean)aValue;
            if (value.booleanValue()) {
                this.selected.add(rowIndex);
                if (this.selected.size() == this.getRowCount()) {
                    this.selectAll = true;
                }
            } else {
                this.selected.remove(rowIndex);
                if (this.selected.isEmpty()) {
                    this.selectAll = false;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
        if (selectAll) {
            int max = this.getRowCount();
            for (int i = 0; i < max; ++i) {
                this.selected.add(i);
            }
        } else {
            this.selected.clear();
        }
        this.fireTableDataChanged();
    }
}

