/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.entities.Entities;
import fr.ird.observe.entities.constants.GearType;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.FloatingObject;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUI;
import fr.ird.observe.ui.content.impl.longline.LonglineGlobalCompositionUI;
import fr.ird.observe.ui.content.impl.longline.SetLonglineUI;
import fr.ird.observe.ui.content.impl.seine.ActivitySeineObservedSystemUI;
import fr.ird.observe.ui.content.impl.seine.FloatingObjectTransmittingBuoyOperationUI;
import fr.ird.observe.ui.content.impl.seine.FloatingObjectUI;
import fr.ird.observe.ui.content.impl.seine.SetSeineUI;
import fr.ird.observe.ui.content.list.impl.longline.ActivityLonglinesUI;
import fr.ird.observe.ui.content.list.impl.longline.TripLonglinesUI;
import fr.ird.observe.ui.content.list.impl.seine.ActivitySeinesUI;
import fr.ird.observe.ui.content.list.impl.seine.RoutesUI;
import fr.ird.observe.ui.content.list.impl.seine.TripSeinesUI;
import fr.ird.observe.ui.content.open.impl.longline.ActivityLonglineUI;
import fr.ird.observe.ui.content.open.impl.longline.TripLonglineUI;
import fr.ird.observe.ui.content.open.impl.seine.ActivitySeineUI;
import fr.ird.observe.ui.content.open.impl.seine.RouteUI;
import fr.ird.observe.ui.content.open.impl.seine.TripSeineUI;
import fr.ird.observe.ui.content.ref.ContentReferenceUI;
import fr.ird.observe.ui.content.ref.ReferenceHomeUI;
import fr.ird.observe.ui.content.table.impl.longline.CatchLonglineUI;
import fr.ird.observe.ui.content.table.impl.longline.EncounterUI;
import fr.ird.observe.ui.content.table.impl.longline.SensorUsedUI;
import fr.ird.observe.ui.content.table.impl.longline.TdrUI;
import fr.ird.observe.ui.content.table.impl.seine.NonTargetCatchUI;
import fr.ird.observe.ui.content.table.impl.seine.NonTargetSampleUI;
import fr.ird.observe.ui.content.table.impl.seine.ObjectObservedSpeciesUI;
import fr.ird.observe.ui.content.table.impl.seine.ObjectSchoolEstimateUI;
import fr.ird.observe.ui.content.table.impl.seine.SchoolEstimateUI;
import fr.ird.observe.ui.content.table.impl.seine.TargetCatchUI;
import fr.ird.observe.ui.content.table.impl.seine.TargetDiscardCatchUI;
import fr.ird.observe.ui.content.table.impl.seine.TargetSampleCaptureUI;
import fr.ird.observe.ui.content.table.impl.seine.TargetSampleRejeteUI;
import fr.ird.observe.ui.tree.ObserveNode;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ContentUIManager {
    public static final String REFERENCE = "reference";
    public static final String DATA = "data";
    private static final Log log = LogFactory.getLog(ContentUIManager.class);
    protected final ObserveMainUI ui;
    protected final Map<String, Class<? extends ObserveContentUI<?>>> mapping;

    public ContentUIManager(ObserveMainUI ui) {
        Class<?> result;
        String fqn;
        Class editType;
        this.ui = ui;
        this.mapping = new TreeMap();
        this.addMapping(DATA, Program.class, GearType.seine.name(), TripSeinesUI.class);
        this.addMapping(DATA, TripSeine.class, TripSeineUI.class);
        this.addMapping(DATA, TripSeine.class, I18n.n((String)"observe.common.tripSeine.unsaved", (Object[])new Object[0]), TripSeineUI.class);
        this.addMapping(DATA, TripSeine.class, "route", RoutesUI.class);
        this.addMapping(DATA, Route.class, RouteUI.class);
        this.addMapping(DATA, Route.class, I18n.n((String)"observe.common.route.unsaved", (Object[])new Object[0]), RouteUI.class);
        this.addMapping(DATA, Route.class, "activitySeine", ActivitySeinesUI.class);
        this.addMapping(DATA, ActivitySeine.class, ActivitySeineUI.class);
        this.addMapping(DATA, ActivitySeine.class, I18n.n((String)"observe.common.activitySeine.unsaved", (Object[])new Object[0]), ActivitySeineUI.class);
        this.addMapping(DATA, ActivitySeine.class, "observedSystem", ActivitySeineObservedSystemUI.class);
        this.addMapping(DATA, SetSeine.class, SetSeineUI.class);
        this.addMapping(DATA, SetSeine.class, I18n.n((String)"observe.common.setSeine.unsaved", (Object[])new Object[0]), SetSeineUI.class);
        this.addMapping(DATA, SetSeine.class, "schoolEstimate", SchoolEstimateUI.class);
        this.addMapping(DATA, SetSeine.class, "targetCatch", TargetCatchUI.class);
        this.addMapping(DATA, SetSeine.class, "targetDiscarded", TargetDiscardCatchUI.class);
        this.addMapping(DATA, SetSeine.class, "targetSample", TargetSampleRejeteUI.class);
        this.addMapping(DATA, SetSeine.class, "targetSampleCapture", TargetSampleCaptureUI.class);
        this.addMapping(DATA, SetSeine.class, "nonTargetCatch", NonTargetCatchUI.class);
        this.addMapping(DATA, SetSeine.class, "nonTargetSample", NonTargetSampleUI.class);
        this.addMapping(DATA, FloatingObject.class, FloatingObjectUI.class);
        this.addMapping(DATA, FloatingObject.class, I18n.n((String)"observe.common.floatingObject.unsaved", (Object[])new Object[0]), FloatingObjectUI.class);
        this.addMapping(DATA, FloatingObject.class, "objectOperation", FloatingObjectTransmittingBuoyOperationUI.class);
        this.addMapping(DATA, FloatingObject.class, "objectObservedSpecies", ObjectObservedSpeciesUI.class);
        this.addMapping(DATA, FloatingObject.class, "objectSchoolEstimate", ObjectSchoolEstimateUI.class);
        this.addMapping(DATA, Program.class, GearType.longline.name(), TripLonglinesUI.class);
        this.addMapping(DATA, TripLongline.class, TripLonglineUI.class);
        this.addMapping(DATA, TripLongline.class, I18n.n((String)"observe.common.tripLongline.unsaved", (Object[])new Object[0]), TripLonglineUI.class);
        this.addMapping(DATA, TripLongline.class, "activityLongline", ActivityLonglinesUI.class);
        this.addMapping(DATA, ActivityLongline.class, ActivityLonglineUI.class);
        this.addMapping(DATA, ActivityLongline.class, I18n.n((String)"observe.common.activityLongline.unsaved", (Object[])new Object[0]), ActivityLonglineUI.class);
        this.addMapping(DATA, ActivityLongline.class, "encounter", EncounterUI.class);
        this.addMapping(DATA, ActivityLongline.class, "sensorUsed", SensorUsedUI.class);
        this.addMapping(DATA, SetLongline.class, SetLonglineUI.class);
        this.addMapping(DATA, SetLongline.class, I18n.n((String)"observe.common.setLongline.unsaved", (Object[])new Object[0]), SetLonglineUI.class);
        this.addMapping(DATA, SetLongline.class, "longlineGlobalComposition", LonglineGlobalCompositionUI.class);
        this.addMapping(DATA, SetLongline.class, "longlineDetailComposition", LonglineDetailCompositionUI.class);
        this.addMapping(DATA, SetLongline.class, "catchLongline", CatchLonglineUI.class);
        this.addMapping(DATA, SetLongline.class, "tdr", TdrUI.class);
        for (ObserveEntityEnum anEnum : Entities.REFERENCE_COMMON_ENTITIES_LIST) {
            editType = anEnum.getContract();
            fqn = ContentReferenceUI.class.getPackage().getName() + ".impl." + editType.getSimpleName() + "UI";
            try {
                result = Class.forName(fqn);
                this.addMapping(REFERENCE, editType, null, result);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find " + fqn);
            }
        }
        for (ObserveEntityEnum anEnum : Entities.REFERENCE_SEINE_ENTITIES_LIST) {
            editType = anEnum.getContract();
            fqn = ContentReferenceUI.class.getPackage().getName() + ".impl.seine." + editType.getSimpleName() + "UI";
            try {
                result = Class.forName(fqn);
                this.addMapping(REFERENCE, editType, null, result);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find " + fqn);
            }
        }
        for (ObserveEntityEnum anEnum : Entities.REFERENCE_LONGLINE_ENTITIES_LIST) {
            editType = anEnum.getContract();
            fqn = ContentReferenceUI.class.getPackage().getName() + ".impl.longline." + editType.getSimpleName() + "UI";
            try {
                result = Class.forName(fqn);
                this.addMapping(REFERENCE, editType, null, result);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find " + fqn);
            }
        }
        this.addMapping(REFERENCE, null, ReferenceHomeUI.class);
    }

    public Class<? extends ObserveContentUI<?>> convertNodeToContentUI(ObserveNode node) {
        String mappingKey;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entrer for node = " + (Object)((Object)node)));
        }
        if (node.isRoot()) {
            return null;
        }
        Class editType = node.getInternalClass();
        String prefix = node.isReferentielNode() ? REFERENCE : DATA;
        String context = node.getContext();
        if (node.isReferentielNode()) {
            if (String.class.equals((Object)editType)) {
                editType = null;
            }
        } else if (String.class.equals((Object)editType)) {
            editType = ((ObserveNode)node.getContainerNode()).getInternalClass();
        }
        if ((mappingKey = this.getMappingKey(prefix, editType, context)) == null) {
            throw new NullPointerException("Could not find mappingKey for node " + (Object)((Object)node));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("mappingKey = [" + mappingKey + "] for node " + (Object)((Object)node)));
        }
        Class<? extends ObserveContentUI<?>> result = this.mapping.get(mappingKey);
        return result;
    }

    public <U extends ObserveContentUI<?>> U getContent(Class<U> uiClass) {
        CardLayout2 layout = this.getLayout();
        JPanel layoutContent = this.getLayoutContent();
        String constraints = uiClass.getName();
        if (!layout.contains((Serializable)((Object)constraints))) {
            return null;
        }
        ObserveContentUI content = (ObserveContentUI)((Object)layout.getComponent((Container)layoutContent, constraints));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use existing content [" + constraints + "] : " + content.getClass().getName()));
        }
        return (U)content;
    }

    public <U extends ObserveContentUI<?>> U createContent(Class<U> uiClass) {
        ObserveContentUI result;
        String constraints = uiClass.getName();
        if (this.getLayout().contains((Serializable)((Object)constraints))) {
            throw new IllegalStateException("Already existing constrainst [" + constraints + "]");
        }
        try {
            Constructor<U> constructor = uiClass.getConstructor(JAXXContext.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("create new content : " + uiClass + " from ui " + this.ui.getClass().getName()));
            }
            result = (ObserveContentUI)constructor.newInstance(new JAXXInitialContext().add((Object)this.ui));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create content ui " + uiClass, e);
        }
        try {
            this.getLayoutContent().add((Component)((JComponent)((Object)result)), constraints);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add new content [" + constraints + "] : " + result.getClass().getName()));
            }
            result.init();
            return (U)result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init content ui " + uiClass, e);
        }
    }

    public ObserveContentUI<?> getCurrentContent() {
        ObserveContentUI component = (ObserveContentUI)((Object)this.getLayout().getVisibleComponent((Container)this.getLayoutContent()));
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openContent(ObserveContentUI<?> content) {
        String constraints = content.getClass().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will open ui [" + constraints + "] : " + content.getClass()));
        }
        try {
            content.open();
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
        }
        finally {
            this.getLayout().show((Container)this.getLayoutContent(), constraints);
        }
    }

    public void close() {
        this.getLayout().reset((Container)this.getLayoutContent());
    }

    protected JPanel getLayoutContent() {
        JPanel content = this.ui.getContent();
        return content;
    }

    protected CardLayout2 getLayout() {
        CardLayout2 layout = this.ui.getContentLayout();
        return layout;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    protected void addMapping(String prefix, Class<?> klass, Class<? extends ObserveContentUI<?>> contentClass) {
        this.addMapping(prefix, klass, null, contentClass);
    }

    protected void addMapping(String prefix, Class<?> klass, String context, Class<?> contentClass) {
        String key = this.getMappingKey(prefix, klass, context);
        this.mapping.put(key, contentClass);
    }

    protected String getMappingKey(String prefix, Class<?> klass, String context) {
        String key = prefix + ".";
        if (klass != null) {
            key = key + klass.getName();
        }
        if (context != null) {
            if (klass != null) {
                key = key + "#";
            }
            key = key + context;
        }
        return key;
    }
}

