/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUILauncher;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class LaunchAdminAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LaunchAdminAction.class);
    private final ObserveMainUI ui;
    private final AdminStep action;

    public LaunchAdminAction(ObserveMainUI ui, AdminStep action) {
        super(I18n.t((String)action.getOperationLabel(), (Object[])new Object[0]), action.getIcon());
        this.ui = ui;
        this.action = action;
        this.putValue("ShortDescription", I18n.t((String)action.getOperationDescription(), (Object[])new Object[0]));
        this.putValue("MnemonicKey", I18n.t((String)action.getOperationLabel(), (Object[])new Object[0]).charAt(0));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canContinue = ObserveContext.get().closeSelectedContentUI(this.ui);
        if (canContinue) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will start admin action: " + this.action.getLabel()));
            }
            AdminUILauncher launcher = AdminUILauncher.newLauncher((JAXXContext)this.ui, this.action);
            launcher.start();
        }
    }
}

