/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.db.DataContext;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.nav.NavNode;
import org.nuiton.i18n.I18n;

public abstract class AbstractUIAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final ObserveMainUI mainUI;
    private final String actionId;

    public AbstractUIAction(ObserveMainUI mainUI, String actionId, String label, String shortDescription, String actionIcon) {
        super(I18n.t((String)label, (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)actionIcon));
        this.actionId = actionId;
        this.mainUI = mainUI;
        this.putValue("ShortDescription", I18n.t((String)shortDescription, (Object[])new Object[0]));
    }

    public ObserveMainUI getMainUI() {
        return this.mainUI;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void initAction(ObserveContentUI<?> ui, AbstractButton editor) {
        editor.setAction(this);
        editor.putClientProperty("mainUI", this.mainUI);
    }

    public void updateAction(ObserveContentUI<?> ui, AbstractButton editor) {
        String actionIcon;
        String text;
        editor.putClientProperty("ui", ui);
        String tip = (String)editor.getClientProperty("toolTipText");
        if (tip != null) {
            editor.setToolTipText(tip);
        }
        if ((text = (String)editor.getClientProperty("text")) != null) {
            editor.setText(text);
        }
        if ((actionIcon = (String)editor.getClientProperty("actionIcon")) != null) {
            Icon icon = SwingUtil.getUIManagerActionIcon((String)actionIcon);
            editor.setIcon(icon);
        }
    }

    public static boolean isOpenActivityNodeCollapsed(JTree tree, ObserveTreeHelper treeHelper, DataContext dataContext) {
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        TreePath path = tree.getSelectionPath();
        String id = dataContext.getOpenActivityId();
        ObserveNode node1 = (ObserveNode)treeHelper.findNode((NavNode)node, new String[]{id});
        TreePath activityPath = path.pathByAddingChild((Object)node1);
        boolean wasCollapsed = tree.isCollapsed(activityPath);
        return wasCollapsed;
    }
}

