/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import fr.ird.observe.access.AccessImporterModel;
import fr.ird.observe.access.EntityBuilder;
import fr.ird.observe.access.ObserveAccessDataSource;
import fr.ird.observe.access.ObserveAccessHitModel;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import java.io.File;
import java.util.Date;

public class AccessModel
extends AdminActionModel {
    public static final String PROPERTY_IMPORT_FILE = "importFile";
    public static final String PROPERTY_OUTPUT_FILE = "outputFile";
    public static final String PROPERTY_SELECTED_PROGRAMME = "selectedProgramme";
    public static final String PROPERTY_SELECTED_OCEAN = "selectedOcean";
    protected File outputFile = new File("");
    protected AccessImporterModel importModel = new AccessImporterModel();
    protected DataSource tmpSource;
    protected DataSource centralSource;
    protected Programme selectedProgramme;
    protected Ocean selectedOcean;

    public AccessModel() {
        super(AdminStep.VALIDATE);
    }

    public File getImportFile() {
        return this.importModel.getImportFile();
    }

    public void setImportFile(File importFile) {
        File oldValue = this.getImportFile();
        this.importModel.setImportFile(importFile);
        this.firePropertyChange(PROPERTY_IMPORT_FILE, oldValue, importFile);
    }

    public AccessImporterModel getImportModel() {
        return this.importModel;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public ObserveAccessHitModel getHits() {
        return this.importModel.getHits();
    }

    public ObserveAccessHitModel getTotalHits() {
        return this.importModel.getTotalHits();
    }

    public Programme getSelectedProgramme() {
        return this.selectedProgramme;
    }

    public Ocean getSelectedOcean() {
        return this.selectedOcean;
    }

    public ObserveAccessDataSource initInputSource() throws Exception {
        ObserveAccessDataSource source = this.importModel.initInputSource();
        return source;
    }

    public EntityBuilder getBuilder() {
        return this.importModel.getBuilder();
    }

    public void setBuilder(EntityBuilder builder) {
        this.importModel.setBuilder(builder);
    }

    public void setOutputFile(File outputFile) {
        File oldValue = this.outputFile;
        this.outputFile = outputFile;
        this.firePropertyChange(PROPERTY_OUTPUT_FILE, oldValue, outputFile);
    }

    public void setSelectedProgramme(Programme selectedProgramme) {
        Programme oldValue = this.selectedProgramme;
        this.selectedProgramme = selectedProgramme;
        String id = selectedProgramme == null ? null : selectedProgramme.getTopiaId();
        this.importModel.setProgrammeId(id);
        this.firePropertyChange(PROPERTY_SELECTED_PROGRAMME, oldValue, selectedProgramme);
    }

    public void setSelectedOcean(Ocean selectedOcean) {
        Ocean oldValue = this.selectedOcean;
        this.selectedOcean = selectedOcean;
        String id = selectedOcean == null ? null : selectedOcean.getTopiaId();
        this.importModel.setOceanId(id);
        this.firePropertyChange(PROPERTY_SELECTED_OCEAN, oldValue, selectedOcean);
    }

    public DataSource getTmpSource() {
        return this.importModel.getOutputSource();
    }

    public DataSource getCentralSource() {
        return this.centralSource;
    }

    public ObserveAccessDataSource getAccessDataSource() {
        return this.importModel.getInputSource();
    }

    public void setCentralSource(DataSource centralSource) {
        this.centralSource = centralSource;
    }

    public Maree[] getAccessMarees() throws Exception {
        return this.importModel.getAccessMarees();
    }

    public String getDefaultBackupFilename() {
        return String.format("import-access-%1$tF--%1$tk-%1$tM-%1$tS.sql.gz", new Date());
    }

    public void destroy() {
        super.destroy();
        this.importModel.destroy();
    }
}

