/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.TailleThon;
import fr.ird.observe.entities.constants.CodeMesureEnum;
import fr.ird.observe.entities.constants.ModeSaisieEchantillonEnum;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUI;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.AbstractEchantillonThonUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.validator.NuitonValidatorScope;

public class EchantillonThonUIHandler
extends ContentTableUIHandler<EchantillonThon, TailleThon> {
    private static Log log = LogFactory.getLog(EchantillonThonUIHandler.class);
    protected final boolean capture;
    protected final PropertyChangeListener poidsChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TailleThon source = (TailleThon)evt.getSource();
            source.setPoidsCalcule(false);
        }
    };
    protected final PropertyChangeListener longueurChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TailleThon source = (TailleThon)evt.getSource();
            source.setLongueurCalcule(false);
        }
    };

    static ContentTableUIModel<EchantillonThon, TailleThon> newModel(ContentTableUI<EchantillonThon, TailleThon> ui) {
        return new ContentTableUIModel<EchantillonThon, TailleThon>(EchantillonThon.class, TailleThon.class, new String[]{"tailleThon", "commentaire"}, new String[]{"echantillonThon", "espece", "longueur", "longueurCalcule", "poids", "poidsCalcule", "effectif", "codeMesure", "modeSaisie"}, ui, ContentTableModel.newTableMeta(TailleThon.class, "espece", true), ContentTableModel.newTableMeta(TailleThon.class, "codeMesure", true), ContentTableModel.newTableMeta(TailleThon.class, "longueur", true), ContentTableModel.newTableMeta(TailleThon.class, "poids", true), ContentTableModel.newTableMeta(TailleThon.class, "effectif", false), ContentTableModel.newTableMeta(TailleThon.class, "poidsTotal", true));
    }

    public EchantillonThonUIHandler(ContentTableUI<EchantillonThon, TailleThon> ui, boolean capture) {
        super(ui);
        this.capture = capture;
    }

    @Override
    public AbstractEchantillonThonUI getUi() {
        return (AbstractEchantillonThonUI)super.getUi();
    }

    public void resetPoidsCalcule() {
        ((TailleThon)this.getTableEditBean()).setPoidsCalcule(false);
        this.getUi().getPoids().grabFocus();
    }

    public void resetLongueurCalcule() {
        ((TailleThon)this.getTableEditBean()).setLongueurCalcule(false);
        this.getUi().getLongueur().grabFocus();
    }

    @Override
    protected EchantillonThon loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String caleeId = dataContext.getSelectedCaleeId();
        if (mode == ContentMode.UPDATE) {
            List especes = dataService.getAvailableEspeceForEchantillonThon(dataSource, caleeId, this.capture);
            this.getUi().getEspece().setData(especes);
        }
        String id = dataService.getEchantillonThonId(dataSource, caleeId, this.capture);
        EchantillonThon editBean = (EchantillonThon)this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + " - calee id            : " + caleeId));
            log.info((Object)(this.prefix + " - echantillon thon id : " + id));
            log.info((Object)(this.prefix + " - edit bean id        : " + editBean.getTopiaId()));
        }
        if (id == null) {
            this.getLoadBinder().load(null, (TopiaEntity)editBean, true, new String[0]);
            this.getChildsUpdator().setChilds((TopiaEntity)editBean, new ArrayList());
        } else {
            dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
        }
        this.getModel().setMode(mode);
        this.getUi().getTableModel().attachModel();
        return editBean;
    }

    @Override
    protected boolean prepareSave(EchantillonThon bean, List<TailleThon> objets) throws DataSourceException {
        if (bean.getTopiaId() == null) {
            String caleeId = this.getDataContext().getSelectedCaleeId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create echantillon thon " + bean + " for " + caleeId));
            }
            this.getDataService().create(this.getDataSource(), caleeId, (TopiaEntity)bean, null, this.getCreateExecutor());
        }
        for (TailleThon tailleThon : objets) {
            tailleThon.setEchantillonThon(bean);
        }
        return true;
    }

    @Override
    protected EchantillonThon onCreate(TopiaContext tx, Object parent, EchantillonThon editBean) throws TopiaException {
        Calee parentBean = (Calee)parent;
        EchantillonThon beanToSave = (EchantillonThon)ObserveDAOHelper.getEchantillonThonDAO((TopiaContext)tx).create(new Object[0]);
        beanToSave.setCapture(Boolean.valueOf(this.capture));
        editBean.setTopiaId(beanToSave.getTopiaId());
        editBean.setTopiaCreateDate(beanToSave.getTopiaCreateDate());
        editBean.setTopiaVersion(beanToSave.getTopiaVersion());
        parentBean.addEchantillonThon(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TailleThon bean, boolean create) {
        BeanComboBox<EspeceThon> requestFocus;
        ContentTableModel model = this.getTableModel();
        AbstractEchantillonThonUI ui = this.getUi();
        if (!model.isEditable()) {
            return;
        }
        EspeceThon espece = bean.getEspece();
        if (create) {
            if (model.isCreate()) {
                if (editingRow > 0) {
                    TailleThon editBean = (TailleThon)model.getValueAt(editingRow - 1);
                    espece = editBean.getEspece();
                }
                ui.getModeSaisieGroup().setSelectedValue(null);
                ui.getModeSaisieGroup().setSelectedValue((Object)ModeSaisieEchantillonEnum.byEffectif);
                ui.getCodeMesure().setSelectedItem(null);
                ui.getCodeMesure().setSelectedItem((Object)CodeMesureEnum.lf);
            }
            requestFocus = ui.getEspece();
        } else {
            requestFocus = ui.getEffectif();
            int modeSaisie = bean.getModeSaisie();
            ModeSaisieEchantillonEnum enumValue = ModeSaisieEchantillonEnum.valueOf((int)modeSaisie);
            ui.getModeSaisieGroup().setSelectedValue(null);
            ui.getModeSaisieGroup().setSelectedValue((Object)enumValue);
        }
        ui.getEspece().setSelectedItem(null);
        if (espece != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("espece to use " + espece));
            }
            ui.getEspece().setSelectedItem((Object)espece);
        }
        requestFocus.requestFocus();
        TailleThon tableEditBean = (TailleThon)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("poids", this.poidsChanged);
        tableEditBean.addPropertyChangeListener("poids", this.poidsChanged);
        tableEditBean.removePropertyChangeListener("longueur", this.longueurChanged);
        tableEditBean.addPropertyChangeListener("longueur", this.longueurChanged);
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.echantillonThon.especeThon", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.especeThon.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.codeMesure", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.codeMesure.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.longueur", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.longueur.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.poidsIndividuel", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.poidsIndividuel.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.effectif", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.effectif.tip", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.poidsTotal", (Object[])new Object[0]), I18n.n_((String)"observe.table.echantillonThon.poidsTotal.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, CodeMesureEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        boolean showData;
        ContentMode mode;
        block3: {
            mode = super.getContentMode(dataContext);
            showData = false;
            try {
                String caleeId = this.getDataContext().getSelectedCaleeId();
                showData = this.getDataService().canUseEchantillonThon(this.getDataSource(), caleeId, this.capture);
            }
            catch (DataSourceException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)e);
            }
        }
        ((ContentTableUIModel)this.getModel()).setShowData(showData);
        if (mode == ContentMode.UPDATE && !showData) {
            mode = ContentMode.READ;
            EchantillonThonUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(Calee.class), this.capture ? I18n._((String)"observe.message.calee.no.captureThon", (Object[])new Object[0]) : I18n._((String)"observe.message.calee.no.rejetThon", (Object[])new Object[0]));
        }
        return mode;
    }

    public void updateModeSaisie(ModeSaisieEchantillonEnum newMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Change mode saisie to " + newMode));
        }
        if (newMode == null) {
            return;
        }
        AbstractEchantillonThonUI ui = this.getUi();
        boolean createMode = ui.getTableModel().isCreate();
        TailleThon editBean = ui.getTableEditBean();
        switch (newMode) {
            case byEffectif: {
                ui.getPoids().setEnabled(false);
                ui.getEffectif().setEnabled(true);
                if (!createMode) break;
                editBean.setPoids(null);
                editBean.setEffectif(null);
                break;
            }
            case byIndividu: {
                ui.getPoids().setEnabled(true);
                ui.getEffectif().setEnabled(false);
                if (!createMode) break;
                editBean.setEffectif(Integer.valueOf(1));
            }
        }
        if (createMode) {
            editBean.setModeSaisie(newMode.ordinal());
        }
    }
}

