/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report;

import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.report.model.DataMatrix;
import fr.ird.observe.report.model.Report;
import fr.ird.observe.report.model.ReportExecute;
import fr.ird.observe.report.model.ReportVariable;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIModel;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.report.ReportConfigUI;
import fr.ird.observe.ui.admin.report.ReportModel;
import fr.ird.observe.ui.admin.report.ReportUI;
import fr.ird.observe.ui.admin.report.ResultTableModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class ReportUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ReportUIHandler.class);
    public static final String VARIABLE_NAME = "variableName";
    final Runnable revalidateTabUI = new Runnable(){

        @Override
        public void run() {
            ReportUIHandler.this.getUi().revalidate();
        }
    };

    public ReportUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, final ReportUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        UIHelper.setLayerUI((JComponent)tabUI.getContent(), (LayerUI)ui.getConfigBlockLayerUI());
        ReportModel stepModel = this.getStepModel();
        stepModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ReportUIHandler.this.getModel().getModelState() == WizardState.CANCELED) {
                    return;
                }
                String propertyName = evt.getPropertyName();
                Object newValue = evt.getNewValue();
                final ReportModel source = (ReportModel)((Object)evt.getSource());
                if ("reports".equals(propertyName)) {
                    List reports = (List)newValue;
                    ReportUIHandler.this.onReportsChanged(tabUI, reports);
                } else if ("selectedReport".equals(propertyName)) {
                    Report report = (Report)newValue;
                    ReportUIHandler.this.onSelectedReportChanged(tabUI, source, report);
                } else if ("variables".equals(propertyName)) {
                    Map variables = (Map)newValue;
                    ReportUIHandler.this.onVariablesChanges(source, variables);
                } else if ("valid".equals(propertyName)) {
                    final Boolean valid = (Boolean)newValue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReportUIHandler.this.onValidChanged(source, valid != null && valid != false);
                        }
                    });
                }
            }
        });
        tabUI.getReportSelector().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    value = I18n._((String)"observe.message.select.report", (Object[])new Object[0]);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){
            Font defaultFont;
            Font headerFont;

            public Font getDefaultFont(JTable table) {
                if (this.defaultFont == null) {
                    this.defaultFont = table.getFont();
                }
                return this.defaultFont;
            }

            public Font getHeaderFont(JTable table) {
                if (this.headerFont == null) {
                    this.headerFont = this.getDefaultFont(table).deriveFont(1);
                }
                return this.headerFont;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Font font = row == 0 || column == 0 ? this.getHeaderFont(table) : this.getDefaultFont(table);
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setFont(font);
                return comp;
            }
        };
        tabUI.getResultTable().setDefaultRenderer(Object.class, renderer);
        tabUI.getResultTable().setDefaultRenderer(String.class, renderer);
        if (log.isInfoEnabled()) {
            log.info((Object)("Init extra configuration for " + tabUI.getName()));
        }
        ConfigUI configUI = (ConfigUI)ui.getStepUI(AdminStep.CONFIG);
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)configUI).add((Object)this);
        ReportConfigUI extraConfig = new ReportConfigUI((JAXXContext)tx);
        configUI.getExtraConfig().add((Component)((Object)extraConfig));
        final SelectDataUI selectTabUI = (SelectDataUI)ui.getStepUI(AdminStep.SELECT_DATA);
        ui.getModel().addPropertyChangeListener("selectionModelChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AdminUIModel model = (AdminUIModel)((Object)evt.getSource());
                if (!model.containsStep((WizardStep)selectTabUI.getStep())) {
                    return;
                }
                DataSelectionModel value = (DataSelectionModel)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("selection model changed to " + value.getDatas()));
                    log.debug((Object)("IS USE DATA ? : " + value.isUseData()));
                }
                ReportUIHandler.this.updateSelectionModel(selectTabUI);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelectedReport(Report report) {
        this.getModel().setBusy(true);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("New selected report : " + report));
            }
            this.getStepModel().setSelectedReport(report);
        }
        finally {
            this.getModel().setBusy(false);
        }
    }

    public String updateSelectedReportDescrption(Report report) {
        if (report == null) {
            return I18n._((String)"observe.message.no.report.selected", (Object[])new Object[0]);
        }
        return I18n._((String)report.getDescription(), (Object[])new Object[0]);
    }

    public void updateVariable(JComboBox combo, Object value) {
        String variableName = (String)combo.getClientProperty(VARIABLE_NAME);
        if (variableName == null) {
            throw new IllegalStateException("No 'variableName' clientProperty on " + combo);
        }
        TopiaEntity entity = (TopiaEntity)value;
        String id = null;
        if (entity != null) {
            id = entity.getTopiaId();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Set variable [" + variableName + "] to value " + id));
        }
        this.getStepModel().addVariable(variableName, id);
    }

    public void chooseReportFile() {
        ReportModel model = this.getModel().getReportModel();
        File f = UIHelper.chooseFile(this.ui, I18n._((String)"observe.title.choose.reportFile", (Object[])new Object[0]), I18n._((String)"observe.action.choose.reportFile", (Object[])new Object[0]), model.getReportFile(), "^.+\\.properties$", I18n._((String)"observe.action.choose.reportFile.description", (Object[])new Object[0]));
        model.setReportFile(f);
    }

    public void copyReportToClipBoard(Report report, ResultTableModel model, boolean copyRowHeaders, boolean copyColumnHeaders) {
        if (report == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will copy result of report " + report.getName()));
            log.debug((Object)("Result dimension : [" + model.getRowCount() + "," + model.getColumnCount() + "]"));
        }
        String content = model.getClipbordContent(copyRowHeaders, copyColumnHeaders);
        UIHelper.copyToClipBoard(content);
    }

    protected void onReportsChanged(ReportUI tabUI, List<?> newValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("New reports : " + newValue));
        }
        newValue.add(0, null);
        UIHelper.fillComboBox((JComboBox)tabUI.getReportSelector(), newValue, null);
    }

    protected void onSelectedReportChanged(ReportUI tabUI, ReportModel model, Report report) {
        ReportExecute execute;
        if (log.isInfoEnabled()) {
            log.info((Object)("New selected report [" + report + "]"));
        }
        if ((execute = this.getReportExecute(model)) == null) {
            return;
        }
        try {
            execute.populate(report, this.getModel().getSelectedMaree());
        }
        catch (RuntimeException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new IllegalStateException("Could not populate report " + report + " in executor", eee);
        }
        JPanel variablesPanel = tabUI.getReportVariableSelectorPanel();
        variablesPanel.removeAll();
        boolean useVariables = report != null && report.getVariables().length > 0;
        tabUI.getReportVariableSelectorPane().setVisible(useVariables);
        if (useVariables) {
            for (ReportVariable variable : report.getVariables()) {
                String variableName = variable.getName();
                List universe = execute.getVariableUniverse(variableName);
                BeanComboBox combo = new BeanComboBox();
                combo.setShowReset(Boolean.valueOf(true));
                variablesPanel.add((Component)combo);
                Decorator decorator = this.getDecoratorService().getDecorator(variable.getType());
                combo.init((JXPathDecorator)decorator, universe);
                JComboBox jComboBox = combo.getCombobox();
                jComboBox.putClientProperty(VARIABLE_NAME, variableName);
                jComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        JComboBox comboBox = (JComboBox)e.getSource();
                        if (e.getStateChange() == 2) {
                            if (comboBox.getSelectedItem() == null) {
                                ReportUIHandler.this.updateVariable(comboBox, null);
                            }
                            return;
                        }
                        Object o = e.getItem();
                        ReportUIHandler.this.updateVariable(comboBox, o);
                    }
                });
            }
        }
        SwingUtilities.invokeLater(this.revalidateTabUI);
        Map<String, String> variables = model.getVariables();
        this.updateValidState(execute, variables);
    }

    protected void onVariablesChanges(ReportModel model, Map<String, String> variables) {
        ReportExecute execute = this.getReportExecute(model);
        if (execute == null) {
            return;
        }
        this.updateValidState(execute, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onValidChanged(ReportModel model, boolean valid) {
        if (log.isInfoEnabled()) {
            log.info((Object)("valid state changed to " + valid));
        }
        if (!valid) {
            model.getResultModel().populate(null, null);
            return;
        }
        this.getModel().setBusy(true);
        try {
            DataMatrix data;
            ReportExecute execute = this.getReportExecute(model);
            if (execute == null) {
                return;
            }
            Report report = null;
            try {
                String mareeId = this.getModel().getSelectedMaree();
                report = execute.getReport();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Build result for report [" + report.getName() + "] on " + mareeId));
                }
                Map<String, String> variables = model.getVariables();
                variables.put("mareeId", mareeId);
                data = execute.execute(variables);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Result to dispaly:\n" + data.getClipbordContent(true, true)));
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Could not obtain report data", (Throwable)e);
                }
                ErrorDialogUI.showError((Exception)e);
                data = null;
            }
            model.getResultModel().populate(report, data);
            if (model.isAutoCopyToClipboard()) {
                this.copyReportToClipBoard(report, model.getResultModel(), model.isCopyRowHeaders(), model.isCopyColumnHeaders());
            }
        }
        finally {
            this.getModel().setBusy(false);
        }
    }

    protected ReportModel getStepModel() {
        return this.model.getReportModel();
    }

    protected void updateValidState(ReportExecute execute, Map<String, String> variables) {
        boolean canExecute = execute.canExecute(variables);
        this.getStepModel().setValid(canExecute);
    }

    protected ReportExecute getReportExecute(ReportModel stepModel) {
        if (this.getModel().getModelState() == WizardState.CANCELED) {
            return null;
        }
        DataSource source = this.getModel().getSafeLocalSource(false);
        if (source.wasClosed()) {
            return null;
        }
        try {
            this.openSource(source);
        }
        catch (DataSourceException eee) {
            throw new IllegalStateException("Could not open data source " + source.getLabel(), eee);
        }
        ReportExecute execute = stepModel.getReportExecute();
        execute.setSource(source);
        return execute;
    }
}

