/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.ui.tree.ObserveNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObserveTreeBridge
extends NavTreeBridge<ObserveNode> {
    private static final Log log = LogFactory.getLog(ObserveTreeBridge.class);
    protected JTree ui;
    protected List<String> pathToSelect = new ArrayList<String>();

    public void setUi(JTree ui) {
        this.ui = ui;
    }

    public boolean canLoadChild(ObserveNode node) {
        ObserveNode root = (ObserveNode)this.getRoot();
        if (((Object)((Object)node)).equals((Object)root)) {
            return true;
        }
        ObserveNode parent = (ObserveNode)node.getParent();
        if (((Object)((Object)parent)).equals((Object)root)) {
            return true;
        }
        Object[] pathToRoot = this.getPathToRoot((TreeNode)((Object)node));
        TreePath path = new TreePath(pathToRoot);
        if (CollectionUtils.isNotEmpty(this.pathToSelect)) {
            String nodeId;
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is a selected path, try to use it for " + (Object)((Object)node)));
            }
            ObserveNode containerNode = (nodeId = node.getId()).startsWith("observe.common.") ? (ObserveNode)node.getParent() : node;
            String containerNodeId = containerNode.getId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Test if data node is in path ? " + containerNodeId + " : " + this.pathToSelect.contains(containerNodeId)));
            }
            return this.pathToSelect.contains(containerNodeId);
        }
        if (this.ui == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No ui in bridge!!!");
            }
            return true;
        }
        boolean visible = this.ui.isVisible(path);
        if (!visible) {
            return false;
        }
        TreePath selected = this.ui.getSelectionPath();
        return path.equals(selected);
    }

    public void setPathToSelect(String ... pathToSelect) {
        this.pathToSelect.clear();
        this.pathToSelect.addAll(Arrays.asList(pathToSelect));
    }
}

