/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.impl.DataServiceImpl;
import fr.ird.observe.entities.referentiel.ReferentielEntity;
import fr.ird.observe.ui.ObserveMainUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorUtils;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.FileUtil;

public class UIHelper
extends SwingUtil {
    private static final Log log = LogFactory.getLog(UIHelper.class);
    public static final String INT_3_DIGITS_PATTERN = "\\d{0,3}";
    public static final String INT_6_DIGITS_PATTERN = "\\d{0,6}";
    public static final String INT_7_DIGITS_PATTERN = "\\d{0,7}";
    public static final String DECIMAL1_PATTERN = "\\d{0,6}|\\d{1,6}.\\d{0,1}";
    public static final String DECIMAL2_PATTERN = "\\d{0,6}|\\d{1,6}.\\d{0,2}";
    public static final String DECIMAL3_PATTERN = "\\d{0,6}|\\d{1,6}.\\d{0,3}";
    public static final String[] ACCEPTABLE_COMPONENTS = new String[]{"showProgressButton", "globalProgressionCopyToClipBoard", "progressionTopCopyCliptBoard"};
    public static final Comparator<Class> REFERENTIEL_COMPARATOR = new Comparator<Class>(){
        DecoratorService decoratorService = ObserveServiceHelper.getDecoratorService();

        @Override
        public int compare(Class o1, Class o2) {
            String s1 = I18n._((String)this.decoratorService.getEntityLabel(o1), (Object[])new Object[0]);
            String s2 = I18n._((String)this.decoratorService.getEntityLabel(o2), (Object[])new Object[0]);
            return s1.compareTo(s2);
        }
    };

    public static void displayInfo(String text) {
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        if (ui == null) {
            JOptionPane.showMessageDialog(null, text);
        } else {
            ui.getStatus().setStatus(text);
        }
    }

    public static int askUser(String title, String message, int typeMessage, Object[] options, int defaultOption) {
        return UIHelper.askUser(null, title, message, typeMessage, options, defaultOption);
    }

    public static int askUser(Component parent, String title, Object message, int typeMessage, Object[] options, int defaultOption) {
        ObserveContext tx;
        if (parent == null && (tx = ObserveContext.get()) != null) {
            parent = ObserveContext.get().getObserveMainUI();
        }
        int response = JOptionPane.showOptionDialog(parent, message, title, -1, typeMessage, null, options, options[defaultOption]);
        return response;
    }

    public static File chooseFile(Component parent, String title, String buttonLabel, File incoming, String ... filters) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        File file = FileUtil.getFile((String)title, (String)buttonLabel, (Component)parent, (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        File result = file == null ? incoming : file;
        return result;
    }

    public static File chooseDirectory(Component parent, String title, String buttonLabel, File incoming) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        String file = FileUtil.getDirectory((Component)parent, (String)title, (String)buttonLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        return file == null ? incoming : new File(file);
    }

    public static <E extends TopiaEntity> void prepareEntityList(DataSource storageService, Class<E> entityClass, BeanListHeader<E> list) throws DataSourceException {
        ObserveContext tx = ObserveContext.get();
        Decorator decorator = tx.getDecorator(entityClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use decorator " + decorator));
        }
        list.putClientProperty((Object)"decorator", (Object)decorator);
        List data = ReferentielEntity.class.isAssignableFrom(entityClass) ? tx.getDataService().getList(storageService, entityClass) : new ArrayList();
        DecoratorUtils.sort((JXPathDecorator)((JXPathDecorator)decorator), data, (int)0);
        list.init((JXPathDecorator)decorator, data);
        ListCellRenderer renderer = list.getList().getCellRenderer();
        list.getList().setCellRenderer(new ReferentielListCellRenderer(renderer));
        list.putClientProperty((Object)"data", data);
        EntityListPropertyChangeListener<E> listener = new EntityListPropertyChangeListener<E>(entityClass, list);
        DataServiceImpl service = ObserveContext.get().getDataService();
        service.addReferentielPropertyChangeListener(entityClass, listener);
    }

    public static <E extends ReferentielEntity> void prepareBeanComboBox(DataSource storageService, Class<E> entityClass, BeanComboBox<E> comboBox) throws DataSourceException {
        ObserveContext context = ObserveContext.get();
        Decorator decorator = context.getDecorator(entityClass);
        DataServiceImpl service = context.getDataService();
        List data = service.getList(storageService, entityClass);
        UIHelper.filterReferentielList(data, decorator);
        if (log.isInfoEnabled()) {
            log.info((Object)("entity list [" + entityClass.getName() + "] : " + data.size()));
        }
        comboBox.init((JXPathDecorator)decorator, data);
        final ListCellRenderer renderer = comboBox.getCombobox().getRenderer();
        ListCellRenderer toolTipRenderer = new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (comp instanceof JLabel) {
                    JLabel jcomp = (JLabel)comp;
                    jcomp.setToolTipText(jcomp.getText());
                }
                return comp;
            }
        };
        comboBox.getCombobox().setRenderer(toolTipRenderer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("combo  list [" + entityClass.getName() + "] : " + comboBox.getData().size()));
        }
        BeanComboBoxPropertyChangeListener listener = new BeanComboBoxPropertyChangeListener<E>((Class)entityClass, (BeanComboBox)comboBox){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("entity list [" + evt.getPropertyName() + "]"));
                }
                super.propertyChange(evt);
            }
        };
        service.addReferentielPropertyChangeListener(entityClass, (PropertyChangeListener)listener);
    }

    public static <E extends ReferentielEntity> void filterReferentielList(List<E> list, Decorator<E> decorator) {
        Iterator<E> itr = list.iterator();
        while (itr.hasNext()) {
            ReferentielEntity e = (ReferentielEntity)itr.next();
            if (e.getStatus() != 0) continue;
            if (decorator == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("remove disabled entity " + e.getTopiaId() + " : " + e.getTopiaId()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("remove disabled entity " + e.getTopiaId() + " : " + decorator.toString((Object)e)));
            }
            itr.remove();
        }
    }

    public static void prepareToogleListSelectionModel(JList list) {
        OneClicListSelectionModel model = new OneClicListSelectionModel(list.getSelectionModel(), list.getModel());
        list.setSelectionModel((ListSelectionModel)model);
    }

    public static <E extends TopiaEntity> boolean confirmForEntityDelete(JAXXObject parent, Class<E> beanClass, E bean) {
        return UIHelper.confirmForEntityDelete(parent, beanClass, bean, null);
    }

    public static <E extends TopiaEntity> boolean confirmForEntityDelete(JAXXObject parent, Class<E> beanClass, E bean, String extraMessage) {
        String messageDelete;
        ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
        if (parent == null) {
            parent = mainUI;
        }
        if (mainUI != null) {
            mainUI.setBusy(true);
        }
        DecoratorService decoratorService = ObserveContext.get().getDecoratorService();
        Decorator decorator = decoratorService.getDecorator(beanClass);
        String type = decoratorService.getEntityLabel(beanClass);
        type = I18n._((String)type, (Object[])new Object[0]);
        if (bean == null || bean.getTopiaId() == null || decorator == null) {
            messageDelete = I18n._((String)"observe.message.delete.new", (Object[])new Object[]{type});
        } else {
            try {
                String beanStr = decorator.toString(bean);
                messageDelete = I18n._((String)"observe.message.delete", (Object[])new Object[]{type, beanStr});
            }
            catch (Exception e) {
                messageDelete = I18n._((String)"observe.message.delete.new", (Object[])new Object[]{type});
            }
        }
        if (extraMessage != null) {
            messageDelete = messageDelete + '\n' + extraMessage;
        }
        int response = UIHelper.askUser((Component)parent, I18n._((String)"observe.title.delete", (Object[])new Object[0]), messageDelete, 2, new Object[]{I18n._((String)"observe.choice.confirm.delete", (Object[])new Object[0]), I18n._((String)"observe.choice.cancel", (Object[])new Object[0])}, 1);
        if (mainUI != null) {
            mainUI.setBusy(true);
        }
        return response == 0;
    }

    public static DecoratorTableCellRenderer newDecorateTableCellRenderer(TableCellRenderer renderer, Class<?> entityClass) {
        Decorator decorator = ObserveContext.get().getDecorator(entityClass);
        return new DecoratorTableCellRenderer(renderer, decorator);
    }

    public static void sortReferentiel(List<Class> classes) {
        Collections.sort(classes, REFERENTIEL_COMPARATOR);
    }

    public static void copyToClipBoard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (log.isInfoEnabled()) {
            log.info((Object)("Put in clipboard :\n" + text));
        }
        StringSelection selection = new StringSelection(text);
        clipboard.setContents(selection, selection);
    }

    public static void setMainUIVisible(final ObserveMainUI ui) {
        ui.getSplitpane().revalidate();
        ui.getSplitpane2().revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ui.setVisible(true);
            }
        });
    }

    public static class ReferentielListCellRenderer
    implements ListCellRenderer {
        protected Color normalColor;
        protected Color disableColor = Color.LIGHT_GRAY;
        protected ListCellRenderer delegate;

        public ReferentielListCellRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (this.normalColor == null) {
                this.normalColor = comp.getForeground();
            }
            String tip = ((JLabel)comp).getText();
            Color col = this.normalColor;
            if (value != null && value instanceof ReferentielEntity) {
                ReferentielEntity e = (ReferentielEntity)value;
                int status = e.getStatus();
                if (status == 0) {
                    col = this.disableColor;
                    tip = I18n._((String)"observe.common.obsolete.entity", (Object[])new Object[]{tip});
                } else {
                    tip = null;
                }
            } else {
                tip = null;
            }
            comp.setForeground(col);
            comp.setToolTipText(tip);
            return comp;
        }
    }

    public static class ObserveValidatorMessageTableRenderer
    extends SwingValidatorMessageTableRenderer {
        private static final long serialVersionUID = 1L;
        protected DecoratorService decoratorService;

        public DecoratorService getDecoratorService() {
            if (this.decoratorService == null) {
                this.decoratorService = ObserveContext.get().getDecoratorService();
            }
            return this.decoratorService;
        }

        public String getFieldName(JTable table, String value, int row) {
            String fieldName = super.getFieldName(table, value, row);
            DecoratorService dService = this.getDecoratorService();
            if (!dService.getPropertyMatch(fieldName).matches()) {
                fieldName = dService.getPropertyLabel(fieldName);
            }
            return I18n._((String)fieldName, (Object[])new Object[0]);
        }
    }

    protected static class BeanComboBoxPropertyChangeListener<E extends ReferentielEntity>
    implements PropertyChangeListener {
        private final Class<E> entityClass;
        private final BeanComboBox<E> comboBox;

        public BeanComboBoxPropertyChangeListener(Class<E> entityClass, BeanComboBox<E> comboBox) {
            this.entityClass = entityClass;
            this.comboBox = comboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ArrayList newValue = new ArrayList((List)evt.getNewValue());
            Decorator decorator = ObserveContext.get().getDecorator(this.entityClass);
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            UIHelper.filterReferentielList(newValue, decorator);
            this.comboBox.setData(newValue);
        }
    }

    protected static class EntityListPropertyChangeListener<E extends TopiaEntity>
    implements PropertyChangeListener {
        private Class<E> entityClass;
        private BeanListHeader<E> list;

        public EntityListPropertyChangeListener(Class<E> entityClass, BeanListHeader<E> list) {
            this.entityClass = entityClass;
            this.list = list;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List newValue = (List)evt.getNewValue();
            Decorator decorator = (Decorator)this.list.getClientProperty((Object)"decorator");
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            DecoratorUtils.sort((JXPathDecorator)((JXPathDecorator)decorator), (List)newValue, (int)0);
            this.list.setData(newValue);
            this.list.putClientProperty((Object)"data", (Object)newValue);
        }
    }
}

