/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.gps;

import fr.ird.observe.DBHelper;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.GPSAble;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.gps.GPSPoint;
import fr.ird.observe.gps.GPSPointInterval;
import fr.ird.observe.gps.GPSRoute;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.gps.GPSAbleTableModel;
import fr.ird.observe.ui.admin.gps.GPSActiviteTableModel;
import fr.ird.observe.ui.admin.gps.ImportGPSConfigUI;
import fr.ird.observe.ui.admin.gps.ImportGPSModel;
import fr.ird.observe.ui.admin.gps.ImportGPSUI;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.editor.MyDefaultCellEditor;
import jaxx.runtime.swing.renderer.BooleanCellRenderer;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class ImportGPSUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ImportGPSUIHandler.class);
    protected boolean wasInit;
    protected Maree openMaree;
    protected GPSRoute route;
    protected Map<Activite, GPSPoint> data;
    protected DataSource source;
    protected Decorator<Activite> dActivite;
    protected Decorator<GPSPoint> dGPSPoint;

    public ImportGPSUIHandler(ImportGPSUI ui) {
        super(ui);
    }

    @Override
    public ImportGPSUI getUi() {
        return (ImportGPSUI)super.getUi();
    }

    public void initTabUI(AdminUI ui, ImportGPSUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getPrepareAction().setText(I18n._((String)"observe.action.synchro.prepare.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        tabUI.getStartAction().setText(I18n._((String)"observe.action.synchro.apply.modifications", (Object[])new Object[0]));
        if (log.isInfoEnabled()) {
            log.info((Object)("Init extra configuration for " + tabUI.getName()));
        }
        ConfigUI configUI = (ConfigUI)ui.getStepUI(AdminStep.CONFIG);
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)configUI).add((Object)this);
        ImportGPSConfigUI extraConfig = new ImportGPSConfigUI((JAXXContext)tx);
        extraConfig.getImportGPSMaxDelay().init();
        extraConfig.getImportGPSMaxSpeed().init();
        configUI.getExtraConfig().add((Component)((Object)extraConfig));
        DefaultListCellRenderer listRenderer = new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                comp.setToolTipText(comp.getText());
                return comp;
            }
        };
        tabUI.getInvalidIntervalsList().setCellRenderer(listRenderer);
        final JTable table2 = tabUI.getActivites();
        table2.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)0, (int)20);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)2, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)3, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)4, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)5, (int)75);
        UIHelper.setI18nTableHeaderRenderer((JTable)table2, (String[])new String[]{I18n.n_((String)"observe.synchro.table.importGPS.activite.select", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.select.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.label", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.label.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.quadrant", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.quadrant.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.latitude", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.latitude.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.longitude", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.longitude.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.vitesse", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.activite.vitesse.tip", (Object[])new Object[0])});
        DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer();
        tabUI.setContextValue(renderer2, "defaultTableRenderer");
        DefaultTableCellRenderer renderer3 = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String text;
                int modelColumn = table.convertColumnIndexToModel(column);
                int modelRow = table.convertRowIndexToModel(row);
                Object o = table.getModel().getValueAt(modelRow, modelColumn);
                String text2 = text = ((GPSActiviteTableModel)table.getModel()).getTextValueAt(modelRow, modelColumn);
                if (o == null) {
                    text2 = I18n._((String)"observe.common.undefined.tip", (Object[])new Object[0]);
                }
                JComponent c = (JComponent)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                String tip = null;
                switch (modelColumn) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        tip = I18n._((String)"observe.common.activite", (Object[])new Object[0]) + " : " + text;
                        break;
                    }
                    case 2: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.quadrant.tip", (Object[])new Object[0]) + " : " + text2;
                        break;
                    }
                    case 3: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.latitude.tip", (Object[])new Object[0]) + " : " + text2;
                        break;
                    }
                    case 4: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.longitude.tip", (Object[])new Object[0]) + " : " + text2;
                        break;
                    }
                    case 5: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.vitesse.tip", (Object[])new Object[0]) + " : " + text2;
                    }
                }
                c.setToolTipText(tip);
                return c;
            }
        };
        UIHelper.setTableColumnRenderer((JTable)table2, (int)0, (TableCellRenderer)new BooleanCellRenderer((TableCellRenderer)renderer2));
        UIHelper.setTableColumnRenderer((JTable)table2, (int)1, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnRenderer((JTable)table2, (int)2, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnRenderer((JTable)table2, (int)3, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnRenderer((JTable)table2, (int)4, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnRenderer((JTable)table2, (int)5, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnEditor((JTable)table2, (int)0, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor((boolean)false));
        table2.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colIndex = table2.getTableHeader().columnAtPoint(e.getPoint());
                if ((colIndex = table2.convertColumnIndexToModel(colIndex)) == 0) {
                    GPSActiviteTableModel model;
                    boolean oldValue = (model = (GPSActiviteTableModel)table2.getModel()).isSelectAll();
                    model.setSelectAll(!oldValue);
                }
            }
        });
        JTable table3 = tabUI.getActiviteDetail();
        UIHelper.setI18nTableHeaderRenderer((JTable)table3, (String[])new String[]{I18n.n_((String)"observe.synchro.table.importGPS.data.label", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.data.label.tip", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.computed.label", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.table.importGPS.computed.label.tip", (Object[])new Object[0])});
        DefaultTableCellRenderer renderer4 = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String text;
                int modelColumn = table.convertColumnIndexToModel(column);
                int modelRow = table.convertRowIndexToModel(row);
                GPSAbleTableModel model = (GPSAbleTableModel)table.getModel();
                Object o = model.getValueAt(modelRow, modelColumn);
                String text2 = text = model.getTextValueAt(modelRow, modelColumn);
                if (o == null) {
                    text2 = I18n._((String)"observe.common.undefined.tip", (Object[])new Object[0]);
                }
                JComponent c = (JComponent)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                String tip = null;
                switch (modelRow) {
                    case 0: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.quadrant.tip", (Object[])new Object[0]) + " : " + text2;
                        break;
                    }
                    case 1: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.latitude.tip", (Object[])new Object[0]) + " : " + text2;
                        break;
                    }
                    case 2: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.longitude.tip", (Object[])new Object[0]) + " : " + text2;
                    }
                }
                c.setToolTipText(tip);
                return c;
            }
        };
        UIHelper.setTableColumnRenderer((JTable)table3, (int)0, (TableCellRenderer)renderer4);
        UIHelper.setTableColumnRenderer((JTable)table3, (int)1, (TableCellRenderer)renderer4);
    }

    public void updateState(ImportGPSUI tabUI, WizardState newState) {
        super.updateState(tabUI, newState);
        if (newState == WizardState.NEED_FIX) {
            GPSRoute route = this.getRoute();
            tabUI.invalidIntervalsModel.removeAllElements();
            if (route.getRejectedInterval().isEmpty()) {
                tabUI.invalidIntervalsModel.addElement(I18n._((String)"observe.message.importGPS.no.invalid.interval", (Object[])new Object[0]));
            } else {
                for (GPSPointInterval i : route.getRejectedInterval()) {
                    tabUI.invalidIntervalsModel.addElement(i);
                }
            }
            tabUI.activitesModel.init(this.getData());
            if (tabUI.activitesModel.getRowCount() > 0) {
                tabUI.activitesSelectionModel.setSelectionInterval(0, 0);
            }
            tabUI.split.resetToPreferredSizes();
            return;
        }
        if (newState == WizardState.RUNNING) {
            // empty if block
        }
    }

    public void updateDetail() {
        ImportGPSUI tabUI = this.getUi();
        DefaultListSelectionModel selectionModel = tabUI.activitesSelectionModel;
        int row = selectionModel.getAnchorSelectionIndex();
        if (log.isDebugEnabled()) {
            log.debug((Object)("row : " + row));
        }
        GPSAbleTableModel tableModel = tabUI.activiteDetailModel;
        if (row == -1) {
            tableModel.clear();
        } else {
            GPSActiviteTableModel activiteTableModel = tabUI.activitesModel;
            tableModel.init(new GPSAble[]{activiteTableModel.getActiviteAt(row), activiteTableModel.getGPSPointAt(row)});
        }
    }

    public void doPrepareAction() {
        ImportGPSUI tabUI = this.getUi();
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getPrepareAction().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return ImportGPSUIHandler.this.prepareAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public void doStartAction() {
        ImportGPSUI tabUI = this.getUi();
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getStartAction().getToolTipText();
        int[] rows = tabUI.getActivitesModel().getSelected();
        tabUI.getStepModel().setImportGPSSelectedIndex(rows);
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return ImportGPSUIHandler.this.doAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public WizardState prepareAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        DecoratorService dService = this.getDecoratorService();
        this.dActivite = dService.getDecorator(Activite.class, "activite-gps");
        this.dGPSPoint = dService.getDecorator(GPSPoint.class, "gpsPoint-gps");
        this.source = this.model.getSafeLocalSource(false);
        this.openSource(this.source);
        TopiaContext srcCtxt = this.beginTransaction(this.source, "beforeAction");
        try {
            this.openMaree = DBHelper.getOpenMaree((TopiaContext)srcCtxt);
        }
        catch (TopiaException e) {
            this.closeTransaction(this.source, srcCtxt, "beforeAction");
        }
        if (this.openMaree == null) {
            this.sendMessage(I18n._((String)"observe.message.no.open.maree.detected", (Object[])new Object[0]));
            return WizardState.FAILED;
        }
        if (this.openMaree.isRouteEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.no.route.detected", (Object[])new Object[0]));
            return WizardState.FAILED;
        }
        for (Route r : this.openMaree.getRoute()) {
            if (r.isActiviteEmpty()) continue;
            for (Activite a : r.getActivite()) {
                this.data.put(a, null);
            }
        }
        if (this.data.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.no.activite.detected", (Object[])new Object[0]));
            return WizardState.FAILED;
        }
        ImportGPSModel gpsModel = this.model.getImportGPSModel();
        this.sendMessage(I18n._((String)"observe.message.importGPS.prepare.importFile", (Object[])new Object[]{gpsModel.getImportGPSFile(), gpsModel.getImportGPSMaxDelay(), gpsModel.getImportGPSMaxSpeed()}));
        this.route = this.getGpsService().buildRoute(gpsModel.getImportGPSFile(), gpsModel.getImportGPSMaxDelay().intValue(), gpsModel.getImportGPSMaxSpeed().floatValue());
        List acceptedInterval = this.route.getAcceptedInterval();
        if (acceptedInterval == null || acceptedInterval.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.no.accepted.intervalle.detected", (Object[])new Object[0]));
            return WizardState.FAILED;
        }
        for (GPSPointInterval i : acceptedInterval) {
            this.sendMessage(I18n._((String)"observe.message.detected.accepted.interval", (Object[])new Object[]{i}));
        }
        for (GPSPointInterval i : this.route.getRejectedInterval()) {
            this.sendMessage(I18n._((String)"observe.message.detected.rejected.interval", (Object[])new Object[]{i}));
        }
        this.sendMessage(I18n._((String)"observe.message.importGPS.detect.points", (Object[])new Object[0]));
        this.detectPoints();
        if (this.data.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.importGPS.nothing.to.do", (Object[])new Object[0]));
            this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
            return WizardState.SUCCESSED;
        }
        this.sendMessage(I18n._((String)"observe.message.importGPS.operation.needFix", (Object[])new Object[]{new Date()}));
        return WizardState.NEED_FIX;
    }

    public WizardState doAction() throws Exception {
        this.sendMessage(I18n._((String)"observe.message.importGPS.apply.points", (Object[])new Object[0]));
        ImportGPSModel importModel = this.model.getImportGPSModel();
        if (importModel.getImportGPSSelectedIndex() == null || importModel.getImportGPSSelectedIndex().length == 0) {
            this.sendMessage(I18n._((String)"observe.message.importGPS.nothing.to.do", (Object[])new Object[0]));
            this.sendMessage(I18n._((String)"observe.message.importGPS.no.activite.selected", (Object[])new Object[0]));
        } else {
            this.applyPoints();
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    public Map<Activite, GPSPoint> getData() {
        return this.data;
    }

    public GPSRoute getRoute() {
        return this.route;
    }

    protected void detectPoints() {
        HashSet<Activite> rejected = new HashSet<Activite>();
        for (Activite a : this.data.keySet()) {
            Date heureObservation = a.getHeureObservation();
            this.sendMessage(I18n._((String)"observe.message.importGPS.detect.point", (Object[])new Object[]{this.dActivite.toString((Object)a)}));
            GPSPoint point = this.route.getPoint(heureObservation);
            if (point == null) {
                this.sendMessage(I18n._((String)"observe.message.importGPS.no.detected.point", (Object[])new Object[0]));
                rejected.add(a);
                continue;
            }
            this.sendMessage(I18n._((String)"observe.message.importGPS.detected.point", (Object[])new Object[]{this.dGPSPoint.toString((Object)point)}));
            this.data.put(a, point);
        }
        for (Activite a : rejected) {
            this.data.remove(a);
        }
    }

    protected void applyPoints() throws Exception {
        int[] selectedIndex = this.model.getImportGPSModel().getImportGPSSelectedIndex();
        ArrayIntList lIndex = new ArrayIntList(selectedIndex.length);
        String txName = "applyPoints";
        TopiaContext ctxt = this.beginTransaction(this.source, txName);
        try {
            for (int i : selectedIndex) {
                lIndex.add(i);
            }
            IntIterator indexItr = lIndex.iterator();
            int currentActiviteIndex = 0;
            int nextActiviteIndex = indexItr.next();
            TopiaDAO activiteDAO = this.source.getDAO(ctxt, Activite.class);
            for (Activite a : this.data.keySet()) {
                if (currentActiviteIndex == nextActiviteIndex) {
                    GPSPoint p = this.data.get(a);
                    this.sendMessage(I18n._((String)"observe.message.importGPS.apply.point", (Object[])new Object[]{this.dGPSPoint.toString((Object)p), this.dActivite.toString((Object)a)}));
                    float latitude = Math.abs(p.getLatitude().floatValue());
                    float longitude = Math.abs(p.getLongitude().floatValue());
                    int quadrant = p.getQuadrant();
                    Activite aa = (Activite)activiteDAO.findByTopiaId(a.getTopiaId());
                    aa.setLatitude(Float.valueOf(latitude));
                    aa.setLongitude(Float.valueOf(longitude));
                    aa.setQuadrant(Integer.valueOf(quadrant));
                    activiteDAO.update((TopiaEntity)aa);
                    if (!indexItr.hasNext()) break;
                    nextActiviteIndex = indexItr.next();
                }
                ++currentActiviteIndex;
            }
            this.commitTransaction(this.source, ctxt, txName);
        }
        catch (Exception e) {
            this.rollbackTransaction(this.source, ctxt, txName);
            throw e;
        }
        finally {
            this.closeTransaction(this.source, ctxt, txName);
            lIndex.clear();
        }
    }

    public void chooseImportGPSFile() {
        ImportGPSModel gpsModel = this.getModel().getImportGPSModel();
        File f = UIHelper.chooseFile(this.ui, I18n._((String)"observe.title.choose.importGPS", (Object[])new Object[0]), I18n._((String)"observe.action.choose.importGPS", (Object[])new Object[0]), gpsModel.getImportGPSFile(), "^.+\\.gpx$", I18n._((String)"observe.action.choose.importGPS.description", (Object[])new Object[0]));
        gpsModel.setImportGPSFile(f);
    }
}

