/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree.loadors;

import fr.ird.observe.DBHelper;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.ui.tree.loadors.AbstractNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ProgrammeNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ReferentielNodeChildLoador;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.nuiton.i18n.I18n;

public class RootNodeChildLoador
extends AbstractNodeChildLoador<Programme> {
    private static final long serialVersionUID = 1L;
    protected boolean addData;
    protected boolean addReferentiel;

    public RootNodeChildLoador() {
        super(Programme.class);
    }

    public RootNodeChildLoador(boolean addData, boolean addReferentiel) {
        this();
        this.addData = addData;
        this.addReferentiel = addReferentiel;
    }

    public void setAddData(boolean addData) {
        this.addData = addData;
    }

    public void setAddReferentiel(boolean addReferentiel) {
        this.addReferentiel = addReferentiel;
    }

    public List<Programme> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        List data;
        DataSource dataSource = this.getDataSource(dataProvider);
        DataService service = this.getDataService();
        DataSelectionModel selectionModel = this.getSelectionModel(dataProvider);
        if (this.addData) {
            if (selectionModel != null) {
                data = new ArrayList<Programme>();
                for (String programmeId : selectionModel.getDatas().keySet()) {
                    data.add((Programme)service.loadEntity(dataSource, programmeId, true));
                }
            } else {
                data = service.loadDecoratedEntities(dataSource, this.getBeanType());
            }
            DBHelper.sortProgrammes((List)data);
        } else {
            data = Collections.emptyList();
        }
        return data;
    }

    public void addChildNodes(ObserveNode parentNode, List<Programme> datas, NavDataProvider dataProvider) {
        super.addChildNodes((NavNode)parentNode, datas, dataProvider);
        if (this.addReferentiel) {
            ObserveNode child = new ObserveNode(String.class, I18n.n_((String)"observe.common.referentiel", (Object[])new Object[0]), (NavTreeNodeChildLoador)ObserveTreeHelper.getChildLoador(ReferentielNodeChildLoador.class), true);
            parentNode.add(child);
        }
    }

    public ObserveNode createNode(Programme data, NavDataProvider dataProvider) {
        ObserveNode result = new ObserveNode(this.getBeanType(), data.getTopiaId(), (NavTreeNodeChildLoador)ObserveTreeHelper.getChildLoador(ProgrammeNodeChildLoador.class), false);
        return result;
    }
}

