/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.referentiel.ActiviteBateau;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.ActiviteUI;
import java.util.Date;
import java.util.List;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;
import org.nuiton.validator.NuitonValidatorScope;

public class ActiviteUIHandler
extends ContentOpenableUIHandler<Activite> {
    private static Log log = LogFactory.getLog(ActiviteUIHandler.class);

    public ActiviteUIHandler(ActiviteUI ui) {
        super(ui, DataContextType.Route, DataContextType.Activite, I18n.n_((String)"observe.message.activite.not.open", (Object[])new Object[0]));
    }

    @Override
    public ActiviteUI getUi() {
        return (ActiviteUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Activite> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Activite.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Activite.class, new String[]{"quadrant", "latitude", "longitude", "heureObservation", "temperatureSurface", "causeNonCoupSenne", "commentaire", "vitesseBateau", "systemeObserve", "distanceSystemeObserve", "activiteBateau", "activiteEnvironnante", "ventBeaufort", "modeDetection", "calee", "objetFlottant", "open", "latitudeAsDegre", "latitudeAsMinute", "latitudeAsSeconde", "longitudeAsDegre", "longitudeAsMinute", "longitudeAsSeconde", "useSexagecimalFormat"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"systemeObserve"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"objetFlottant"});
            r = binderService.registerTopiaBinder(Activite.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String activiteId = this.getSelectedId();
        if (activiteId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Activite.class)) {
            return ContentMode.UPDATE;
        }
        ActiviteUI ui = this.getUi();
        if (!dataContext.isSelectedOpen(Route.class)) {
            ActiviteUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.route.not.open", (Object[])new Object[0]));
        } else if (!dataContext.isSelectedOpen(Maree.class)) {
            ActiviteUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)this.getModel()).isHistoricalData()) {
                this.addInfoMessage(I18n._((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        } else {
            this.addInfoMessage(I18n._((String)this.closeMessage, (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String routeId = this.getSelectedParentId();
        String activiteId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "routeId    = " + routeId));
            log.info((Object)(this.prefix + "activiteId = " + activiteId));
        }
        ContentMode mode = this.computeContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "content mode " + (Object)((Object)mode)));
        }
        Activite bean = (Activite)this.getBean();
        bean.setUseSexagecimalFormat(false);
        DataService dataService = this.getDataService();
        boolean create = activiteId == null;
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (create) {
            dataService.preCreate(source, routeId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, activiteId, this.getLoadExecutor());
            bean.initCoordonnees();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("           long  - lat  = " + bean.getLongitude() + " - " + bean.getLatitude()));
            log.info((Object)("quadrant - along - alat = " + bean.getQuadrant() + " - " + bean.getAbsoluteLongitude() + " - " + bean.getAbsoluteLatitude()));
        }
        this.finalizeOpenUI(mode, create);
        bean.setUseSexagecimalFormat(true);
        this.getModel().setModified(create);
    }

    @Override
    protected Activite onPreCreate(TopiaContext tx, Object parent, Activite bean) throws TopiaException {
        Route parentBean = (Route)parent;
        Date d = DBHelper.getCurrentHour((Date)parentBean.getJourObservation());
        bean.setHeureObservation(d);
        bean.setOpen(true);
        Activite lastActivite = parentBean.getLastActivite();
        if (lastActivite != null) {
            lastActivite.initCoordonnees();
            Integer quadrant = lastActivite.getQuadrant();
            if (quadrant != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use quadrant of previous activite [" + quadrant + "]"));
                }
                bean.setQuadrant(quadrant);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("has pre-created :  " + bean));
        }
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        ActiviteUI ui = this.getUi();
        ui.getQuadrantBG().clearSelection();
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        ui.getValidator().setContext(contextName);
        if (create) {
            ActiviteUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.creating.activite", (Object[])new Object[0]));
        } else {
            ActiviteUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.updating.activite", (Object[])new Object[0]));
        }
        super.startEditUI("heureObservation.date", "longitudeDecimal.model", "longitudeAsDegre.model", "longitudeAsMinute.model", "latitudeDecimal.model", "latitudeAsMinute.model", "latitudeAsDegre.model", "quadrant1.selected", "quadrant2.selected", "quadrant3.selected", "quadrant4.selected", "vitesseBateau.model", "temperatureSurface.model", "commentaire2.text", "activiteBateau.selectedItem", "activiteEnvironnante.selectedItem", "ventBeaufort.selectedItem", "close.enabled", "closeAndCreate.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(Activite bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Activite> binder) throws Exception {
        boolean sexagecimalFormat = bean.isUseSexagecimalFormat();
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(false);
        }
        bean.storeCoordonnees();
        if (log.isInfoEnabled()) {
            log.info((Object)("           long  - lat = " + bean.getLongitude() + " - " + bean.getLatitude()));
            log.info((Object)("quadrant - along - alat = " + bean.getQuadrant() + " - " + bean.getAbsoluteLongitude() + " - " + bean.getAbsoluteLatitude()));
        }
        boolean create = bean.getTopiaId() == null;
        String routeId = this.getSelectedParentId();
        bean.setOpen(true);
        if (create) {
            bean = (Activite)dataService.create(dataSource, routeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, routeId, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(true);
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected Activite onCreate(TopiaContext tx, Object parent, Activite editBean) throws TopiaException {
        Route parentBean = (Route)parent;
        Activite beanToSave = (Activite)ObserveDAOHelper.getActiviteDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addActivite(beanToSave);
        return beanToSave;
    }

    @Override
    protected Activite onUpdate(TopiaContext tx, Object parentBean, Activite beanToSave) throws TopiaException {
        Activite editBean = (Activite)this.getBean();
        Route route = (Route)parentBean;
        Date d = DBHelper.getDateAndTime((Date)route.getJourObservation(), (Date)editBean.getHeureObservation());
        editBean.setHeureObservation(d);
        if (log.isInfoEnabled()) {
            log.info((Object)("Final time to use : " + d));
        }
        this.getLoadBinder().copyExcluding((Object)editBean, (Object)beanToSave, new String[]{"objetFlottant", "systemeObserve"});
        if (log.isInfoEnabled()) {
            log.info((Object)("Is activite open ? : " + beanToSave.isOpen()));
        }
        return beanToSave;
    }

    @Override
    protected boolean doDelete(Activite bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, Activite> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        String routeId = this.getSelectedParentId();
        dataService.delete(dataSource, routeId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, Activite beanToDelete) {
        Route parentBean = (Route)parent;
        parentBean.removeActivite(beanToDelete);
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        boolean canReopen = !create && dataContext.isSelectedOpen(Route.class) && !dataContext.isOpenActivite();
        return canReopen;
    }

    public String getActivite6Label() {
        try {
            List activites = this.getDataService().getList(this.getDataSource(), ActiviteBateau.class);
            for (ActiviteBateau a : activites) {
                if (a.getCode() != 6) continue;
                String label = this.getDecoratorService().decorate((Object)a);
                return label;
            }
        }
        catch (DataSourceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        throw new IllegalStateException(I18n._((String)"observe.error.no.activite.6", (Object[])new Object[0]));
    }
}

