/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.impl.CaleeUI;
import fr.ird.observe.ui.content.impl.ObjetFlottantUI;
import fr.ird.observe.ui.content.impl.OperationBaliseUI;
import fr.ird.observe.ui.content.impl.SystemeObserveUI;
import fr.ird.observe.ui.content.list.impl.ActivitesUI;
import fr.ird.observe.ui.content.list.impl.MareesUI;
import fr.ird.observe.ui.content.list.impl.RoutesUI;
import fr.ird.observe.ui.content.open.impl.ActiviteUI;
import fr.ird.observe.ui.content.open.impl.MareeUI;
import fr.ird.observe.ui.content.open.impl.RouteUI;
import fr.ird.observe.ui.content.ref.ContentReferentielUI;
import fr.ird.observe.ui.content.ref.ReferentielHomeUI;
import fr.ird.observe.ui.content.table.impl.CaptureFauneUI;
import fr.ird.observe.ui.content.table.impl.CaptureThonUI;
import fr.ird.observe.ui.content.table.impl.EchantillonFauneUI;
import fr.ird.observe.ui.content.table.impl.EchantillonThonCaptureUI;
import fr.ird.observe.ui.content.table.impl.EchantillonThonRejeteUI;
import fr.ird.observe.ui.content.table.impl.EspeceFauneObserveeUI;
import fr.ird.observe.ui.content.table.impl.EstimationBancObjetUI;
import fr.ird.observe.ui.content.table.impl.EstimationBancUI;
import fr.ird.observe.ui.content.table.impl.RejetThonUI;
import fr.ird.observe.ui.tree.ObserveNode;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ContentUIManager {
    public static final String REFERENTIEL = "referentiel";
    public static final String DATA = "data";
    private static final Log log = LogFactory.getLog(ContentUIManager.class);
    protected final ObserveMainUI ui;
    protected final Map<String, Class<? extends ContentUI<?>>> mapping;

    public ContentUIManager(ObserveMainUI ui) {
        this.ui = ui;
        this.mapping = new TreeMap();
        for (ObserveEntityEnum anEnum : DBHelper.REFERENTIEL_ENTITIES_LIST) {
            Class editType = anEnum.getContract();
            String fqn = ContentReferentielUI.class.getPackage().getName() + ".impl.Referentiel" + editType.getSimpleName() + "UI";
            try {
                Class<?> result = Class.forName(fqn);
                this.addMapping(REFERENTIEL, editType, null, result);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find " + fqn);
            }
        }
        this.addMapping(REFERENTIEL, null, ReferentielHomeUI.class);
        this.addMapping(DATA, Programme.class, MareesUI.class);
        this.addMapping(DATA, Maree.class, MareeUI.class);
        this.addMapping(DATA, Maree.class, I18n.n_((String)"observe.common.maree.unsaved", (Object[])new Object[0]), MareeUI.class);
        this.addMapping(DATA, Maree.class, "route", RoutesUI.class);
        this.addMapping(DATA, Route.class, RouteUI.class);
        this.addMapping(DATA, Route.class, I18n.n_((String)"observe.common.route.unsaved", (Object[])new Object[0]), RouteUI.class);
        this.addMapping(DATA, Route.class, "activite", ActivitesUI.class);
        this.addMapping(DATA, Activite.class, ActiviteUI.class);
        this.addMapping(DATA, Activite.class, I18n.n_((String)"observe.common.activite.unsaved", (Object[])new Object[0]), ActiviteUI.class);
        this.addMapping(DATA, Activite.class, "systemeObserve", SystemeObserveUI.class);
        this.addMapping(DATA, Calee.class, CaleeUI.class);
        this.addMapping(DATA, Calee.class, I18n.n_((String)"observe.common.calee.unsaved", (Object[])new Object[0]), CaleeUI.class);
        this.addMapping(DATA, Calee.class, "estimationBanc", EstimationBancUI.class);
        this.addMapping(DATA, Calee.class, "captureThon", CaptureThonUI.class);
        this.addMapping(DATA, Calee.class, "rejetThon", RejetThonUI.class);
        this.addMapping(DATA, Calee.class, "echantillonThon", EchantillonThonRejeteUI.class);
        this.addMapping(DATA, Calee.class, "echantillonThonCapture", EchantillonThonCaptureUI.class);
        this.addMapping(DATA, Calee.class, "captureFaune", CaptureFauneUI.class);
        this.addMapping(DATA, Calee.class, "echantillonFaune", EchantillonFauneUI.class);
        this.addMapping(DATA, ObjetFlottant.class, ObjetFlottantUI.class);
        this.addMapping(DATA, ObjetFlottant.class, I18n.n_((String)"observe.common.objetFlottant.unsaved", (Object[])new Object[0]), ObjetFlottantUI.class);
        this.addMapping(DATA, ObjetFlottant.class, "operation", OperationBaliseUI.class);
        this.addMapping(DATA, ObjetFlottant.class, "especeFauneObservee", EspeceFauneObserveeUI.class);
        this.addMapping(DATA, ObjetFlottant.class, "estimationBancObjet", EstimationBancObjetUI.class);
    }

    public Class<? extends ContentUI<?>> convertNodeToContentUI(ObserveNode node) {
        String mappingKey;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entrer for node = " + (Object)((Object)node)));
        }
        if (node.isRoot()) {
            return null;
        }
        Class editType = node.getInternalClass();
        String prefix = node.isReferentielNode() ? REFERENTIEL : DATA;
        String context = node.getContext();
        if (node.isReferentielNode()) {
            if (String.class.equals((Object)editType)) {
                editType = null;
            }
        } else if (String.class.equals((Object)editType)) {
            editType = ((ObserveNode)node.getContainerNode()).getInternalClass();
        }
        if ((mappingKey = this.getMappingKey(prefix, editType, context)) == null) {
            throw new NullPointerException("Could not find mappingKey for node " + (Object)((Object)node));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("mappingKey = [" + mappingKey + "] for node " + (Object)((Object)node)));
        }
        Class<? extends ContentUI<?>> result = this.mapping.get(mappingKey);
        return result;
    }

    public <U extends ContentUI<?>> U getContent(Class<U> uiClass) {
        CardLayout2 layout = this.getLayout();
        JPanel layoutContent = this.getLayoutContent();
        String constraints = uiClass.getName();
        if (!layout.contains((Serializable)((Object)constraints))) {
            return null;
        }
        ContentUI content = (ContentUI)((Object)layout.getComponent((Container)layoutContent, constraints));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use existing content [" + constraints + "] : " + ((Object)((Object)content)).getClass().getName()));
        }
        return (U)((Object)content);
    }

    public <U extends ContentUI<?>> U createContent(Class<U> uiClass) {
        ContentUI result;
        String constraints = uiClass.getName();
        if (this.getLayout().contains((Serializable)((Object)constraints))) {
            throw new IllegalStateException("Already existing constrainst [" + constraints + "]");
        }
        try {
            Constructor<U> constructor = uiClass.getConstructor(JAXXContext.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("create new content : " + uiClass + " from ui " + this.ui.getClass().getName()));
            }
            result = (ContentUI)((Object)constructor.newInstance(new JAXXInitialContext().add((Object)this.ui)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create content ui " + uiClass, e);
        }
        try {
            this.getLayoutContent().add((Component)((Object)result), constraints);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add new content [" + constraints + "] : " + ((Object)((Object)result)).getClass().getName()));
            }
            result.init();
            return (U)((Object)result);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init content ui " + uiClass, e);
        }
    }

    public ContentUI<?> getCurrentContent() {
        ContentUI component = (ContentUI)((Object)this.getLayout().getVisibleComponent((Container)this.getLayoutContent()));
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openContent(ContentUI<?> content) {
        String constraints = ((Object)content).getClass().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will open ui [" + constraints + "] : " + ((Object)content).getClass()));
        }
        try {
            content.open();
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
        }
        finally {
            this.getLayout().show((Container)this.getLayoutContent(), constraints);
        }
    }

    public void close() {
        this.getLayout().reset((Container)this.getLayoutContent());
    }

    protected JPanel getLayoutContent() {
        JPanel content = this.ui.getContent();
        return content;
    }

    protected CardLayout2 getLayout() {
        CardLayout2 layout = this.ui.getContentLayout();
        return layout;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    protected void addMapping(String prefix, Class<?> klass, Class<? extends ContentUI<?>> contentClass) {
        this.addMapping(prefix, klass, null, contentClass);
    }

    protected void addMapping(String prefix, Class<?> klass, String context, Class<?> contentClass) {
        String key = this.getMappingKey(prefix, klass, context);
        this.mapping.put(key, contentClass);
    }

    protected String getMappingKey(String prefix, Class<?> klass, String context) {
        String key = prefix + ".";
        if (klass != null) {
            key = key + klass.getName();
        }
        if (context != null) {
            if (klass != null) {
                key = key + "#";
            }
            key = key + context;
        }
        return key;
    }
}

