/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.access.AccessUI;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.resume.ShowResumeUI;
import fr.ird.observe.ui.admin.save.SaveLocalUI;
import java.awt.Component;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.wizard.WizardUILancher;
import jaxx.runtime.swing.wizard.ext.WizardExtUtil;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;

public class AdminUIHandler {
    private static final Log log = LogFactory.getLog(AdminUIHandler.class);

    public AdminStep getSelectedStep(AdminUI ui) {
        int index = ui.getTabs().getSelectedIndex();
        AdminTabUI c = null;
        if (index > -1) {
            c = (AdminTabUI)ui.getTabs().getComponentAt(index);
        }
        AdminStep result = c == null ? null : c.getStep();
        return result;
    }

    public AdminTabUI getStepUI(AdminUI ui, AdminStep step) {
        if (step != null) {
            return (AdminTabUI)ui.getObjectById(step.name());
        }
        return null;
    }

    public AdminTabUI getStepUI(AdminUI ui, int stepIndex) {
        if (stepIndex > ui.getTabs().getTabCount()) {
            return null;
        }
        return (AdminTabUI)ui.getTabs().getComponentAt(stepIndex);
    }

    public AdminTabUI getSelectedStepUI(AdminUI ui) {
        AdminStep step = this.getSelectedStep(ui);
        AdminTabUI tabUI = this.getStepUI(ui, step);
        return tabUI;
    }

    public void blockOperations(AdminUI ui) {
        ui.getModel().setValueAdjusting(true);
        for (AdminStep op : AdminStep.values()) {
            ConfigUI configUI = (ConfigUI)ui.getStepUI(AdminStep.CONFIG);
            JCheckBox comp = (JCheckBox)configUI.getObjectById(op.name());
            if (comp == null || ui.getModel().getOperations().contains((Object)op)) continue;
            comp.setVisible(false);
        }
        ui.operationBlockLayerUI.setBlock(true);
        ui.getModel().setValueAdjusting(false);
    }

    public void onWasInit(AdminUI ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(ui.getName() + " model was init at " + new Date()));
        }
    }

    public void onWasStarted(AdminUI ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(ui.getName() + " model was started at " + new Date()));
        }
    }

    public void onStepsChanged(AdminUI ui, AdminStep[] steps) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use these steps : " + Arrays.toString((Object[])steps)));
        }
        ui.getModel().setValueAdjusting(true);
        while (ui.tabs.getTabCount() > 1) {
            int index = ui.tabs.getTabCount() - 1;
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove step : " + index));
            }
            ui.tabs.remove(index);
        }
        int max = steps.length;
        for (int i = 0; i < max; ++i) {
            AdminStep step = steps[i];
            AdminTabUI c = ui.getStepUI(step);
            if (log.isDebugEnabled()) {
                log.debug((Object)("StepUI [" + (Object)((Object)step) + "] : " + c));
            }
            if (c == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will init step [" + (Object)((Object)step) + "]"));
                }
                c = step.newUI(ui);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created tabUI [" + c.getName() + "]"));
                }
                ui.get$objectMap().put(step.name(), c);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will init tabUI [" + c.getName() + "]"));
                }
                c.initUI(ui);
                JPanel content = c.getContent();
                UIHelper.getLayer((JComponent)content).setUI((LayerUI)ui.getBusyBlockLayerUI());
            }
            String title = I18n._((String)step.getLabel(), (Object[])new Object[0]);
            String tip = I18n._((String)step.getDescription(), (Object[])new Object[0]);
            ui.tabs.addTab(title, null, c, tip);
            c.setEnabled(i == 0);
        }
        ui.getModel().setValueAdjusting(false);
    }

    public void onStepChanged(AdminUI ui, AdminStep newStep) {
        int index;
        AdminTabUI saveUI;
        AdminTabUI c;
        if (log.isTraceEnabled()) {
            log.trace((Object)newStep);
        }
        if ((c = ui.getStepUI(newStep)) != null && c.getStep() == AdminStep.SAVE_LOCAL) {
            saveUI = (SaveLocalUI)ui.getStepUI(AdminStep.SAVE_LOCAL);
            ((SaveLocalUI)saveUI).getHandler().updateText();
        }
        if (c != null && c.getStep() == AdminStep.SHOW_RESUME) {
            ShowResumeUI showResumeUI = (ShowResumeUI)ui.getStepUI(AdminStep.SHOW_RESUME);
            showResumeUI.getHandler().updateText();
        }
        if (c != null && c.getStep() == AdminStep.ACCESS) {
            saveUI = (AccessUI)ui.getStepUI(AdminStep.ACCESS);
            ((AccessUI)saveUI).getHandler().updateProgrammesAndOceans((AccessUI)saveUI);
        }
        if ((index = ui.tabs.indexOfComponent(c)) > -1 && ui.tabs.getSelectedIndex() != index) {
            ui.tabs.setSelectedIndex(index);
        }
    }

    public void onModelStateChanged(AdminUI ui, WizardState newState) {
        if (log.isDebugEnabled()) {
            log.debug((Object)newState);
        }
        AdminTabUI selected = ui.getSelectedStepUI();
        boolean busy = WizardExtUtil.acceptStates((WizardState)newState, (WizardState[])new WizardState[]{WizardState.RUNNING});
        SwingUtil.TabbedPaneIterator itr = UIHelper.newTabbedPaneIterator((JTabbedPane)ui.getTabs());
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Busy state, can only access selected step : " + selected));
            }
            while (itr.hasNext()) {
                Component tab = (Component)itr.next();
                ui.tabs.setEnabledAt(itr.getIndex() - 1, tab.equals(selected));
            }
            return;
        }
        if (selected != null && selected.getStep().isConfig()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Selected step is config : " + (Object)((Object)selected.getStep())));
            }
            while (itr.hasNext()) {
                boolean valid;
                int index = itr.getIndex();
                Component tab = (Component)itr.next();
                AdminTabUI tabUI = (AdminTabUI)tab;
                AdminStep synchroStep = tabUI.getStep();
                if (!synchroStep.isConfig()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Test config panel : " + (Object)((Object)synchroStep)));
                }
                if (valid = ui.getModel().validate(synchroStep)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("step " + (Object)((Object)synchroStep) + " is valid"));
                    }
                    ui.tabs.setIconAt(index, this.getTabIcon(WizardState.SUCCESSED));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("step " + (Object)((Object)synchroStep) + " is not valid!"));
                }
                ui.tabs.setIconAt(index, this.getTabIcon(WizardState.FAILED));
            }
            itr = UIHelper.newTabbedPaneIterator((JTabbedPane)ui.getTabs());
        }
        if (selected != null && selected.getStep() == AdminStep.SHOW_RESUME) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"We are on last step (resume), nothing to do.");
            }
            return;
        }
        boolean[] accessibleSteps = ui.getModel().getAccessibleSteps();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accessibles step : " + Arrays.toString(accessibleSteps)));
        }
        while (itr.hasNext()) {
            int index = itr.getIndex();
            ui.tabs.setEnabledAt(index, accessibleSteps[index]);
            itr.next();
        }
        if (!ui.getModel().containsOperation(AdminStep.REPORT)) {
            ui.tabs.setEnabledAt(accessibleSteps.length - 1, true);
        }
    }

    public void onOperationStateChanged(AdminUI ui, AdminStep step, WizardState newState) {
        AdminTabUI selected;
        int index;
        if (log.isDebugEnabled()) {
            log.debug((Object)((Object)((Object)step) + " - " + newState));
        }
        if ((index = ui.tabs.indexOfComponent(selected = ui.getStepUI(step))) > -1 && !selected.getStep().isConfig()) {
            ui.tabs.setIconAt(index, this.getTabIcon(newState));
        }
        if (selected != null && step == selected.getStep()) {
            selected.updateState(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(AdminUI ui) {
        try {
            ui.getModel().start(ui);
            ui.setVisible(true);
        }
        finally {
            ui.getModel().setBusy(false);
        }
    }

    public void close(AdminUI ui) {
        Runnable action = (Runnable)WizardUILancher.APPLY_DEF.getContextValue((JAXXContext)ui);
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        executor.addAction(I18n._((String)"observe.action.admin.close", (Object[])new Object[0]), action);
    }

    public void cancel(AdminUI ui) {
        Runnable action = (Runnable)WizardUILancher.CANCEL_DEF.getContextValue((JAXXContext)ui);
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        executor.addAction(I18n._((String)"observe.action.admin.cancel", (Object[])new Object[0]), action);
    }

    public void destroy(AdminUI ui) {
        ui.getModel().destroy();
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroy ui " + ui.getName()));
        }
        SwingUtil.TabbedPaneIterator itr = UIHelper.newTabbedPaneIterator((JTabbedPane)ui.getTabs());
        while (itr.hasNext()) {
            AdminTabUI tab = (AdminTabUI)itr.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("destroy ui " + tab.getName()));
            }
            tab.destroy();
        }
        UIHelper.destroy((Component)ui);
    }

    public void dispose(AdminUI ui) {
        this.destroy(ui);
    }

    public Icon getTabIcon(WizardState state) {
        Icon i = null;
        if (state != null) {
            String key = "wizard-state-" + state.name().toLowerCase();
            i = UIHelper.getUIManagerActionIcon((String)key);
        }
        return i;
    }
}

