/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.BinderService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.SendMessageAble;
import fr.ird.observe.access.AccessImporterService;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.ReplicationService;
import fr.ird.observe.db.event.DataSourceEvent;
import fr.ird.observe.db.event.DataSourceListener;
import fr.ird.observe.db.event.DataSourceListenerAdapter;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.gps.GPSService;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIModel;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.resume.ShowResumeUI;
import fr.ird.observe.ui.tree.DataSelectionTreeSelectionModel;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.validation.ValidationService;
import java.awt.Container;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class AdminTabUIHandler
implements SendMessageAble {
    private static final Log log = LogFactory.getLog(AdminTabUIHandler.class);
    protected AdminUI parentUI;
    protected final AdminTabUI ui;
    protected final AdminUIModel model;
    private ReplicationService replicationService;
    private ValidationService validationService;
    private GPSService gpsService;
    private DecoratorService decoratorService;
    private DataService dataService;
    private BinderService binderService;
    private AccessImporterService accessImporterService;
    protected final DataSourceListener serviceLogger = new DataSourceListenerAdapter(){

        public void onNewMessage(DataSourceEvent event) {
            DataSource service = event.getSource();
            if (event.getMessageLevel() == DataSourceEvent.MessageLevel.INFO) {
                AdminTabUIHandler.this.sendMessage(service.getShortLabel() + " : " + event.getMessage());
            }
        }
    };

    public AdminTabUIHandler(AdminTabUI ui) {
        this.ui = ui;
        this.model = ui.getModel();
    }

    public AdminTabUI getUi() {
        return this.ui;
    }

    public AdminUIModel getModel() {
        return this.model;
    }

    public final ReplicationService getReplicationService() {
        if (this.replicationService == null) {
            this.replicationService = ObserveServiceHelper.newReplicationService();
        }
        return this.replicationService;
    }

    public final ValidationService getValidationService() {
        if (this.validationService == null) {
            this.validationService = ObserveServiceHelper.newValidationService();
        }
        return this.validationService;
    }

    public final DecoratorService getDecoratorService() {
        if (this.decoratorService == null) {
            this.decoratorService = ObserveContext.get().getDecoratorService();
        }
        return this.decoratorService;
    }

    public final DataService getDataService() {
        if (this.dataService == null) {
            this.dataService = ObserveContext.get().getDataService();
        }
        return this.dataService;
    }

    public final BinderService getBinderService() {
        if (this.binderService == null) {
            this.binderService = ObserveContext.get().getBinderService();
        }
        return this.binderService;
    }

    public final GPSService getGpsService() {
        if (this.gpsService == null) {
            this.gpsService = ObserveContext.get().getGPSService();
        }
        return this.gpsService;
    }

    public AccessImporterService getAccessImporterService() {
        if (this.accessImporterService == null) {
            this.accessImporterService = ObserveContext.get().getAccessImporterService();
        }
        return this.accessImporterService;
    }

    protected DataSource getSource() {
        DataSource source = this.model.getTmpSource();
        if (source == null) {
            source = this.model.getSafeLocalSource(false);
        }
        return source;
    }

    public final WizardState onCancel(Exception e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this, (Throwable)e);
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.canceled"));
        return WizardState.CANCELED;
    }

    public final WizardState onError(Exception e) {
        this.model.getStepModel((AdminStep)this.model.getOperation()).setError(e);
        if (log.isErrorEnabled()) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.failed"));
        return WizardState.FAILED;
    }

    protected void replicateData(DataSource source, DataSource target, String ... mareeIds) throws DataSourceException {
        ReplicationService service = this.getReplicationService();
        if (mareeIds == null || mareeIds.length == 0) {
            service.replicateAllData(source, target);
        } else {
            service.replicateData(source, target, mareeIds);
        }
    }

    protected void replicateReferentiel(DataSource source, DataSource target) throws DataSourceException {
        this.getReplicationService().replicateReferentiel(source, target);
    }

    protected TopiaContext beginTransaction(DataSource source, String methodName) throws DataSourceException {
        TopiaContext ctxt = source.beginTransaction(methodName);
        return ctxt;
    }

    protected void commitTransaction(DataSource source, TopiaContext tx, String methodName) throws DataSourceException {
        source.commitTransaction(tx, methodName);
    }

    protected void closeTransaction(DataSource source, TopiaContext tx, String methodName) throws DataSourceException {
        source.closeTransaction(tx, methodName);
    }

    protected void rollbackTransaction(DataSource source, TopiaContext tx, String methodName) throws DataSourceException {
        source.rollbackTransaction(tx, methodName);
    }

    protected TopiaDAO<TopiaEntity> getDAO(TopiaContext tx, TopiaEntity entity) throws TopiaException {
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)tx, (TopiaEntity)entity);
        return dao;
    }

    public void initTabUI(AdminUI ui, AdminTabUI tabUI) {
        this.parentUI = ui;
        AdminStep step = tabUI.getStep();
        tabUI.addPropertyChangeListener(tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)("common for [" + (Object)((Object)step) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        String stepLabel = I18n._((String)step.getLabel());
        tabUI.getRUNNING_label().setText(I18n._((String)"observe.synchro.operation.running", (Object[])new Object[]{stepLabel}));
        tabUI.SUCCESSED_label.setText(I18n._((String)"observe.synchro.operation.successed", (Object[])new Object[]{stepLabel}));
        tabUI.NEED_FIX_label.setText(I18n._((String)"observe.synchro.operation.needFix", (Object[])new Object[]{stepLabel}));
        tabUI.CANCELED_label.setText(I18n._((String)"observe.synchro.operation.canceled", (Object[])new Object[]{stepLabel}));
        tabUI.FAILED_label.setText(I18n._((String)"observe.synchro.operation.failed", (Object[])new Object[]{stepLabel}));
        tabUI.progression.setVisible(true);
        tabUI.progressionTop.setVisible(true);
    }

    public void updateState(AdminTabUI ui, WizardState newState) {
        if (newState == null) {
            newState = WizardState.PENDING;
        }
        ui.getContentLayout().show((Container)ui.content, newState.name());
        switch (newState) {
            case PENDING: {
                ui.description.setText(I18n._((String)ui.getStep().getDescription()));
                return;
            }
            case RUNNING: {
                ui.RUNNING_progressionPane.getViewport().setView(ui.progression);
                ui.RUNNING_progressionPane.setColumnHeaderView(ui.progressionTop);
                break;
            }
            case SUCCESSED: {
                ui.SUCCESSED_progressionPane.getViewport().setView(ui.progression);
                ui.SUCCESSED_progressionPane.setColumnHeaderView(ui.progressionTop);
                break;
            }
            case FAILED: {
                Exception e = ui.getStepModel().getError();
                StringWriter w = new StringWriter();
                e.printStackTrace(new PrintWriter(w));
                ui.addMessage(ui.getStep(), w.toString());
                ui.FAILED_progressionPane.getViewport().setView(ui.progression);
                ui.FAILED_progressionPane.setColumnHeaderView(ui.progressionTop);
                break;
            }
            case NEED_FIX: {
                break;
            }
            case CANCELED: {
                ui.CANCELED_progressionPane.getViewport().setView(ui.progression);
                ui.CANCELED_progressionPane.setColumnHeaderView(ui.progressionTop);
            }
        }
    }

    public void sendMessage(String msg) {
        this.ui.firePropertyChange("message", null, msg);
    }

    public void writeMessage(AdminTabUI ui, String message) {
        AdminStep step = ui.getStep();
        ui.addMessage(step, message);
        ShowResumeUI resumeUI = (ShowResumeUI)this.parentUI.getStepUI(AdminStep.SHOW_RESUME);
        if (resumeUI != null) {
            resumeUI.addMessage(step, message);
        }
    }

    public String getProgressString(int currentStep, int nbStep) {
        String txt = "";
        AdminStep step = this.ui.getStep();
        if (step != null) {
            txt = I18n.n_((String)"observe.storage.step.label");
            txt = I18n._((String)txt, (Object[])new Object[]{currentStep + 1, nbStep, I18n._((String)step.getLabel())});
        }
        return txt;
    }

    public void updateSelectionModel(SelectDataUI tabUI) {
        JTree selectTree = tabUI.getSelectTree();
        DataSelectionModel selectDataModel = tabUI.getSelectDataModel();
        DataSelectionTreeSelectionModel selectionModel = tabUI.getSelectionModel();
        ObserveTreeHelper helper = tabUI.getTreeHelper();
        if (log.isDebugEnabled()) {
            log.debug((Object)("reload model " + selectDataModel));
        }
        selectionModel.clearSelection();
        DataSource source = tabUI.getModel().getSafeLocalSource(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will treeHelper : " + (Object)((Object)helper)));
            log.debug((Object)("selection model : " + selectDataModel));
            log.debug((Object)("use referentiel : " + selectDataModel.isUseReferentiel()));
            log.debug((Object)("use data        : " + selectDataModel.isUseData()));
        }
        DefaultTreeModel model = helper.createModel((JAXXContext)tabUI, selectDataModel, source);
        selectTree.setModel(model);
        selectionModel.initUI(selectTree);
    }

    protected void checkStepIsOperation(AdminTabUI ui) {
        if (!ui.getStep().isOperation()) {
            throw new IllegalStateException("can not launch operation on none operation step " + (Object)((Object)ui.getStep()));
        }
    }

    protected DataSource getSource(AdminUIModel model) {
        DataSource source = model.getTmpSource();
        if (source == null) {
            source = model.getSafeLocalSource(false);
        }
        return source;
    }

    protected void addStorageServiceLogger(DataSource service) {
        if (!service.containsDataSourceListener(this.serviceLogger)) {
            service.addDataSourceListener(this.serviceLogger);
        }
    }

    protected void removeStorageServiceLogger(DataSource service) {
        if (service.containsDataSourceListener(this.serviceLogger)) {
            service.removeDataSourceListener(this.serviceLogger);
        }
    }

    protected void openSource(DataSource service) throws DataSourceException {
        this.addStorageServiceLogger(service);
        if (!service.isOpen()) {
            service.doOpen();
        }
    }
}

