/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.MareesUI;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderModelBuilder;

public class MareesUIHandler
extends ContentListUIHandler<Programme, Maree> {
    private static final Log log = LogFactory.getLog(MareesUIHandler.class);

    public MareesUIHandler(MareesUI ui) {
        super(ui, DataContextType.Programme, DataContextType.Maree);
    }

    @Override
    protected TopiaEntityBinder<Programme> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Programme.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Programme.class, new String[]{"libelle1", "libelle2", "libelle3", "libelle4", "libelle5", "libelle6", "libelle7", "libelle8"});
            r = binderService.registerTopiaBinder(Programme.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openProgrammeId = dataContext.getOpenProgrammeId();
        if (openProgrammeId == null) {
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.maree.found"));
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Programme.class)) {
            this.addInfoMessage(I18n.n_((String)"observe.message.active.maree.found"));
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.n_((String)"observe.message.active.maree.found.for.other.programme"));
        return ContentMode.READ;
    }

    @Override
    protected void finalizeOpenUI() {
        String title = this.getDecoratorService().decorate(this.getBean());
        this.getUi().setContentTitle(title);
    }

    @Override
    protected List<Maree> getChilds(Programme bean) throws DataSourceException {
        DataSource source = this.getDataSource();
        DataService dataService = this.getDataService();
        List<Maree> list = dataService.getMareeByProgramme(source, bean.getTopiaId());
        if (list == null) {
            list = Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + list.size() + " marees."));
        }
        return list;
    }
}

