/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.SendMessageAble;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.BaliseLue;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.referentiel.OperationBalise;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.entities.referentiel.ReferentielEntity;
import fr.ird.observe.ui.admin.access.AccessDataSource;
import fr.ird.observe.ui.admin.access.AccessEntity;
import fr.ird.observe.ui.admin.access.AccessEntityMeta;
import fr.ird.observe.ui.admin.access.AccessHitModel;
import fr.ird.observe.ui.admin.access.ImportAccessException;
import fr.ird.observe.ui.admin.access.metas.ActiviteMeta;
import fr.ird.observe.ui.admin.access.metas.BaliseLueMeta;
import fr.ird.observe.ui.admin.access.metas.CaleeMeta;
import fr.ird.observe.ui.admin.access.metas.ObjetFlottantMeta;
import fr.ird.observe.ui.admin.access.metas.ReferentielEntityMeta;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;

public class EntityBuilder {
    private static final Log log = LogFactory.getLog(EntityBuilder.class);
    protected final EntityVisitor visitor = new EntityVisitor(){

        public void start(TopiaEntity entity) {
            if (log.isDebugEnabled()) {
                log.debug((Object)entity);
            }
            EntityBuilder.this.onStart((AccessEntity)entity);
        }

        public void end(TopiaEntity entity) {
            if (log.isDebugEnabled()) {
                log.debug((Object)entity);
            }
            EntityBuilder.this.onEnd((AccessEntity)entity);
        }

        public void visit(TopiaEntity entity, String propertyName, Class<?> type, Object value) {
            if (log.isDebugEnabled()) {
                log.debug((Object)entity);
            }
            AccessEntity current = (AccessEntity)entity;
            if (TopiaEntity.class.isAssignableFrom(type)) {
                AccessEntityMeta<?> meta = current.getMeta();
                if (meta.containsReverseAssociation(propertyName)) {
                    EntityBuilder.this.onVisitReverseAssociation(propertyName, meta, current);
                } else {
                    EntityBuilder.this.onVisitComposition(propertyName, type, current);
                }
            } else {
                EntityBuilder.this.onVisitSimpleProperty(propertyName, type, current);
            }
        }

        public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, Object value) {
            if (!TopiaEntity.class.isAssignableFrom(type)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)entity);
            }
            AccessEntity current = (AccessEntity)entity;
            if ("calee".equals(propertyName) && entity instanceof Activite) {
                AccessEntityMeta<?> meta = current.getMeta();
                EntityBuilder.this.onVisitCalee(current, (ActiviteMeta)meta);
                return;
            }
            if (entity instanceof ObjetFlottant && "baliseLue".equals(propertyName)) {
                try {
                    AccessEntityMeta<?> meta = current.getMeta();
                    List<BaliseLue> baliseLue = EntityBuilder.this.loadBaliseLues(current, (ObjetFlottantMeta)meta);
                    for (BaliseLue child : baliseLue) {
                        current.addListProperty(propertyName, child);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            EntityBuilder.this.onVisitAssociation(propertyName, type, current);
        }

        public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, int index, Object value) {
        }

        public void clear() {
            EntityBuilder.this.row = null;
            EntityBuilder.this.stack.clear();
            EntityBuilder.this.rows.clear();
        }
    };
    protected final AccessDataSource db;
    protected final DataSource source;
    protected final Stack<TopiaEntity> stack;
    protected final Stack<Map<String, Object>> rows;
    protected Map<String, Object> row;
    protected Map<String, AccessEntity> referentiel;
    protected List<AccessEntity> data;
    protected AccessHitModel hits;
    protected TopiaContext tx;
    protected String programmeId;
    protected Programme programme;
    protected SendMessageAble messager;
    public static final String TX_NAME = "importAcces";
    public static final String REFERENTIEL_QUERY = "From %1$s WHERE %2$s = :key";
    ReferentielEntityMeta<ReferentielEntity> operationBaliseMeta = new ReferentielEntityMeta(ObserveEntityEnum.OperationBalise, "DUMMY", new String[]{"DUMMY"}, "code", Integer.class, "DUMMY");

    public EntityBuilder(AccessDataSource db, DataSource source, String programmeId) {
        this.db = db;
        this.source = source;
        this.stack = new Stack();
        this.rows = new Stack();
        this.referentiel = new TreeMap<String, AccessEntity>();
        this.data = new ArrayList<AccessEntity>();
        this.programmeId = programmeId;
        if (log.isDebugEnabled()) {
            this.hits.addPropertyChangeListener(new BuilderDebugListener());
        }
    }

    public TopiaContext getTx() {
        if (this.tx == null) {
            try {
                this.tx = this.source.beginTransaction(TX_NAME);
            }
            catch (DataSourceException e) {
                throw new IllegalStateException("Could not obtain transaction from " + this.source);
            }
        }
        return this.tx;
    }

    public Programme getProgramme() throws TopiaException {
        if (this.programme == null && this.programmeId != null) {
            this.programme = (Programme)this.getTx().findByTopiaId(this.programmeId);
        }
        return this.programme;
    }

    public void doVisit(Maree e, AccessHitModel hits) throws ImportAccessException {
        this.clear();
        if (hits != null) {
            this.hits = hits;
        }
        try {
            e.accept(this.visitor);
        }
        catch (Exception e1) {
            Decorator d = ObserveServiceHelper.getDecoratorService().getDecorator((Object)e);
            throw new ImportAccessException(I18n._((String)"observe.error.importAccess.not.saved", (Object[])new Object[]{d.toString((Object)e)}), e1);
        }
        finally {
            this.visitor.clear();
            this.hits = null;
        }
    }

    public AccessHitModel getHits() {
        return this.hits;
    }

    public Map<String, AccessEntity> getReferentiel() {
        return this.referentiel;
    }

    public List<AccessEntity> getData() {
        return this.data;
    }

    public AccessDataSource getDb() {
        return this.db;
    }

    public DataSource getSource() {
        return this.source;
    }

    public SendMessageAble getMessager() {
        return this.messager;
    }

    public void setMessager(SendMessageAble messager) {
        this.messager = messager;
    }

    public void onStart(AccessEntity current) {
        block4: {
            AccessEntityMeta<?> meta = current.getMeta();
            if (this.hits != null) {
                this.hits.addHit(meta.getType());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(meta.getType() + " - " + current.getRowId()));
            }
            this.stack.push(current);
            this.data.add(current);
            try {
                this.row = this.db.getTableDataRow(meta, current.getRowId());
                this.rows.push(this.row);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not obtain row data", (Throwable)e);
            }
        }
    }

    public void onEnd(AccessEntity current) {
        this.stack.pop();
        this.rows.pop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.stack.size() + " done : " + current));
        }
        if (this.stack.isEmpty()) {
            this.row = null;
            try {
                this.saveEntity(current);
                this.getSource().commitTransaction(this.getTx(), TX_NAME);
            }
            catch (Exception e) {
                block8: {
                    String message = I18n._((String)"observe.error.importAccess.not.saved", (Object[])current.getPkey());
                    if (log.isErrorEnabled()) {
                        log.error((Object)message, (Throwable)e);
                    }
                    try {
                        this.getSource().rollbackTransaction(this.getTx(), TX_NAME);
                    }
                    catch (DataSourceException e1) {
                        if (!log.isErrorEnabled()) break block8;
                        log.error((Object)"Could not rollback transaction importAcces", (Throwable)e);
                    }
                }
                throw new RuntimeException(e);
            }
        }
        current = (AccessEntity)this.stack.peek();
        this.row = this.rows.peek();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Back to " + current));
        }
    }

    public void onVisitSimpleProperty(String propertyName, Class<?> type, AccessEntity entity) {
        AccessEntityMeta<?> meta = entity.getMeta();
        if (!meta.containsProperty(propertyName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip property [" + meta.getType() + " - " + propertyName + "], not supported (should not in visitor...)"));
            }
            return;
        }
        String colName = meta.getPropertyColumnName(propertyName);
        Serializable newValue = (Serializable)this.row.get(colName);
        if (newValue == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("get property [" + propertyName + "] (type:" + type.getName() + ") (dbcol:" + colName + ") = " + newValue));
        }
        entity.setProperty(propertyName, newValue);
    }

    public void onVisitComposition(String propertyName, Class<?> type, AccessEntity entity) {
        AccessEntityMeta<?> meta = entity.getMeta();
        if (!meta.containsProperty(propertyName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip property [" + meta.getType() + " - " + propertyName + "], not supported (should not be visited...)"));
            }
            return;
        }
        AccessEntity toSave = this.newReferentielEntity(propertyName, type, meta);
        if (toSave != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will add composition [" + propertyName + ":" + toSave + "] to " + entity));
            }
            entity.setProperty(propertyName, toSave);
        }
    }

    public void onVisitReverseAssociation(String propertyName, AccessEntityMeta<?> meta, AccessEntity entity) {
        AccessEntityMeta.AssociationMapping reverse = meta.getReverseAssociationMapping(propertyName);
        Class<?> type = reverse.getType();
        TopiaEntity parent = this.getEntityFromStack(type);
        if (parent == null) {
            throw new IllegalStateException("Could not find reverse association [" + propertyName + ":" + type + "] for one of his child " + entity);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will add reverse composition [" + propertyName + ":" + parent + "] to " + entity));
        }
        entity.setProperty(propertyName, parent);
    }

    public void onVisitAssociation(String propertyName, Class<?> type, AccessEntity entity) {
        AccessEntityMeta<?>[] childMeta;
        AccessEntity toSave;
        AccessEntityMeta<?> meta = entity.getMeta();
        ObserveEntityEnum constant = ObserveEntityEnum.valueOf(type);
        if (constant == ObserveEntityEnum.ObjetFlottant && entity instanceof ObjetFlottant && "operation".equals(propertyName) && (toSave = this.newReferentielEntity(propertyName, type, meta)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will add composition [" + propertyName + ":" + toSave + "] to " + entity));
            }
            entity.addListProperty(propertyName, toSave);
            return;
        }
        ArrayList<TopiaEntity> childs = new ArrayList<TopiaEntity>();
        for (AccessEntityMeta<?> accessEntityMeta : childMeta = this.db.getMetaForType(constant.getContract())) {
            TopiaEntity[] tmp;
            if (log.isDebugEnabled()) {
                log.debug((Object)("load association [" + constant + "] (meta:" + accessEntityMeta + ")"));
            }
            if ((tmp = this.getAssociation(entity, propertyName, meta, accessEntityMeta)).length <= 0) continue;
            childs.addAll(Arrays.asList(tmp));
        }
        for (TopiaEntity child : childs) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add association " + child));
            }
            entity.addListProperty(propertyName, child);
            this.acceptEntity(child);
        }
    }

    protected List<BaliseLue> loadBaliseLues(AccessEntity entity, ObjetFlottantMeta meta) throws IOException {
        TopiaEntity[] tmp;
        ArrayList<TopiaEntity> childs = new ArrayList<TopiaEntity>();
        ObserveEntityEnum constant = ObserveEntityEnum.ObjetFlottant;
        BaliseLueMeta childMeta = this.db.getMeta(BaliseLueMeta.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("load association [" + constant + "] (meta:" + childMeta + ")"));
        }
        if ((tmp = this.getAssociation(entity, "baliseLue", meta, childMeta)).length > 0) {
            childs.addAll(Arrays.asList(tmp));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import " + childs.size() + " balise lues from acces to [" + entity + "]"));
        }
        ArrayList<BaliseLue> baliseLue = new ArrayList<BaliseLue>();
        for (TopiaEntity child : childs) {
            AccessEntity operationBalise;
            BaliseLue b1;
            Serializable scode;
            BaliseLue b = (BaliseLue)child;
            int rowId = ((AccessEntity)b).getRowId();
            Object[] pkey = ((AccessEntity)b).getPkey();
            Map<String, Object> bRow = this.db.getTableDataRow(childMeta, rowId);
            if (log.isInfoEnabled()) {
                log.info(bRow);
            }
            String code = (scode = (Serializable)bRow.get("C_BALISE")) == null ? null : scode + "";
            String cVisite = (String)bRow.get("C_VISITE");
            String cRecup = (String)bRow.get("C_RECUP");
            String cMiseALEau = (String)bRow.get("C_MISE_A_L_EAU");
            if (StringUtils.isNotEmpty((String)cVisite)) {
                b1 = (BaliseLue)childMeta.newEntity(rowId, pkey);
                b1.setCode(code);
                operationBalise = this.newReferentielEntity("operationBalise", childMeta, Integer.valueOf(1));
                b1.setOperationBalise((OperationBalise)operationBalise);
                baliseLue.add(b1);
            }
            if (StringUtils.isNotEmpty((String)cRecup)) {
                b1 = (BaliseLue)childMeta.newEntity(rowId, pkey);
                b1.setCode(code);
                operationBalise = this.newReferentielEntity("operationBalise", childMeta, Integer.valueOf(2));
                b1.setOperationBalise((OperationBalise)operationBalise);
                baliseLue.add(b1);
            }
            if (!StringUtils.isNotEmpty((String)cMiseALEau)) continue;
            b1 = (BaliseLue)childMeta.newEntity(rowId, pkey);
            b1.setCode(code);
            operationBalise = this.newReferentielEntity("operationBalise", childMeta, Integer.valueOf(3));
            b1.setOperationBalise((OperationBalise)operationBalise);
            baliseLue.add(b1);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import " + baliseLue.size() + " balise lues to ObServe to [" + entity + "]"));
        }
        return baliseLue;
    }

    protected <E extends TopiaEntity> E saveEntity(AccessEntity entity) throws TopiaException {
        TopiaEntity value;
        Class<?> propertyType;
        if (entity instanceof ReferentielEntity) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will save " + entity));
        }
        AccessEntity incoming = entity;
        AccessEntityMeta<?> meta = entity.getMeta();
        ObserveEntityEnum type = meta.getType();
        EntityOperator operator = ObserveDAOHelper.getOperator((Class)type.getContract());
        Map tmp = operator.getNaturalId((TopiaEntity)incoming);
        if (log.isDebugEnabled()) {
            log.debug((Object)(entity + " : ids = " + tmp.keySet()));
        }
        TreeMap ids = new TreeMap();
        if (!tmp.isEmpty()) {
            for (Map.Entry entry : tmp.entrySet()) {
                Object value2 = entry.getValue();
                if (value2 == null) continue;
                if (value2 instanceof AccessEntity) {
                    AccessEntity accessEntity = (AccessEntity)value2;
                    Class entityType = accessEntity.getMeta().getType().getContract();
                    if (value2 instanceof ReferentielEntity) {
                        String string = accessEntity.getTopiaId();
                        value2 = this.getTx().findByTopiaId(string);
                    } else {
                        value2 = this.getEntityFromStack(entityType);
                        if (value2 == null) {
                            throw new IllegalStateException("Could not find ancestor of type [" + entityType + "]" + " in stack of created objects : " + this.stack);
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will use natural key [" + entity + "] " + (String)entry.getKey() + ":" + value2));
                }
                ids.put(entry.getKey(), value2);
            }
        }
        if (type == ObserveEntityEnum.Maree) {
            ids.put("programme", this.getProgramme());
        }
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)this.getTx(), (TopiaEntity)incoming);
        TopiaEntity toSave = dao.create(ids);
        this.stack.push(toSave);
        for (AccessEntityMeta.PropertyMapping propertyMapping : meta.getPropertyMapping()) {
            Object value3 = operator.get(propertyMapping.getProperty(), (TopiaEntity)incoming);
            if (value3 == null) continue;
            propertyType = propertyMapping.getType();
            if (value3 instanceof TopiaEntity) {
                if (value3 instanceof ReferentielEntity) {
                    AccessEntity a = (AccessEntity)value3;
                    String topiaId = a.getTopiaId();
                    if (topiaId == null) {
                        String message = "Will not use referentiel with no topiaId [" + propertyMapping.getType().getName() + ":" + a.getPkey()[0] + "]";
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)message);
                        continue;
                    }
                    value3 = this.getTx().findByTopiaId(topiaId);
                } else {
                    value3 = this.getEntityFromStack(propertyType);
                    if (value3 == null) {
                        throw new IllegalStateException("Could not find ancestor of type [" + propertyType.getName() + "]" + " in stack of created objects : " + this.stack);
                    }
                }
            }
            operator.set(propertyMapping.getProperty(), toSave, value3);
        }
        for (Serializable serializable : meta.getReverseAssociationMapping()) {
            Class<?> propertyType2 = ((AccessEntityMeta.AssociationMapping)serializable).getType();
            String propertyName = ((AccessEntityMeta.AssociationMapping)serializable).getProperty();
            if (!TopiaEntity.class.isAssignableFrom(propertyType2)) {
                throw new IllegalStateException("Reverse association can only be on TopiaEntity, but was on " + propertyType2);
            }
            value = this.getEntityFromStack(propertyType2);
            if (value == null) {
                throw new IllegalStateException("Could not find ancestor of type [" + propertyType2.getName() + "]" + " in stack of created objects : " + this.stack);
            }
            operator.set(propertyName, toSave, (Object)value);
        }
        for (Serializable serializable : meta.getAssocationMapping()) {
            String propertyName = ((AccessEntityMeta.AssociationMapping)serializable).getProperty();
            propertyType = ((AccessEntityMeta.AssociationMapping)serializable).getType();
            if ("calee".equals(propertyName)) {
                value = (AccessEntity)operator.get(propertyName, (TopiaEntity)incoming);
                if (value == null) continue;
                Calee c = (Calee)this.saveEntity((AccessEntity)value);
                operator.set(propertyName, toSave, (Object)c);
                continue;
            }
            if (operator.isChildEmpty(propertyName, (TopiaEntity)incoming)) continue;
            Iterable childs = (Iterable)operator.get(propertyName, (TopiaEntity)incoming);
            for (Object o : childs) {
                Object child;
                AccessEntity e = (AccessEntity)o;
                if (ReferentielEntity.class.isAssignableFrom(propertyType)) {
                    String topiaId = e.getTopiaId();
                    if (topiaId == null) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Could not find topiaId of " + e.getMeta().getType() + ":" + Arrays.toString(e.getPkey())));
                        continue;
                    }
                    child = this.getTx().findByTopiaId(topiaId);
                } else {
                    child = this.saveEntity(e);
                }
                operator.addChild(propertyName, toSave, child);
            }
        }
        this.stack.pop();
        dao.update(toSave);
        return (E)toSave;
    }

    protected void sendMessage(String message) {
        if (this.messager != null) {
            this.messager.sendMessage(message);
        }
    }

    protected TopiaEntity getEntityFromStack(Class<?> type) {
        TopiaEntity entity = null;
        for (TopiaEntity e : this.stack) {
            if (!type.isAssignableFrom(e.getClass())) continue;
            entity = e;
            break;
        }
        return entity;
    }

    protected AccessEntity newReferentielEntity(String propertyName, Class<?> type, AccessEntityMeta<?> meta) {
        String colName = meta.getPropertyColumnName(propertyName);
        Serializable newValue = (Serializable)this.row.get(colName);
        if (newValue == null) {
            return null;
        }
        if (newValue instanceof Short) {
            newValue = Integer.valueOf(newValue + "");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("get property [" + propertyName + "] (type:" + type.getName() + ") (dbcol:" + colName + ") = " + newValue));
        }
        AccessEntity result = this.newReferentielEntity(propertyName, meta, newValue);
        return result;
    }

    protected AccessEntity newReferentielEntity(String propertyName, AccessEntityMeta<?> meta, Serializable newValue) {
        AccessEntityMeta compoMeta;
        AccessEntityMeta.PropertyMapping mapping = meta.getPropertyMapping(propertyName);
        Class<?> compositionType = mapping.getType();
        if (OperationBalise.class.equals(compositionType)) {
            compoMeta = this.operationBaliseMeta;
        } else {
            Object[] compoMetas = this.db.getMetaForType(compositionType);
            if (compoMetas.length == 0) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Skip composition [" + meta.getType() + " - " + propertyName + "], meta of type [" + compositionType + "] not found..."));
                }
                return null;
            }
            if (compoMetas.length > 1) {
                throw new IllegalStateException("Found more than one meta for referentiel type [" + compositionType + "] : " + Arrays.toString(compoMetas));
            }
            compoMeta = compoMetas[0];
        }
        String pkey = compositionType.getName() + ":" + newValue;
        AccessEntity cachedEntity = this.referentiel.get(pkey);
        if (cachedEntity == null) {
            block13: {
                cachedEntity = (AccessEntity)compoMeta.newEntity(-1, new Object[]{newValue});
                try {
                    String pkeyProperty = compoMeta.getType().getNaturalIds()[0];
                    String sql = String.format(REFERENTIEL_QUERY, compoMeta.getType().getImplementationFQN(), pkeyProperty);
                    List list = this.getTx().find(sql, new Object[]{"key", newValue});
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        String message = "Referentiel entity [" + pkey + "] does not exists!";
                        if (log.isErrorEnabled()) {
                            log.error((Object)message);
                        }
                        this.sendMessage(message);
                    } else {
                        TopiaEntity e = (TopiaEntity)list.get(0);
                        String topiaId = e.getTopiaId();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("resolved [" + pkey + "] = " + topiaId));
                        }
                        cachedEntity.setTopiaId(topiaId);
                    }
                }
                catch (TopiaException e) {
                    if (!log.isErrorEnabled()) break block13;
                    log.error((Object)("Could not obtain referentiel entity [" + pkey + "]"), (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add referentiel [" + pkey + "] in cache."));
            }
            this.referentiel.put(pkey, cachedEntity);
        }
        return cachedEntity;
    }

    public void onVisitCalee(AccessEntity entity, ActiviteMeta meta) {
        String propertyName = "calee";
        CaleeMeta childMeta = this.db.getMeta(CaleeMeta.class);
        TopiaEntity[] childs = this.getAssociation(entity, propertyName, meta, childMeta);
        if (childs.length > 0) {
            TopiaEntity calee = childs[0];
            entity.setProperty(propertyName, calee);
            this.acceptEntity(calee);
        }
    }

    protected TopiaEntity[] getAssociation(TopiaEntity c, String propertyName, AccessEntityMeta<?> meta, AccessEntityMeta<?> childMeta) {
        TopiaEntity[] childs;
        block12: {
            try {
                childs = this.db.loadAssociation(childMeta, meta, ((AccessEntity)c).getPkey());
                Class contract = childMeta.getType().getContract();
                if (!ReferentielEntity.class.isAssignableFrom(contract)) break block12;
                for (TopiaEntity child : childs) {
                    String pkey;
                    AccessEntity cachedEntity;
                    AccessEntity a = (AccessEntity)child;
                    Object[] pkeys = a.getPkey();
                    Object newValue = pkeys[0];
                    if (newValue instanceof Short) {
                        newValue = Integer.valueOf(newValue + "");
                    }
                    if ((cachedEntity = this.referentiel.get(pkey = contract.getName() + ":" + newValue)) == null) {
                        block13: {
                            cachedEntity = (AccessEntity)meta.newEntity(-1, new Object[]{newValue});
                            try {
                                String pkeyProperty = childMeta.getType().getNaturalIds()[0];
                                String sql = String.format(REFERENTIEL_QUERY, childMeta.getType().getImplementationFQN(), pkeyProperty);
                                List list = this.getTx().find(sql, new Object[]{"key", newValue});
                                if (CollectionUtils.isEmpty((Collection)list)) {
                                    if (log.isErrorEnabled()) {
                                        log.error((Object)("Referentiel entity [" + pkey + "] does not exists!"));
                                    }
                                } else {
                                    TopiaEntity e = (TopiaEntity)list.get(0);
                                    String topiaId = e.getTopiaId();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("resolved [" + pkey + "] = " + topiaId));
                                    }
                                    cachedEntity.setTopiaId(topiaId);
                                    a.setTopiaId(topiaId);
                                }
                            }
                            catch (TopiaException e) {
                                if (!log.isErrorEnabled()) break block13;
                                log.error((Object)("Could not obtain referentiel entity [" + pkey + "]"), (Throwable)e);
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Add referentiel [" + pkey + "] in cache."));
                        }
                        this.referentiel.put(pkey, cachedEntity);
                        continue;
                    }
                    child.setTopiaId(cachedEntity.getTopiaId());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not obtain association [" + propertyName + "]", e);
            }
        }
        return childs;
    }

    protected void acceptEntity(TopiaEntity child) {
        try {
            child.accept(this.visitor);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not accept " + child), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
    }

    public void clear() {
        this.visitor.clear();
    }

    protected void finalize() throws Throwable {
        this.clear();
        this.referentiel.clear();
        this.data.clear();
        if (this.tx != null) {
            this.source.closeTransaction(this.tx, TX_NAME);
        }
        super.finalize();
    }

    static class BuilderDebugListener
    implements PropertyChangeListener {
        BuilderDebugListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            ObserveEntityEnum type = ObserveEntityEnum.valueOf((String)propertyName);
            String message = "|%1$20s|%2$5d|%3$5d|";
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format(message, type, evt.getOldValue(), evt.getNewValue()));
            }
        }
    }
}

