/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.ui.admin.access.AccessEntityMeta;
import fr.ird.observe.ui.admin.access.AccessHitModel;
import fr.ird.observe.ui.admin.access.metas.ReferentielEntityMeta;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class AccessDataSource {
    private static final Log log = LogFactory.getLog(AccessDataSource.class);
    public static final List<ObserveEntityEnum> NO_MAPPEABLE_ENTITIES = Arrays.asList(ObserveEntityEnum.Ocean, ObserveEntityEnum.OperationBalise, ObserveEntityEnum.Organisme, ObserveEntityEnum.ParametrageTaillePoidsFaune, ObserveEntityEnum.RaisonRejet);
    protected static final Set<AccessEntityMeta<?>> nativeMetas = AccessDataSource.loadNatives();
    protected final Database connexion;
    protected final AccessEntityMeta<?>[] metas;
    protected String[] unusedTables;
    protected String[] tables;
    protected final Map<AccessEntityMeta<?>, Map<String, Object>[]> cache;

    public AccessDataSource(Database connexion) throws Exception {
        this.connexion = connexion;
        ArrayList metas = new ArrayList(nativeMetas.size());
        for (AccessEntityMeta<?> meta : nativeMetas) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register meta : " + meta));
            }
            this.registerEntity(metas, meta);
        }
        this.metas = metas.toArray(new AccessEntityMeta[metas.size()]);
        this.getTables();
        this.getUnusedTables();
        this.cache = new HashMap();
    }

    public String[] getTables() {
        if (this.tables == null) {
            ArrayList<String> result = new ArrayList<String>();
            for (Table table : this.connexion) {
                result.add(table.getName());
            }
            this.tables = result.toArray(new String[result.size()]);
        }
        return this.tables;
    }

    public String[] getUnusedTables() {
        if (this.unusedTables == null) {
            List<String> allTables = Arrays.asList(this.getTables());
            ArrayList<String> tmp = new ArrayList<String>(allTables);
            for (AccessEntityMeta<?> entity : this.metas) {
                tmp.remove(entity.getTableName());
            }
            this.unusedTables = tmp.toArray(new String[tmp.size()]);
        }
        return this.unusedTables;
    }

    public boolean hasError() {
        for (AccessEntityMeta<?> meta : this.metas) {
            if (!meta.hasError()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWarning() {
        for (AccessEntityMeta<?> meta : this.metas) {
            if (!meta.hasWarning()) continue;
            return true;
        }
        return false;
    }

    public AccessEntityMeta<?>[] getMetaWithError() {
        ArrayList result = new ArrayList();
        for (AccessEntityMeta<?> meta : this.metas) {
            if (!meta.hasError()) continue;
            result.add(meta);
        }
        return result.toArray(new AccessEntityMeta[result.size()]);
    }

    public AccessEntityMeta<?>[] getMetaWithWarning() {
        ArrayList result = new ArrayList();
        for (AccessEntityMeta<?> meta : this.metas) {
            if (!meta.hasWarning()) continue;
            result.add(meta);
        }
        return result.toArray(new AccessEntityMeta[result.size()]);
    }

    public Database getConnexion() {
        return this.connexion;
    }

    public AccessEntityMeta<?>[] getMetas() {
        return this.metas;
    }

    public AccessEntityMeta<?>[] getMetaForType(Class<?> type) {
        ArrayList result = new ArrayList();
        for (AccessEntityMeta<?> meta : this.metas) {
            if (!type.isAssignableFrom(meta.getType().getContract())) continue;
            result.add(meta);
        }
        return result.toArray(new AccessEntityMeta[result.size()]);
    }

    public AccessEntityMeta<?> getMeta(ObserveEntityEnum type) {
        for (AccessEntityMeta<?> meta : this.metas) {
            if (!type.equals((Object)meta.getType())) continue;
            return meta;
        }
        return null;
    }

    public <M extends AccessEntityMeta<?>> M getMeta(Class<M> metaType) {
        for (AccessEntityMeta<?> meta : this.metas) {
            if (!metaType.equals(meta.getClass())) continue;
            return (M)meta;
        }
        return null;
    }

    public Table getTable(AccessEntityMeta<?> meta) throws IOException {
        Table table = this.getConnexion().getTable(meta.getTableName());
        return table;
    }

    public Map<String, Object>[] getTableData(AccessEntityMeta<?> meta) throws IOException {
        Map<String, Object>[] result = this.cache.get(meta);
        if (result == null) {
            Table table = this.getTable(meta);
            int rowCount = table.getRowCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load table " + table.getName() + " with " + rowCount + " row(s)."));
            }
            result = new Map[rowCount];
            this.cache.put(meta, result);
            int i = 0;
            Iterator itr = table.iterator();
            ArrayIntList errors = new ArrayIntList();
            while (i < rowCount && itr.hasNext()) {
                Map<String, Object> map = this.getTableDataRow(i, itr, (IntList)errors);
                result[i++] = map;
            }
            if (!errors.isEmpty() && log.isDebugEnabled()) {
                log.debug((Object)("[" + meta.getType() + "] Could not load " + errors.size() + " row(s) : " + errors));
            }
            meta.setErrorRows(errors.toArray(new int[errors.size()]));
        }
        return result;
    }

    protected Map<String, Object> getTableDataRow(int row, Iterator<Map<String, Object>> itr, IntList errors) {
        Map<String, Object> map = null;
        try {
            map = itr.next();
        }
        catch (Exception e) {
            errors.add(row);
        }
        return map;
    }

    protected Map<String, Object> getTableDataRow(AccessEntityMeta<?> meta, int row) throws IOException {
        Map<String, Object>[] result = this.getTableData(meta);
        return result[row];
    }

    public Object[][] getPkeys(AccessEntityMeta<?> meta) throws IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Map<String, Object> map : this.getTableData(meta)) {
            Object[] pkey = this.getPkey(meta, map);
            result.add(pkey);
        }
        return (Object[][])result.toArray((T[])new Object[result.size()][]);
    }

    public <E extends TopiaEntity> E[] loadAssociation(AccessEntityMeta<E> meta, AccessEntityMeta<?> container, Object[] pkeys) throws Exception {
        Map<String, Object>[] data;
        ArrayList<E> result = new ArrayList<E>();
        int row = 0;
        for (Map<String, Object> map : data = this.getTableData(meta)) {
            if (map == null) {
                ++row;
                continue;
            }
            Object[] pkey = this.getPkey(container.getPkeys(), map);
            if (Arrays.equals(pkeys, pkey)) {
                E e = meta.newEntity(row, this.getPkey(meta, map));
                result.add(e);
            }
            ++row;
        }
        TopiaEntity[] r = (TopiaEntity[])Array.newInstance(meta.getType().getContract(), result.size());
        int i = 0;
        for (TopiaEntity e : result) {
            r[i++] = e;
        }
        return r;
    }

    public <E extends TopiaEntity> E[] loadEntities(AccessEntityMeta<E> meta) throws Exception {
        ArrayList<E> result = new ArrayList<E>();
        int row = 0;
        for (Map<String, Object> map : this.getTableData(meta)) {
            Object[] pkey = this.getPkey(meta, map);
            E e = meta.newEntity(row, pkey);
            result.add(e);
            ++row;
        }
        TopiaEntity[] r = (TopiaEntity[])Array.newInstance(meta.getType().getContract(), result.size());
        int i = 0;
        for (TopiaEntity e : result) {
            r[i++] = e;
        }
        return r;
    }

    public int[] find(AccessEntityMeta<?> meta, AccessEntityMeta<?> container, Object[] pkeys) throws IOException {
        ArrayIntList result = new ArrayIntList();
        int i = 0;
        for (Map<String, Object> map : this.getTableData(meta)) {
            Object[] pkey = this.getPkey(container.getPkeys(), map);
            if (Arrays.equals(pkeys, pkey)) {
                result.add(i);
            }
            ++i;
        }
        return result.toArray(new int[result.size()]);
    }

    public Object[] getPkey(AccessEntityMeta<?> meta, Map<String, Object> map) {
        return this.getPkey(meta.getPkeys(), map);
    }

    public Object[] getPkey(List<String> keys, Map<String, Object> map) {
        Object[] result = new Object[keys.size()];
        int i = 0;
        for (String key : keys) {
            Object o = map.get(key);
            result[i++] = o;
        }
        return result;
    }

    public Object[][] getPkey(AccessEntityMeta<?> meta, int[] rows) throws IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Map<String, Object>[] data = this.getTableData(meta);
        for (int row : rows) {
            result.add(this.getPkey(meta, data[row]));
        }
        return (Object[][])result.toArray((T[])new Object[result.size()][]);
    }

    public String generateAnalyseReport(AccessHitModel hits, DecoratorService service) {
        Table table;
        AccessEntityMeta<?>[] metas;
        StringBuilder result = new StringBuilder();
        result.append(I18n._((String)"observe.access.analyse.detected.tables", (Object[])new Object[]{this.tables.length}));
        if (this.hasError()) {
            metas = this.getMetaWithError();
            result.append("\n").append(I18n._((String)"observe.access.analyse.detected.errors", (Object[])new Object[]{metas.length}));
            for (AccessEntityMeta<?> meta : metas) {
                try {
                    table = this.getTable(meta);
                }
                catch (IOException e) {
                    table = null;
                }
                result.append("\n");
                this.printErrors(meta, result, table, service);
            }
        } else {
            result.append("\n").append(I18n._((String)"observe.access.analyse.no.error"));
        }
        if (this.hasWarning()) {
            metas = this.getMetaWithWarning();
            result.append("\n").append(I18n._((String)"observe.access.analyse.detected.warnings", (Object[])new Object[]{metas.length}));
            for (AccessEntityMeta<?> meta : metas) {
                try {
                    table = this.getTable(meta);
                }
                catch (IOException e) {
                    table = null;
                }
                result.append("\n");
                this.printWarnings(meta, result, table, service);
            }
        } else {
            result.append("\n").append(I18n._((String)"observe.access.analyse.no.warning"));
        }
        if (this.hasError()) {
            return result.toString();
        }
        for (AccessEntityMeta<?> meta : this.getMetas()) {
            int[] errorRows = meta.getErrorRows();
            if (errorRows == null || errorRows.length <= 0) continue;
            result.append("\n").append(I18n._((String)"observe.access.analyse.detected.rows.error", (Object[])new Object[]{errorRows.length, meta.getType(), Arrays.toString(errorRows)}));
        }
        result.append("\n\n------------------------------------------------");
        result.append("\n").append(I18n._((String)"observe.access.analyse.detected.objects", (Object[])new Object[]{hits.getTotalHit()}));
        for (Map.Entry entry : hits) {
            ObserveEntityEnum type = (ObserveEntityEnum)entry.getKey();
            Long total = entry.getValue();
            String label = I18n._((String)service.getEntityLabel(type.getContract()));
            result.append("\n").append(I18n._((String)"observe.access.analyse.detected.objects.by.type", (Object[])new Object[]{total, label}));
        }
        for (AccessEntityMeta<?> meta : this.metas) {
            try {
                Table table2 = this.getTable(meta);
                List<String> names = this.getColumnNames(table2);
                result.append("\n").append("Table ").append(table2.getName()).append(" ");
                result.append(I18n._((String)"observe.access.analyse.available.columns", (Object[])new Object[]{names}));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public void printWarnings(AccessEntityMeta<?> meta, StringBuilder result, Table table, DecoratorService service) {
        if (!this.hasWarning()) {
            return;
        }
        String label = I18n._((String)service.getEntityLabel(meta.getType().getContract()));
        result.append("\n").append(I18n._((String)"observe.access.analyse.detected.warnings.by.type", (Object[])new Object[]{meta.warnings.size(), label}));
        for (String warning : meta.warnings) {
            result.append("\n -  ").append(warning);
        }
        if (table == null) {
            return;
        }
        List<String> names = this.getColumnNames(table);
        result.append("\n").append(I18n._((String)"observe.access.analyse.available.columns", (Object[])new Object[]{names}));
    }

    protected List<String> getColumnNames(Table table) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            names.add(column.getName());
        }
        return names;
    }

    public void printErrors(AccessEntityMeta<?> meta, StringBuilder result, Table table, DecoratorService service) {
        if (!this.hasError()) {
            return;
        }
        String label = I18n._((String)service.getEntityLabel(meta.getType().getContract()));
        result.append("\n").append(I18n._((String)"observe.access.analyse.detected.errors.by.type", (Object[])new Object[]{meta.errors.size(), label}));
        for (String error : meta.errors) {
            result.append("\n - ").append(error);
        }
        if (table == null) {
            return;
        }
        List<String> names = this.getColumnNames(table);
        result.append("\n").append(I18n._((String)"observe.access.analyse.available.columns", (Object[])new Object[]{names}));
    }

    public boolean loadDb(AccessHitModel hits) throws IOException {
        String[] tables = this.getTables();
        String[] unusedTables = this.getUnusedTables();
        if (log.isInfoEnabled()) {
            log.info((Object)("D\u00e9couverte de " + tables.length + " tables."));
        }
        if (log.isDebugEnabled() && unusedTables.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is " + unusedTables.length + " unused table(s) :"));
            }
            for (String missingTable : unusedTables) {
                Table table = this.getConnexion().getTable(missingTable);
                List<String> tmp = this.getColumnNames(table);
                Collections.sort(tmp);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(missingTable + " with columns : " + tmp));
            }
        }
        AccessEntityMeta<?>[] metas = this.getMetas();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register " + metas.length + " metas."));
        }
        if (this.hasError()) {
            AccessEntityMeta<?>[] metaWithError = this.getMetaWithError();
            if (log.isErrorEnabled()) {
                log.error((Object)("There is " + metaWithError.length + " meta(s) with error(s)."));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"No error detected on database structure.");
        }
        if (this.hasWarning()) {
            AccessEntityMeta<?>[] metaWithWarning = this.getMetaWithWarning();
            if (log.isWarnEnabled()) {
                log.warn((Object)("There is " + metaWithWarning.length + " meta(s) with warning(s)."));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"No warning detected on database structure.");
        }
        if (this.hasError()) {
            return false;
        }
        for (AccessEntityMeta<?> meta : this.getMetas()) {
            if (meta instanceof ReferentielEntityMeta) continue;
            Map<String, Object>[] data = this.getTableData(meta);
            if (hits == null) continue;
            long hit = hits.getHit(meta.getType());
            hits.addHit0(meta.getType(), true, hit, hit + (long)data.length);
        }
        for (AccessEntityMeta<?> meta : this.getMetas()) {
            int[] errorRows = meta.getErrorRows();
            if (errorRows == null || errorRows.length <= 0 || !log.isErrorEnabled()) continue;
            log.error((Object)("[" + meta.getType() + "] Could not load " + errorRows.length + " row(s) : " + Arrays.toString(errorRows)));
        }
        if (log.isDebugEnabled() && hits != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Nombre d'objets d\u00e9tect\u00e9s : " + hits.getTotalHit()));
            }
            for (Map.Entry entry : hits) {
                ObserveEntityEnum type = (ObserveEntityEnum)entry.getKey();
                Long total = entry.getValue();
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("[" + type + "] find " + total + " objects to import."));
            }
        }
        return true;
    }

    public void destroy() {
        this.cache.clear();
        this.unusedTables = null;
        this.tables = null;
    }

    protected void registerEntity(List<AccessEntityMeta<?>> metas, AccessEntityMeta<?> meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("check entity :\n" + meta));
        }
        meta = (AccessEntityMeta)ConstructorUtils.invokeConstructor(meta.getClass(), meta);
        ObserveEntityEnum type = meta.getType();
        String tableName = meta.getTableName();
        Table table = this.getTable(meta);
        if (table == null) {
            String message = "No table [" + tableName + "] found for type " + type;
            meta.addError(message);
        } else {
            ArrayList<AccessEntityMeta.PropertyMapping> mapping = new ArrayList<AccessEntityMeta.PropertyMapping>();
            for (AccessEntityMeta.PropertyMapping entry : meta.getPropertyMapping()) {
                String key = entry.getProperty();
                String value = entry.getColumn();
                try {
                    table.getColumn(value);
                    mapping.add(entry);
                }
                catch (Exception e) {
                    String message = "Could not found column [" + tableName + " - " + value + "] for property [" + type + " - " + key + "]";
                    if ("commentaire".equals(key)) {
                        meta.addWarning(message);
                        continue;
                    }
                    meta.addError(message);
                }
            }
            meta.setPropertyMapping(mapping.toArray(new AccessEntityMeta.PropertyMapping[mapping.size()]));
            for (String pkey : meta.getPkeys()) {
                try {
                    table.getColumn(pkey);
                }
                catch (Exception e) {
                    String message = "Could not found pkey column [" + tableName + " - " + pkey + "]";
                    meta.addError(message);
                }
            }
        }
        metas.add(meta);
    }

    protected static Set<AccessEntityMeta<?>> loadNatives() {
        HashSet result = new HashSet();
        for (AccessEntityMeta meta : ServiceLoader.load(AccessEntityMeta.class)) {
            result.add(meta);
        }
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.ActiviteBateau, "ACT_BATEAU", "C_ACT_BATEAU");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.ActiviteEnvironnante, "ACT_ENV", "C_ACT_ENV");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.Bateau, "BATEAU", "C_BAT");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.Programme, "CAMPAGNE", "C_CAMP");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.CategorieBateau, "CAT_BATEAU", "C_CAT_B");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.CategoriePoids, "CAT_POIDS", "C_CAT_P");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.CauseCoupNul, "COUP_NUL", "C_R_COUP_NUL");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.DevenirObjet, "DEV_DCP", "C_DEVENIR_DCP");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.DevenirFaune, "DEV_F", "C_DEVENIR_F");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.EspeceFaune, "ESPECE_F", "C_ESP_F");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.EspeceThon, "ESPECE_T", "C_ESP");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.GroupeEspeceFaune, "GR_ESP_F", "C_GR_ESP_F");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.ModeDetection, "MODE_DETECT", "C_MODE_DETECT");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.CauseNonCoupSenne, "NON_COUP_SENNE", "C_NON_COUP_DE_SENNE");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.Observateur, "OBSERVATEUR", "ID_OBSERVATEUR");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.OperationObjet, "OPERA_DCP", "C_OPERA_OBJ");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.Pays, "PAYS", "C_PAYS");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.Senne, "SENNE", "ID_SENNE");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.StatutEspece, "STATUT_ESP_DCP", "C_STATUT_ESP_DCP");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.SystemeObserve, "SYST_OBS", "C_SYST_OBS");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.TypeBalise, "TYPE_BALISE", "C_BALISE");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.TypeBateau, "TYPE_BATEAU", "C_TYP_B");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.TypeObjet, "TYPE_DCP", "C_NATURE_DCP");
        AccessDataSource.loadReferentiel(result, ObserveEntityEnum.VentBeaufort, "VENT_BEAUFORT", "C_BEAUFORT");
        return result;
    }

    protected static ReferentielEntityMeta<?> loadReferentiel(Set<AccessEntityMeta<?>> result, ObserveEntityEnum type, String tableName, String pkeys) {
        ReferentielEntityMeta meta = new ReferentielEntityMeta(type, tableName, new String[]{pkeys}, "code", Integer.class, pkeys);
        result.add(meta);
        return meta;
    }
}

