/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report;

import fr.ird.observe.report.ReportBuilder;
import fr.ird.observe.report.model.Report;
import fr.ird.observe.report.model.ReportExecute;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.report.ResultTableModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportModel
extends AdminActionModel {
    private static final Log log = LogFactory.getLog(ReportModel.class);
    public static final String SELECTED_MAREE_PROPERTY_NAME = "selectedMaree";
    public static final String SELECTED_REPORT_PROPERTY_NAME = "selectedReport";
    public static final String REPORTS_PROPERTY_NAME = "reports";
    public static final String REPORT_FILE_PROPERTY_NAME = "reportFile";
    public static final String AUTO_COPY_TO_CLIPBOARD_PROPERTY_NAME = "autoCopyToClipboard";
    public static final String VARIABLES_PROPERTY_NAME = "variables";
    public static final String VALID_PROPERTY_NAME = "valid";
    public static final Pattern REPORT_DEFINITION_PATTERN = Pattern.compile("report.(\\w+).name");
    protected File reportFile;
    protected List<Report> reports;
    protected Report selectedReport;
    protected Map<String, String> variables = new TreeMap<String, String>();
    protected ResultTableModel resultModel;
    protected boolean autoCopyToClipboard;
    protected Boolean valid;
    protected ReportExecute reportExecute;

    public ReportModel() {
        super(AdminStep.REPORT);
    }

    public ReportExecute getReportExecute() {
        if (this.reportExecute == null) {
            this.reportExecute = new ReportExecute();
        }
        return this.reportExecute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Report> loadReports(URL resource) throws IOException {
        ReportBuilder builder = new ReportBuilder();
        try {
            List result;
            List list = result = builder.load(resource);
            return list;
        }
        finally {
            builder.clear();
        }
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        File old = this.reportFile;
        this.reportFile = reportFile;
        this.firePropertyChange(REPORT_FILE_PROPERTY_NAME, old, reportFile);
        this.reports = null;
        this.getReports();
    }

    public boolean isAutoCopyToClipboard() {
        return this.autoCopyToClipboard;
    }

    public void setAutoCopyToClipboard(boolean autoCopyToClipboard) {
        boolean oldValue = this.autoCopyToClipboard;
        this.autoCopyToClipboard = autoCopyToClipboard;
        this.firePropertyChange(AUTO_COPY_TO_CLIPBOARD_PROPERTY_NAME, oldValue, autoCopyToClipboard);
    }

    public ResultTableModel getResultModel() {
        if (this.resultModel == null) {
            this.resultModel = new ResultTableModel();
        }
        return this.resultModel;
    }

    public boolean isInit() {
        return this.reports != null;
    }

    public List<Report> getReports() {
        if (this.reports == null) {
            try {
                URL resource = this.reportFile.toURI().toURL();
                List<Report> reports = this.loadReports(resource);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add loaded " + reports.size() + " report(s)."));
                }
                this.setReports(reports);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load reports definition file (" + this.reportFile + ").", e);
            }
        }
        return this.reports;
    }

    public Report getSelectedReport() {
        return this.selectedReport;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setReports(List<Report> reports) {
        this.reports = reports;
        this.firePropertyChange(REPORTS_PROPERTY_NAME, reports);
    }

    public void setSelectedReport(Report selectedReport) {
        this.variables.clear();
        this.valid = null;
        Report old = this.selectedReport;
        this.selectedReport = selectedReport;
        this.firePropertyChange(SELECTED_REPORT_PROPERTY_NAME, old, selectedReport);
    }

    public boolean isValid() {
        return this.valid != null && this.valid != false;
    }

    public void addVariable(String name, String value) {
        this.variables.put(name, value);
        this.valid = null;
        this.firePropertyChange(VARIABLES_PROPERTY_NAME, null, this.variables);
    }

    public void resetVariables() {
        this.variables.clear();
        this.firePropertyChange(VARIABLES_PROPERTY_NAME, null, this.variables);
    }

    public void setValid(boolean valid) {
        Boolean old = this.valid;
        this.valid = valid;
        this.firePropertyChange(VALID_PROPERTY_NAME, old, valid);
    }
}

