/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.ui.admin.access.AccessEntity;
import fr.ird.observe.ui.admin.access.AccessEntityProxyHandler;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class AccessEntityMeta<E extends TopiaEntity> {
    private static final Log log = LogFactory.getLog(AccessEntityMeta.class);
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected PropertyMapping[] propertyMapping;
    protected AssociationMapping[] reverseAssociationMapping;
    protected AssociationMapping[] assocationMapping;
    protected final ObserveEntityEnum type;
    protected final List<String> pkeys;
    protected Long rowCount;
    protected String tableName;
    protected final List<String> warnings;
    protected final List<String> errors;
    protected int[] errorRows;

    protected AccessEntityMeta(AccessEntityMeta<E> source) {
        this.type = source.type;
        this.pkeys = source.pkeys;
        this.tableName = source.tableName;
        this.propertyMapping = source.propertyMapping;
        this.assocationMapping = source.assocationMapping;
        this.reverseAssociationMapping = source.reverseAssociationMapping;
        this.warnings = new ArrayList<String>(source.warnings);
        this.errors = new ArrayList<String>(source.errors);
    }

    protected AccessEntityMeta(ObserveEntityEnum type, String tableName, String[] pkeys, Object[] association, Object[] reverseProperties, Object ... properties) {
        Class typeP;
        String property;
        int i;
        int max;
        if (properties.length % 3 != 0) {
            throw new IllegalArgumentException("'properties' parameter length must be modulo 3 but was " + properties.length);
        }
        if (reverseProperties.length % 2 != 0) {
            throw new IllegalArgumentException("'reverseProperties' parameter length must be modulo 2 but was " + association.length);
        }
        if (association.length % 2 != 0) {
            throw new IllegalArgumentException("'association' parameter length must be modulo 2 but was " + association.length);
        }
        this.type = type;
        this.tableName = tableName;
        this.pkeys = Arrays.asList(pkeys);
        int nbProperties = properties.length / 3;
        int nbAssociations = association.length / 2;
        int nbReverseProperties = reverseProperties.length / 2;
        this.propertyMapping = new PropertyMapping[nbProperties];
        this.assocationMapping = new AssociationMapping[nbAssociations];
        this.reverseAssociationMapping = new AssociationMapping[nbReverseProperties];
        this.warnings = new ArrayList<String>();
        this.errors = new ArrayList<String>();
        if (nbProperties == 0) {
            throw new IllegalStateException("Can not have no properties for " + type);
        }
        if (nbProperties > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + type + "] will add " + nbProperties + " properties."));
            }
            max = properties.length;
            for (i = 0; i < max; i += 3) {
                property = (String)properties[i];
                typeP = (Class)properties[i + 1];
                String column = (String)properties[i + 2];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + type + "] property " + property + " for column " + column));
                }
                this.propertyMapping[i / 3] = new PropertyMapping(typeP, property, column);
            }
        }
        if (nbAssociations > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + type + "] will add " + nbAssociations + " associations."));
            }
            max = association.length;
            for (i = 0; i < max; i += 2) {
                property = (String)association[i];
                typeP = (Class)association[i + 1];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + type + "] association " + property + " type : " + typeP));
                }
                this.assocationMapping[i / 2] = new AssociationMapping(typeP, property);
            }
        }
        if (nbReverseProperties > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + type + "] will add " + nbReverseProperties + " reverse associations."));
            }
            max = reverseProperties.length;
            for (i = 0; i < max; i += 2) {
                property = (String)reverseProperties[i];
                typeP = (Class)reverseProperties[i + 1];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + type + "] reverse association " + property + " type : " + typeP));
                }
                this.reverseAssociationMapping[i / 2] = new AssociationMapping(typeP, property);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessEntityMeta that = (AccessEntityMeta)o;
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        return this.tableName.equals(that.tableName);
    }

    public int hashCode() {
        int result = this.tableName.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public void addWarning(String message) {
        this.warnings.add(message);
    }

    public void setErrorRows(int[] errorRows) {
        this.errorRows = errorRows;
    }

    public int[] getErrorRows() {
        return this.errorRows;
    }

    public E newEntity(int rowId, Object[] pkey) {
        try {
            Object e = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{AccessEntity.class, this.getType().getContract()}, new AccessEntityProxyHandler(this, rowId, pkey));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create a proxy [" + this.getType() + ":" + Arrays.toString(pkey) + "] " + e));
            }
            return (E)((TopiaEntity)e);
        }
        catch (Exception e1) {
            throw new RuntimeException("Could not instanciate entity of type " + this.getType(), e1);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public PropertyMapping getPropertyMapping(String propertyName) {
        for (PropertyMapping propertyMapping : this.propertyMapping) {
            if (!propertyMapping.getProperty().equals(propertyName)) continue;
            return propertyMapping;
        }
        return null;
    }

    public AssociationMapping getReverseAssociationMapping(String propertyName) {
        for (AssociationMapping propertyMapping : this.reverseAssociationMapping) {
            if (!propertyMapping.getProperty().equals(propertyName)) continue;
            return propertyMapping;
        }
        return null;
    }

    public String getPropertyColumnName(String propertyName) {
        PropertyMapping mapping = this.getPropertyMapping(propertyName);
        return mapping == null ? null : mapping.getColumn();
    }

    public boolean containsProperty(String propertyName) {
        PropertyMapping mapping = this.getPropertyMapping(propertyName);
        return mapping != null;
    }

    public boolean containsReverseAssociation(String propertyName) {
        AssociationMapping mapping = this.getReverseAssociationMapping(propertyName);
        return mapping != null;
    }

    public List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (PropertyMapping m : this.propertyMapping) {
            result.add(m.getProperty());
        }
        return result;
    }

    public PropertyMapping[] getPropertyMapping() {
        return this.propertyMapping;
    }

    public AssociationMapping[] getAssocationMapping() {
        return this.assocationMapping;
    }

    public AssociationMapping[] getReverseAssociationMapping() {
        return this.reverseAssociationMapping;
    }

    public ObserveEntityEnum getType() {
        return this.type;
    }

    public List<String> getPkeys() {
        return this.pkeys;
    }

    public Long getRowCount() {
        return this.rowCount;
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarning() {
        return !this.warnings.isEmpty();
    }

    public String[] getWarnings() {
        return this.warnings.toArray(new String[this.warnings.size()]);
    }

    public String[] getErrors() {
        return this.errors.toArray(new String[this.errors.size()]);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPropertyMapping(PropertyMapping[] propertyMapping) {
        this.propertyMapping = propertyMapping;
    }

    public void setRowCount(Long rowCount) {
        this.rowCount = rowCount;
    }

    public void checkProperty(String name) throws IllegalArgumentException {
        if (!this.containsProperty(name)) {
            throw new IllegalArgumentException(name + " is not a property of " + this + ", availables : " + this.getPropertyNames());
        }
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("type", (Object)this.getType());
        sb.append("tableName", (Object)this.getTableName());
        sb.append("pkeys", this.getPkeys());
        sb.append("propertyNames", this.getPropertyNames());
        return sb.toString();
    }

    public static class AssociationMapping
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Class<?> type;
        protected String property;

        public AssociationMapping(Class<?> type, String property) {
            this.type = type;
            this.property = property;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class PropertyMapping
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Class<?> type;
        protected String property;
        protected String column;

        public PropertyMapping(Class<?> type, String property, String column) {
            this.type = type;
            this.property = property;
            this.column = column;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getProperty() {
            return this.property;
        }

        public String getColumn() {
            return this.column;
        }
    }
}

