/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.list.impl.ActivitesUI;
import fr.ird.observe.ui.content.open.ContentOpenableUI;
import fr.ird.observe.ui.content.open.impl.ActiviteUI;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.nuiton.i18n.I18n;

public class CloseAndCreateUIAction
extends AbstractUIAction {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_NAME = "closeAndCreate";

    public CloseAndCreateUIAction(ObserveMainUI mainUI) {
        super(mainUI, ACTION_NAME, I18n.n_((String)"observe.action.closeAndCreate"), I18n.n_((String)"observe.action.closeAndCreate.tip"), "add");
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent c = (JComponent)e.getSource();
                ContentUI ui = (ContentUI)((Object)c.getClientProperty("ui"));
                if (ui == null) {
                    throw new IllegalStateException("could not find client property ui on component" + c);
                }
                if (ui instanceof ContentOpenableUI) {
                    ((ContentOpenableUI)ui).closeAndCreateData();
                    return;
                }
                if (ui instanceof ActivitesUI) {
                    JTree tree = CloseAndCreateUIAction.this.getMainUI().getNavigation();
                    ObserveTreeHelper treeHelper = CloseAndCreateUIAction.this.getMainUI().getTreeHelper();
                    boolean wasCollapsed = AbstractUIAction.isOpenActiviteNodeCollapsed(tree, treeHelper, CloseAndCreateUIAction.this.getMainUI().getDataContext());
                    treeHelper.selectOpenNode((JAXXContext)CloseAndCreateUIAction.this.getMainUI(), Activite.class);
                    TreePath path = tree.getSelectionPath();
                    ActiviteUI selectedUI = (ActiviteUI)ObserveContext.get().getSelectedContentUI();
                    selectedUI.closeAndCreateData();
                    if (wasCollapsed) {
                        tree.collapsePath(path);
                    }
                    return;
                }
                throw new IllegalStateException("Can not come here!");
            }
        });
    }
}

