/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import java.io.File;
import java.util.Locale;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public enum ObserveConfigOption implements ApplicationConfig.OptionDef
{
    CONFIG_FILE("config.file", I18n.n_((String)"observe.config.configFileName.description"), ObserveRunner.isAdmin() ? "observe-admin-config" : "observe-config", String.class, true, true),
    DATA_DIRECTORY("data.directory", I18n.n_((String)"observe.config.defaultDataDirectory.description"), "${user.home}/.observe", File.class, false, false),
    DB_DIRECTORY("db.directory", I18n.n_((String)"observe.config.defaultLocalDbDirectory.description"), "${data.directory}/db", File.class, false, false),
    INITIAL_DB_DUMP("initial.db.dump", I18n.n_((String)"observe.config.defaultInitialDbDump.description"), "${data.directory}/initial-database.sql.gz", File.class, false, false),
    BACKUP_DIRECTORY("backup.directory", I18n.n_((String)"observe.config.defaultBackupDirectory.description"), "${data.directory}/backup", File.class, false, false),
    RESOURCES_DIRECTORY("resources.directory", "resourcesDirectory", I18n.n_((String)"observe.config.defaultResourcesDirectory.description"), "${data.directory}/resources-${version}", File.class, false, false),
    I18N_DIRECTORY("i18n.directory", "i18nDirectory", I18n.n_((String)"observe.config.defaultI18nDirectory.description"), "${resources.directory}/i18n", File.class, false, false),
    REPORT_DIRECTORY("report.directory", "reportDirectory", I18n.n_((String)"observe.config.defaultReportDirectory.description"), "${resources.directory}/report", File.class, false, false),
    VALIDATION_REPORT_DIRECTORY("validation.report.directory", "validationReportDirectory", I18n.n_((String)"observe.config.defaultValidationReportDirectory.description"), "${data.directory}/validation-report", File.class, false, false),
    TMP_DIRECTORY("tmp.directory", I18n.n_((String)"observe.config.defaultTmpDirectory.description"), "${data.directory}/tmp", File.class, false, false),
    H2_LOGIN("h2.username", I18n.n_((String)"observe.config.h2.login.description"), "sa", String.class, true, true),
    H2_PASSWORD("h2.password", I18n.n_((String)"observe.config.h2.password.description"), "sa", String.class, true, true),
    H2_CAN_MIGRATE("h2.canMigrate", I18n.n_((String)"observe.config.h2.can.migrate.description"), "true", Boolean.class, false, false),
    OBSTUNA_URL("obstuna.url", I18n.n_((String)"observe.config.obstuna.url.description"), "jdbc:postgresql:///obstuna", String.class, false, false),
    OBSTUNA_LOGIN("obstuna.username", I18n.n_((String)"observe.config.obstuna.login.description"), "utilisateur", String.class, false, false),
    OBSTUNA_PASSWORD("obstuna.password", I18n.n_((String)"observe.config.obstuna.password.description"), "", String.class, true, false),
    OBSTUNA_USE_SSL_CERT("obstuna.useSsl", I18n.n_((String)"observe.config.obstuna.useSsl.description"), "false", Boolean.class, false, false),
    OBSTUNA_SSL_CERTIFICAT_FILE("obstuna.sslCertificatFile", I18n.n_((String)"observe.config.obstuna.sslCertificatFile.description"), "${data.directory}/obstuna.jks", File.class, false, false),
    OBSTUNA_SSL_CERTIFICAT_PASSWORD("obstuna.sslCertificatPassword", I18n.n_((String)"observe.config.obstuna.sslCertificatPassword.description"), "", char[].class, true, false),
    OBSTUNA_CAN_MIGRATE("pg.canMigrate", I18n.n_((String)"observe.config.pg.can.migrate.description"), "false", Boolean.class, false, false),
    DEFAULT_DB_MODE("defaultDbMode", "defaultDbMode", I18n.n_((String)"observe.config.defaultDbMode"), DbMode.USE_LOCAL.name(), DbMode.class, false, false),
    DEFAULT_CREATION_MODE("defaultCreationMode", "defaultCreationMode", I18n.n_((String)"observe.config.defaultCreationMode"), CreationMode.IMPORT_EXTERNAL_DUMP.name(), CreationMode.class, false, false),
    STORE_REMOTE_STORAGE("ui.storeRemoteStorage", "storeRemoteStorage", I18n.n_((String)"observe.config.ui.storeRemoteStorage"), "true", Boolean.class, false, false),
    LOAD_LOCAL_STORAGE("ui.loadLocalStorage", "loadLocalStorage", I18n.n_((String)"observe.config.ui.loadLocalStorage"), "true", Boolean.class, false, false),
    SHOW_MIGRATION_PROGRESSION("showMigrationProgression", "showMigrationProgression", I18n.n_((String)"observe.config.showMigrationProgression"), "true", Boolean.class, false, false),
    SHOW_MIGRATION_SQL("showMigrationSql", "showMigrationSql", I18n.n_((String)"observe.config.showMigrationSql"), "true", Boolean.class, false, false),
    SHOW_SQL("showSql", "showSql", I18n.n_((String)"observe.config.showSql"), "false", Boolean.class, false, false),
    DEFAULT_GPS_MAX_DELAY("defaultGpsMaxDelay", "defaultGpsMaxDelay", I18n.n_((String)"observe.config.defaultGpsMaxDelay"), "60", Integer.class, false, false),
    DEFAULT_GPS_MAX_SPEED("defaultGpsMaxSpeed", "defaultGpsMaxSpeed", I18n.n_((String)"observe.config.defaultGpsMaxSpeed"), "25.0f", Float.class, false, false),
    CHANGE_SYNCHRO_SRC("ui.changeSynchroSrc", "changeSynchroSrc", I18n.n_((String)"observe.config.ui.changeSynchroSrc"), "false", Boolean.class, false, false),
    SHOW_NUMBER_EDITOR_BUTTON("ui.showNumberEditorButton", "showNumberEditorButton", I18n.n_((String)"observe.config.ui.showNumberEditorButton"), "true", Boolean.class, false, false),
    AUTO_POPUP_NUMBER_EDITOR("ui.autoPopupNumberEditor", "autoPopupNumberEditor", I18n.n_((String)"observe.config.ui.autoPopupNumberEditor"), "false", Boolean.class, false, false),
    FULL_SCREEN("ui.fullScreen", "fullScreen", I18n.n_((String)"observe.config.ui.fullscreen"), "false", Boolean.class, false, false),
    LOCALE("ui.locale", "locale", I18n.n_((String)"observe.config.ui.locale"), Locale.FRANCE.toString(), Locale.class, false, false),
    DB_LOCALE("db.locale", "dbLocale", I18n.n_((String)"observe.config.db.locale"), Locale.FRANCE.toString(), Locale.class, false, false),
    OBSERVATION_FAUNE_ASSOCIEE("observation.fauneAssociee", "observationFauneAssociee", I18n.n_((String)"observe.config.observation.fauneAssociee"), "1", Integer.class, false, false),
    OBSERVATION_REJETS_THONS("observation.rejetsThons", "observationRejetsThons", I18n.n_((String)"observe.config.observation.rejetsThons"), "1", Integer.class, false, false),
    OBSERVATION_MENSURATIONS("observation.mensurations", "observationMensurations", I18n.n_((String)"observe.config.observation.mensurations"), "1", Integer.class, false, false),
    OBSERVATION_OBJET_FLOTTANT("observation.objetFlottant", "observationObjetFlottant", I18n.n_((String)"observe.config.observation.objetFlottant"), "1", Integer.class, false, false),
    OBSERVATION_ACTIVITES_DETAILLEES("observation.activitesDetaillees", "observationActivitesDetaillees", I18n.n_((String)"observe.config.observation.activitesDetaillees"), "1", Integer.class, false, false),
    OBSERVATION_MAMMIFERES("observation.mammiferes", "observationMammiferes", I18n.n_((String)"observe.config.observation.mammiferes"), "1", Integer.class, false, false),
    OBSERVATION_OISEAUX("observation.oiseaux", "observationOiseaux", I18n.n_((String)"observe.config.observation.oiseaux"), "1", Integer.class, false, false),
    OBSERVATION_GLEURE("observation.gleure", "observationGleure", I18n.n_((String)"observe.config.observation.gleure"), "1", Integer.class, false, false);

    protected final String key;
    protected final String propertyKey;
    protected final String description;
    protected final Class<?> type;
    protected String defaultValue;
    protected boolean _transient;
    protected boolean _final;
    protected boolean admin;

    private ObserveConfigOption(String key, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
        this(key, null, description, defaultValue, type, _transient, _final);
    }

    private ObserveConfigOption(String key, String propertyKey, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this._final = _final;
        this._transient = _transient;
        this.propertyKey = propertyKey;
    }

    public boolean isFinal() {
        return this._final;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return I18n._((String)this.description);
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }
}

