/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.H2DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.awt.Window;
import java.io.File;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageBackupUILauncher
extends StorageUILauncher {
    private static Log log = LogFactory.getLog(StorageBackupUILauncher.class);

    public StorageBackupUILauncher(JAXXContext context, Window frame, String title) {
        super(context, frame, title);
    }

    @Override
    protected void init(StorageUI ui) {
        super.init(ui);
        ui.getBACKUP().getDoBackup().setSelected(true);
        ui.getBACKUP().getDoBackup().setVisible(false);
        DataSource source = this.getStorage();
        StorageUIModel model = ui.getModel();
        model.setCanCreateLocalService(false);
        if (source instanceof H2DataSource) {
            model.setCanUseLocalService(true);
            model.setDbMode(DbMode.USE_LOCAL);
        } else {
            model.setCanUseRemoteService(true);
            model.setDbMode(DbMode.USE_REMOTE);
        }
        model.setSteps(new StorageStep[]{StorageStep.BACKUP, StorageStep.SELECT_DATA, StorageStep.CONFIRM});
        ui.setTitle(this.title);
        try {
            DataSelectionModel dataModel = new DataSelectionModel();
            dataModel.setUseData(true);
            dataModel.setUseOpenData(true);
            dataModel.setUseReferentiel(false);
            DataSelectionModel.populate((DataSelectionModel)dataModel, (DataService)this.getDataService(), (DataSource)source);
            dataModel.addAllSelectedData();
            model.setSelectDataModel(dataModel);
            ui.getSELECT_DATA().initTree();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    protected void doAction(StorageUI ui) {
        super.doAction(ui);
        StorageUIHandler handler = this.getStorageUIHandler();
        DataSource service = this.getStorage();
        StorageUIModel storageModel = ui.getModel();
        File backupFile = storageModel.getBackupFile();
        DataSelectionModel dataModel = storageModel.getSelectDataModel();
        Set marees = null;
        if (dataModel != null && !dataModel.isDataFull()) {
            marees = dataModel.getSelectedData();
        }
        handler.backupLocalDatabase(service, backupFile, marees);
    }

    protected DataSource getStorage() {
        DataSource source = ObserveContext.get().getDataSource();
        return source;
    }

    protected DataService getDataService() {
        return ObserveContext.get().getDataService();
    }
}

