/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table;

import fr.ird.observe.BinderService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUI;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.tree.ObserveNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.EntityListUpdator;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;

public abstract class ContentTableUIHandler<E extends TopiaEntity, D extends TopiaEntity>
extends ContentUIHandler<E> {
    private static Log log = LogFactory.getLog(ContentTableUIHandler.class);
    private TopiaEntityBinder<D> childLoador;

    protected abstract void onSelectedRowChanged(int var1, D var2, boolean var3);

    public ContentTableUIHandler(ContentTableUI<E, D> ui) {
        super(ui, DataContextType.Calee, null);
    }

    @Override
    protected TopiaEntityBinder<E> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        ContentUIModel model = this.getModel();
        Class beanType = model.getBeanType();
        TopiaEntityBinder r = binderService.getTopiaBinder(beanType, binderName);
        if (r == null) {
            String[] properties = ((ContentTableUIModel)model).getParentProperties();
            BinderBuilder builder = new BinderBuilder(beanType, properties);
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{properties[0]});
            r = binderService.registerTopiaBinder(beanType, builder, binderName);
        }
        return r;
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String activiteId = this.getSelectedParentId();
        if (activiteId.equals(dataContext.getOpenActiviteId())) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n._((String)"observe.message.activite.not.open"));
        return ContentMode.READ;
    }

    public ContentTableUIModel<E, D> getModel() {
        return (ContentTableUIModel)super.getModel();
    }

    public ContentTableUI<E, D> getUi() {
        return (ContentTableUI)super.getUi();
    }

    public final D getTableEditBean() {
        return ((ContentTableUIModel)this.getModel()).getTableEditBean();
    }

    public final EntityListUpdator<E, D> getChildsUpdator() {
        return ((ContentTableUIModel)this.getModel()).getChildsUpdator();
    }

    public final TopiaEntityBinder<D> getChildLoador() {
        if (this.childLoador == null) {
            this.childLoador = this.createChildLoador(this.getBinderService());
        }
        return this.childLoador;
    }

    protected abstract void initTableUI(DefaultTableCellRenderer var1);

    protected TopiaEntityBinder<D> createChildLoador(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        Class childBeanType = ((ContentTableUIModel)this.getModel()).getChildType();
        TopiaEntityBinder c = binderService.getTopiaBinder(childBeanType, binderName);
        if (c == null) {
            String[] properties = ((ContentTableUIModel)this.getModel()).getChildProperties();
            BinderBuilder builder = new BinderBuilder(childBeanType, properties);
            c = binderService.registerTopiaBinder(childBeanType, builder, binderName);
        }
        this.childLoador = c;
        return this.childLoador;
    }

    protected E loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String id = null;
        if (Calee.class.equals(this.getModel().getBeanType())) {
            id = dataContext.getSelectedCaleeId();
        } else if (ObjetFlottant.class.equals(this.getModel().getBeanType())) {
            id = dataContext.getSelectedObjetFlottantId();
        } else if (EchantillonFaune.class.equals(this.getModel().getBeanType())) {
            id = dataContext.getSelectedCaleeId();
            id = dataService.getEchantillonFauneId(dataSource, id);
        }
        if (id == null) {
            throw new IllegalStateException("Could not find id form " + this);
        }
        Object editBean = this.getBean();
        dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
        Collection<D> data = this.loadChilds(editBean);
        this.getChildsUpdator().setChilds(editBean, data);
        this.getModel().setMode(mode);
        ((ContentTableUI)this.getUi()).getTableModel().attachModel();
        return editBean;
    }

    protected Collection<D> loadChilds(E bean) {
        Collection childs = this.getChildsUpdator().getChilds(bean);
        ArrayList data = new ArrayList();
        if (childs != null && !childs.isEmpty()) {
            TopiaEntityBinder<D> loader = this.getChildLoador();
            for (TopiaEntity c : childs) {
                try {
                    Object c2 = ((ContentTableUIModel)this.getModel()).newTableEditBean();
                    loader.load((Object)c, c2, true, new String[0]);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    @Override
    public void initUI() throws Exception {
        DataSource service = this.getDataSource();
        ContentTableUIHandler.attachTopiaContext(service, (TopiaEntityAbstract)this.getTableEditBean());
        super.initUI();
        ContentUI ui = this.getUi();
        ContentTableModel tableModel = ((ContentTableUI)ui).getTableModel();
        ui.setContextValue(tableModel);
        SwingUtil.getLayer((JComponent)ui.getBody()).setUI(null);
        SwingUtil.getLayer((JComponent)((ContentTableUI)ui).getExtraZone()).setUI((LayerUI)ui.getBlockLayerUI());
        SwingUtil.getLayer((JComponent)((ContentTableUI)ui).getEditor()).setUI((LayerUI)((ContentTableUI)ui).getEditorBlockLayerUI());
        this.initTableUI(new DefaultTableCellRenderer());
        tableModel.addPropertyChangeListener("selectedRow", new PropertyChangeListener((ContentTableUI)ui){
            final /* synthetic */ ContentTableUI val$ui;
            {
                this.val$ui = contentTableUI;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContentTableModel model = (ContentTableModel)evt.getSource();
                Object bean = model.getRowBean();
                boolean create = bean.getTopiaId() == null;
                Integer selectedRow = (Integer)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("callback new selectedRow : " + selectedRow + " : " + bean.getTopiaId()));
                }
                ContentTableUIHandler.this.onSelectedRowChanged(selectedRow, bean, create);
                ((ContentTableUIModel)ContentTableUIHandler.this.getModel()).setRowSaved(!create);
                if (selectedRow == -1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)">>>>>>>>>> will clear selection...");
                    }
                    this.val$ui.getSelectionModel().clearSelection();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"<<<<<<<<<< has clear selection...");
                    }
                } else {
                    this.val$ui.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                }
            }
        });
    }

    @Override
    public void openUI() throws Exception {
        boolean canEdit;
        super.openUI();
        ContentMode mode = this.computeContentMode();
        ContentUI ui = this.getUi();
        int oldIndex = ((ContentTableUI)ui).getTableModel().getSelectedRow();
        ((ContentTableUI)ui).getTableModel().dettachModel();
        this.loadEditBean(mode, this.getDataContext(), this.getDataService(), this.getDataSource());
        boolean bl = canEdit = mode == ContentMode.UPDATE;
        if (canEdit) {
            ui.startEdit(null);
        }
        if (!((ContentTableUI)ui).getTableModel().isEmpty()) {
            if (((ContentTableUI)ui).getTableModel().getRowCount() <= oldIndex) {
                oldIndex = 0;
            }
            if (oldIndex == -1) {
                oldIndex = 0;
            }
            ((ContentTableUI)ui).getTableModel().changeSelectedRow(oldIndex);
        }
        if (canEdit) {
            this.getModel().setModified(false);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        String message = I18n.n_((String)"observe.message.updating.entity");
        ObserveNode node = (ObserveNode)ContentTableUIHandler.getTreeHelper((JAXXContext)this.getUi()).getSelectedNode();
        String entityLabel = this.getEntityLabel(((ObserveNode)node.getParent()).getInternalClass());
        message = I18n._((String)message, (Object[])new Object[]{I18n._((String)entityLabel)});
        ContentTableUIHandler.addMessage(this.getUi(), BeanValidatorScope.INFO, entityLabel, message);
        super.startEditUI(binding);
    }

    @Override
    protected boolean doSave(E bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<E> binder) throws Exception {
        boolean canContinue;
        ContentUI ui = this.getUi();
        List objets = ((ContentTableUI)ui).getTableModel().getData();
        try {
            canContinue = this.prepareSave(bean, objets);
        }
        catch (Exception e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
            canContinue = false;
        }
        if (!canContinue) {
            return false;
        }
        dataService.update(dataSource, null, bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected E onUpdate(TopiaContext tx, Object parentBean, E beanToSave) throws TopiaException {
        List childs = ((ContentTableUI)this.getUi()).getTableModel().getData();
        Object editBean = this.getBean();
        TopiaEntityBinder binder = this.getLoadBinder();
        TopiaEntityBinder<D> childBinder = this.getChildLoador();
        EntityListUpdator<E, D> childUpdator = this.getChildsUpdator();
        binder.copyExcluding(editBean, beanToSave, new String[]{childUpdator.getPropertyName()});
        ArrayList oldChilds = new ArrayList(childUpdator.getChilds(beanToSave));
        childUpdator.removeAll(beanToSave);
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)tx, ((ContentTableUIModel)this.getModel()).getChildType());
        for (TopiaEntity child : childs) {
            TopiaEntity childToSave;
            if (child.getTopiaId() == null) {
                Map map = childBinder.obtainProperties((Object)child, new String[0]);
                childToSave = dao.create(map);
            } else {
                childToSave = dao.findByTopiaId(child.getTopiaId());
                childBinder.load((Object)child, (Object)childToSave, false, new String[0]);
            }
            childUpdator.addToList(beanToSave, childToSave);
        }
        this.onUpdateFinalize(tx, beanToSave, oldChilds);
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        this.resetEditUI();
    }

    protected boolean prepareSave(E editBean, List<D> objets) throws Exception {
        return true;
    }

    protected void onUpdateFinalize(TopiaContext tx, E bean, Collection<D> oldChilds) {
    }

    protected ContentTableModel<E, D> getTableModel() {
        return ((ContentTableUI)this.getUi()).getTableModel();
    }
}

