/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveApplicationContext;
import fr.ird.observe.ObserveCLAction;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveResourceManager;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.UIHelper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.application.ApplicationRunner;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.i18n.init.UserI18nInitializer;
import org.nuiton.util.FileUtil;
import org.nuiton.util.LocaleConverter;
import org.nuiton.util.StringUtil;
import org.nuiton.util.converter.ConverterUtil;

public abstract class ObserveRunner
extends ApplicationRunner {
    private static Log log = LogFactory.getLog(ObserveRunner.class);
    protected static ObserveResourceManager resourceManager;
    protected static ObserveActionExecutor actionExecutor;
    public final boolean admin;
    public final boolean init;

    public static ObserveRunner getRunner() {
        return (ObserveRunner)ApplicationRunner.getRunner();
    }

    public static ObserveResourceManager getResourceManager() {
        if (resourceManager == null) {
            throw new IllegalStateException("No resourceManager initialized");
        }
        return resourceManager;
    }

    public static ObserveActionExecutor getActionExecutor() {
        if (actionExecutor == null) {
            actionExecutor = new ObserveActionExecutor();
        }
        return actionExecutor;
    }

    public abstract String getRunnerName();

    public static boolean isAdmin() {
        return ObserveRunner.getRunner().admin;
    }

    public ObserveRunner(boolean admin, String[] args) {
        super(args);
        this.admin = admin;
        this.init = true;
        this.initOnce();
    }

    public static void runAction(String actionLabel, Runnable action) {
        ObserveRunner.getActionExecutor().addAction(actionLabel, action);
    }

    public static void runAction(String actionLabel, Object invoker, String methodName, Object ... arguments) {
        Runnable action;
        try {
            action = ObserveRunner.getActionExecutor().createRunnable(invoker, methodName, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("could not create action " + actionLabel, e);
        }
        ObserveRunner.runAction(actionLabel, action);
    }

    protected void initOnce() {
        if (!this.init) {
            return;
        }
        ObserveConfigOption.CHANGE_SYNCHRO_SRC.setAdmin(true);
        ObserveConfigOption.OBSERVATION_ACTIVITES_DETAILLEES.setAdmin(true);
        ObserveConfigOption.OBSERVATION_FAUNE_ASSOCIEE.setAdmin(true);
        ObserveConfigOption.OBSERVATION_GLEURE.setAdmin(true);
        ObserveConfigOption.OBSERVATION_MAMMIFERES.setAdmin(true);
        ObserveConfigOption.OBSERVATION_MENSURATIONS.setAdmin(true);
        ObserveConfigOption.OBSERVATION_OBJET_FLOTTANT.setAdmin(true);
        ObserveConfigOption.OBSERVATION_OISEAUX.setAdmin(true);
        ObserveConfigOption.OBSERVATION_REJETS_THONS.setAdmin(true);
        ObserveConfigOption.H2_CAN_MIGRATE.setAdmin(true);
        ObserveConfigOption.OBSTUNA_CAN_MIGRATE.setAdmin(true);
        if (!ObserveRunner.isAdmin()) {
            for (ObserveConfigOption option : ObserveConfigOption.values()) {
                if (!option.isAdmin()) continue;
                option.setFinal(true);
            }
        }
        I18n.setInitializer((I18nInitializer)new DefaultI18nInitializer("observe"));
        I18n.init((Locale)Locale.getDefault());
        resourceManager = new ObserveResourceManager();
        Converter converter = ConverterUtil.getConverter(Date.class);
        if (converter != null) {
            ConvertUtils.deregister(Date.class);
            DateConverter dateConverter = new DateConverter();
            dateConverter.setUseLocaleFormat(true);
            ConvertUtils.register((Converter)dateConverter, Date.class);
        }
        ConvertUtils.register((Converter)new LocaleConverter(), Locale.class);
        ObserveRunner.getActionExecutor();
    }

    protected void onInit() throws Exception {
        log.info((Object)I18n._((String)"observe.runner.init", (Object[])new Object[]{new Date(), Arrays.toString(this.args)}));
        long t0 = System.nanoTime();
        ObserveConfig config = this.initConfig();
        log.info((Object)I18n._((String)"observe.runner.config.loaded", (Object[])new Object[]{config.getVersion()}));
        this.initUserDirectories(config);
        log.info((Object)I18n._((String)"observe.runner.user.directories.loaded", (Object[])new Object[]{config.getDataDirectory()}));
        this.initI18n(config);
        log.info((Object)I18n._((String)"observe.runner.i18n.loaded", (Object[])new Object[]{config.getLocale().getDisplayLanguage()}));
        this.initUIConfiguration(config);
        this.initContext(config);
        this.detectLocalDataBase(config);
        String time = StringUtil.convertTime((long)t0, (long)System.nanoTime());
        log.info((Object)I18n._((String)"observe.runner.context.loaded", (Object[])new Object[]{time}));
    }

    protected void onStart() throws Exception {
        log.info((Object)I18n._((String)"observe.runner.start", (Object[])new Object[]{new Date(), Arrays.toString(this.args)}));
        ObserveContext context = ObserveContext.get();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use context : " + (Object)((Object)context)));
        }
        UIHelper.checkJAXXContextEntries((JAXXContext)context, (JAXXContextEntryDef[])new JAXXContextEntryDef[]{ObserveContext.CONFIG_ENTRY_DEF, ObserveContext.ACTIONS_ENTRY_DEF, ObserveContext.DATA_SERVICE_ENTRY_DEF, ObserveContext.DECORATOR_SERVICE_ENTRY_DEF});
        ObserveConfig config = context.getConfig();
        if (config.containActions(ObserveConfig.Step.AfterInit)) {
            config.doAction(ObserveConfig.Step.AfterInit.ordinal());
            if (log.isInfoEnabled()) {
                log.info((Object)"Operation termin\u00e9es...");
            }
        }
        if (!config.isDisplayMainUI()) {
            log.info((Object)I18n._((String)"observe.runner.quit.withno.ui"));
            ObserveRunner.unlock();
            return;
        }
        ObserveMainUI ui = this.startUI(context, config);
        log.info((Object)I18n._((String)"observe.runner.ui.loaded"));
        if (!config.isLoadLocalStorage()) {
            ui.getStatus().setStatus(I18n._((String)"observe.runner.loaded", (Object[])new Object[]{config.getVersion()}));
            return;
        }
        ObserveRunner.runAction(I18n._((String)"observe.runner.load.database"), (Object)context, "initStorage", new Object[]{config, ui, true});
    }

    protected void onClose(boolean reload) throws Exception {
        if (ObserveServiceHelper.isInit()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will close context...");
            }
            ObserveContext.get().close();
        }
    }

    protected void onShutdown() throws Exception {
        log.info((Object)("ObServe shutdown at " + new Date()));
        I18n.close();
        ObserveRunner.getActionExecutor().terminatesAndWaits();
        Runtime.getRuntime().halt(0);
    }

    protected void onShutdown(Exception ex) {
        log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
        Runtime.getRuntime().halt(1);
    }

    protected void onError(Exception e) {
        ErrorDialogUI.showError((Exception)e);
        log.error((Object)e.getMessage(), (Throwable)e);
    }

    protected ObserveConfig initConfig() throws Exception {
        ObserveConfig config = new ObserveConfig();
        config.initConfig(resourceManager);
        config.parse(this.args);
        if (!ObserveRunner.isAdmin()) {
            for (ObserveConfigOption option : ObserveConfigOption.values()) {
                if (!option.isAdmin()) continue;
                config.setOption(option.getKey(), option.getDefaultValue());
            }
        }
        config.installSaveAction();
        return config;
    }

    protected void initUserDirectories(ObserveConfig config) throws IOException {
        File reportDirectory;
        File file;
        File dataDirectory = resourceManager.createDirectory(config, ObserveConfigOption.DATA_DIRECTORY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("user data directory : " + dataDirectory));
        }
        FileUtil.setCurrentDirectory((File)dataDirectory);
        resourceManager.createParentDirectory(config, ObserveConfigOption.DB_DIRECTORY, ObserveConfigOption.INITIAL_DB_DUMP);
        resourceManager.createDirectory(config, ObserveConfigOption.TMP_DIRECTORY);
        FileUtil.deleteRecursively((File)config.getTmpDirectory());
        resourceManager.createDirectory(config, ObserveConfigOption.BACKUP_DIRECTORY);
        File resourcesDirectory = resourceManager.createDirectory(config, ObserveConfigOption.RESOURCES_DIRECTORY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("user resource data directory : " + resourcesDirectory));
        }
        if (!(file = ObserveResourceManager.Resource.ui.getFile(resourcesDirectory)).exists()) {
            String message = I18n._((String)"observe.runner.copy.default.ui.file", (Object[])new Object[]{file});
            resourceManager.copyResource(ObserveResourceManager.Resource.ui, file, message);
        }
        if (!(file = ObserveResourceManager.Resource.report.getFile(reportDirectory = resourceManager.createDirectory(config, ObserveConfigOption.REPORT_DIRECTORY))).exists()) {
            String message = I18n._((String)"observe.runner.copy.default.report.file", (Object[])new Object[]{file});
            resourceManager.copyResource(ObserveResourceManager.Resource.report, file, message);
        }
        resourceManager.createDirectory(config, ObserveConfigOption.VALIDATION_REPORT_DIRECTORY);
    }

    protected void detectLocalDataBase(ObserveConfig config) throws IOException {
        boolean hasLocalStorage = ObserveServiceHelper.isLocalStorageExists((IObserveConfig)config);
        config.setLocalStorageExist(hasLocalStorage);
        if (!hasLocalStorage) {
            log.info((Object)I18n._((String)"observe.init.no.local.db.detected", (Object[])new Object[]{config.getLocalDBDirectory()}));
        }
        boolean hasInitialDb = ObserveServiceHelper.isInitialDbExists((IObserveConfig)config);
        config.setInitialDumpExist(hasInitialDb);
        if (!hasInitialDb) {
            log.info((Object)I18n._((String)"observe.init.no.initial.dump.detected", (Object[])new Object[]{config.getInitialDbDump()}));
        }
    }

    protected void initI18n(ObserveConfig config) {
        I18n.close();
        File i18nDirectory = config.getI18nDirectory();
        UserI18nInitializer i18nInitializer = new UserI18nInitializer(i18nDirectory, new DefaultI18nInitializer("observe"));
        I18n.setInitializer((I18nInitializer)i18nInitializer);
        long t00 = System.nanoTime();
        Locale locale = config.getLocale();
        I18n.init((Locale)locale);
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n language : " + locale));
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    protected void initUIConfiguration(ObserveConfig config) throws IOException {
        try {
            UIHelper.initNimbusLoookAndFeel();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"observe.warning.nimbus.landf"));
        }
        catch (Throwable e) {
            log.warn((Object)I18n._((String)"observe.warning.no.ui"));
            config.setCanUseUI(false);
        }
        if (config.isCanUseUI()) {
            File dir = config.getResourcesDirectory();
            File file = ObserveResourceManager.Resource.ui.getFile(dir);
            log.info((Object)I18n._((String)"observe.runner.loading.ui.configuration", (Object[])new Object[]{file}));
            Properties p = resourceManager.getResource(file);
            UIHelper.loadUIConfig((Properties)p);
        }
    }

    public ObserveContext initContext(ObserveConfig config) throws Exception {
        if (ObserveServiceHelper.isInit()) {
            throw new IllegalStateException("there is an already application context registred.");
        }
        ObserveContext instance = new ObserveContext();
        ObserveContext.CONFIG_ENTRY_DEF.setContextValue((JAXXContext)instance, (Object)config);
        instance.getDataService();
        instance.getDataContext();
        ObserveContext.ACTIONS_ENTRY_DEF.setContextValue((JAXXContext)instance, (Object)new ObserveCLAction());
        ObserveServiceHelper.set((ObserveApplicationContext)instance);
        ObserveServiceHelper.getDecoratorService();
        return instance;
    }

    protected ObserveMainUI startUI(ObserveContext context, ObserveConfig config) {
        ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
        final ObserveMainUI ui = uiHandler.initUI(context, config);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ui.setVisible(true);
            }
        });
        return ui;
    }
}

